/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

/// In this program, I assign sLFree (int* pointing to dseg_lo):
///    [Byte request size below is for Linux]
///
///    sLFree[0] to indicate whether dseg_lo is 8 byte aligned
///    sLFree[1] for <=6 word blocks list (<=16 byte request size)
///    sLFree[2] for <=10 word blocks list (<=32 byte request size)
///    sLFree[3] for <=18 word blocks list (<=64 byte request size)
///    sLFree[4] for <=26 word blocks list (<=96 byte request size)
///    sLFree[5] for <=34 word blocks list (<=128 byte request size)
///    sLFree[6] for <=50 word blocks list (<=192 byte request size)
///    sLFree[7] for <=66 word blocks list (<=256 byte request size)
///    sLFree[8] for <=130 word blocks list (<=512 byte request size)
///    sLFree[9] for <=258 word blocks list (<=1KB request size)
///    sLFree[10] for <=386 word blocks list (<=1.5KB request size)
///    sLFree[11] for <=514 word blocks list (<=2KB request size)
///    sLFree[12] for <=770 word blocks list (<=3KB request size)
///    sLFree[13] for <=1024 word blocks list (<=4KB request size)
///    sLFree[14] for >1024 word blocks list (>Page)

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define NONE 0

team_t team = {
  /* Team name to be displayed on webpage */
  "Most Spectacular Failure",
  /* First member full name */
  "Shinsuke Fukuda",
  /* First member email address */
  "sfukuda",
  /* Second member full name (leave blank if none) */
  "Edmund Wong",
  /* Second member email address (blank if none) */
  "edmund"
};

/// Finds the index to appropriate segregated list for a given size
int mm_findSLIndex(int numWordsNeeded)
{
  if (numWordsNeeded <= 6) return 1;
  else if (numWordsNeeded <= 10) return 2;
  else if (numWordsNeeded <= 18) return 3;
  else if (numWordsNeeded <= 26) return 4;
  else if (numWordsNeeded <= 34) return 5;
  else if (numWordsNeeded <= 50) return 6;
  else if (numWordsNeeded <= 66) return 7;
  else if (numWordsNeeded <= 130) return 8;
  else if (numWordsNeeded <= 258) return 9;
  else if (numWordsNeeded <= 386) return 10;
  else if (numWordsNeeded <= 514) return 11;
  else if (numWordsNeeded <= 770) return 12;
  else if (numWordsNeeded <= 1024) return 13;
  else return 14;
}

/// Adds the chunk starting from offset sLOffset with size newSize
/// to appropriate free list, in descending order
void mm_addToFreeList(int sLOffset, int newSize) {
  int *sLHeap = (int *)dseg_lo;
  int sLIndex = mm_findSLIndex(newSize);
   
  if (newSize == 0)
    return;

  if (newSize <= 3) {
    sLHeap[sLOffset] = newSize << 1;
    sLHeap[sLOffset + newSize - 1] = newSize << 1;
  }
  else if (sLHeap[sLIndex] == NONE) {
    sLHeap[sLIndex] = sLOffset;
    sLHeap[sLOffset] = newSize << 1;
    sLHeap[sLOffset + 1] = sLIndex;
    sLHeap[sLOffset + 2] = NONE;
    sLHeap[sLOffset + newSize - 1] = newSize << 1;
  }
  else {
    int thisIndex = sLHeap[sLIndex];
    int thisSize = sLHeap[thisIndex] >> 1;
    int prevIndex = sLIndex;
     
    while (thisIndex != NONE && thisSize <= newSize) {
      prevIndex = thisIndex;
      thisIndex = sLHeap[thisIndex + 2];
      thisSize = sLHeap[thisIndex] >> 1;
    }
    if (prevIndex != NONE)
      sLHeap[prevIndex + 2] = sLOffset;
    if (thisIndex != NONE)
      sLHeap[thisIndex + 1] = sLOffset;
    sLHeap[sLOffset] = newSize << 1;
    sLHeap[sLOffset + 1] = prevIndex;
    sLHeap[sLOffset + 2] = thisIndex;
    sLHeap[sLOffset + newSize - 1] = newSize << 1;
  }
  //printf("%d free blocks added to list %d, at index %d", newSize, sLIndex, sLOffset);
  //printf("\n");
}

void mm_popFromFreeList(int prevIndex, int thisIndex) {
  int *sLHeap = (int *)dseg_lo;
  
  if (prevIndex < 15) {
    sLHeap[prevIndex] = sLHeap[thisIndex + 2];
    sLHeap[thisIndex + 1] = prevIndex;
  }
  else {
    sLHeap[prevIndex + 2] = sLHeap[thisIndex + 2];
    sLHeap[thisIndex + 1] = prevIndex;
  }
}

int mm_init()
{
  int i, flag = 0;
  int *sLHeap;

  /// Allocates one page heap to start things off
  if (mem_sbrk(mem_pagesize()) == NULL)
    return -1;

  /// Copy dseg_lo into local variable and
  /// initialize the segregated list
  sLHeap = (int *)dseg_lo;
  for (i = 1; i < 15; i++)
    sLHeap[i] = NONE;

  /// If dseg_lo is not 8 byte aligned,
  /// offset the initial index by 4
  if (((int)dseg_lo) & 7)
    flag = 1;
  sLHeap[0] = flag;

  mm_addToFreeList(15 + flag, 1024 - 15 - flag);
  return 0;
}

void *mm_malloc (size_t size)
{
  int numWordsNeeded, sLIndex, goToNextSize, i;
  int *sLHeap = (int *)dseg_lo;

  if (size <= 0)
    return NULL;

  /// On LINUX or WIN32, wordsize = 4
  numWordsNeeded = ((unsigned)size >> 2) + 2;
  if (numWordsNeeded & 1)
    numWordsNeeded++;

  sLIndex = mm_findSLIndex(numWordsNeeded);
  
  /// If there is some chunk within the class that fit the request,
  /// then search within that class for a possible fit
  if (sLHeap[sLIndex] != NONE) {
    int thisIndex = sLHeap[sLIndex];
    int thisSize = sLHeap[thisIndex] >> 1;
    int prevIndex = sLIndex;
    
    while (thisIndex != NONE && thisSize < numWordsNeeded) {
      prevIndex = thisIndex;
      thisIndex = sLHeap[thisIndex + 2];
      thisSize = sLHeap[thisIndex] >> 1;
    }

    if (thisIndex == NONE)
      goToNextSize = 1;
    else {
      sLHeap[thisIndex] = (numWordsNeeded << 1) + 1;
      mm_popFromFreeList(prevIndex, thisIndex);

      //printf("Allocated block of size %d at index %d\n", numWordsNeeded, thisIndex);
      mm_addToFreeList(thisIndex + numWordsNeeded, thisSize - numWordsNeeded);

      return &sLHeap[thisIndex + 1];
    }
  }

  /// If there is no free chunk in the smallest possible class,
  /// or if there was no chunk within that class that fit the request,
  /// search for the first available chunk in bigger size list
  if (sLHeap[sLIndex] == NONE || goToNextSize) {
    int index, sLOffset, freeSize;

    for (index = sLIndex + 1; index < 15 && sLHeap[index] == NONE; index++)
      ;
    if (index == 15) {
      /// No available chunk that fits this block has been found
      /// Expand the heap and combine with the top block
      int prevMemUse = mem_usage() >> 2;
      int *prevTopAdd = (int *)(((int)dseg_hi >> 2) << 2);
      int prevTopSize = (*prevTopAdd) >> 1;
      int newTopSize, topIndex;
      int actRequestSize, requestSize, requestPage;

      if ((*(prevTopAdd - prevTopSize + 1)) & 1)
	prevTopSize = 0;

      requestSize = numWordsNeeded - prevTopSize;
      requestPage = requestSize >> 10;
      if (requestSize & 0x3FF)
	requestPage++;
      actRequestSize = requestPage << 12;
	
      if (mem_sbrk(actRequestSize) == NULL)
	return NULL;
      
      newTopSize = prevTopSize + (mem_usage() >> 2) - prevMemUse;
      sLOffset = prevMemUse - prevTopSize + 1;
      index = mm_findSLIndex(prevTopSize);
      freeSize = newTopSize;

      sLHeap[sLOffset] = newTopSize << 1;
      sLHeap[sLOffset + newTopSize - 1] = newTopSize << 1;
      /// Special case: do iterative search to find the location of
      /// top free chunk's within the free list

      if (prevTopSize > 4)
	mm_popFromFreeList(sLHeap[sLOffset + 1], sLOffset);
    }
    else {
      sLOffset = sLHeap[index];
      freeSize = sLHeap[sLOffset] >> 1;
      mm_popFromFreeList(index, sLOffset);
    }

    /// Split the chunk into area for the request (Mark it as allocated)
    /// and the remainder; then pop the free chunk off from the free list
    sLHeap[sLOffset] = (numWordsNeeded << 1) + 1;

    /// Add the remainder to the free list
    //printf("Allocated block of size %d at index %d\n", numWordsNeeded, sLOffset);
    mm_addToFreeList(sLOffset + numWordsNeeded, freeSize - numWordsNeeded);

    return &sLHeap[sLOffset + 1];
  }
  return NULL;
}

void mm_free (void *ptr)
{/*
  int sLOffset, thisSize, nextIndex, prevIndex;
  int prevSize = 0, nextSize = 0, i;
  int *sLHeap;
  
  /// Check that the given pointer lies within the heap and
  /// the seg list area
  if ((int *)ptr < (int *)dseg_lo + 16 || (int *)ptr > (int *)dseg_hi)
    return;
  
  /// Check whether this block is marked as allocated
  sLHeap = (int *)dseg_lo;
  sLOffset = (int)((int *)ptr - (int *)dseg_lo) - 1;
  if ((sLHeap[sLOffset] & 1) == 0)
    return;

  //printf("Before freeing memory:");
  //for (i = 0; i < 15; i++)
  //if (sLHeap[i] != NONE) {
  //int nextIndex = sLHeap[i];
  //printf("\n   sLHeap[%d] = %d @ %d ", i, sLHeap[nextIndex] >> 1, nextIndex);
  //while (sLHeap[nextIndex + 2] != NONE) {
  //nextIndex = sLHeap[nextIndex + 2];
  //printf("%d @ %d ", sLHeap[nextIndex] >> 1, nextIndex);
  //}
  //}
  //printf("\n\n");
  //for (i = 0; i < 15; i++)
  //if (sLHeap[i] != NONE)
  //printf("   sLHeap[%d] = %d with size %d\n", i, sLHeap[i], sLHeap[sLHeap[i]] >> 1);
    
  //printf("Request to free block at 0x%x\n", ptr);
  //printf("Start of the heap is 0x%x\n", dseg_lo);
  //printf("Offset of the start of the block: %d\n", sLOffset);

  thisSize = sLHeap[sLOffset] >> 1;

  /// Join the freed block with any adjacent free blocks,
 
  /// Coalesce with following block
  if (!(sLHeap[sLOffset + thisSize] & 1)) {
    nextSize = sLHeap[sLOffset + thisSize] >> 1;
    /// The block that follows is a <3 block,
    /// there might be additional free block beyond
    if (nextSize < 4) {
      thisSize = thisSize + nextSize;
      nextIndex = sLOffset + thisSize + nextSize;
      if (!(sLHeap[nextIndex] & 1) && ((sLHeap[nextIndex] >> 1) < 4))
	nextSize = nextSize + sLHeap[nextIndex] >> 1;
    }
    /// If not, check if <3 byte block follows this free chunk
    else if (!(sLHeap[sLOffset + nextSize] & 1) &&
	     ((sLHeap[sLOffset + nextSize] >> 1) < 4))
      nextSize = nextSize + (sLHeap[sLOffset + nextSize] >> 1);
  }  

  /// Coalesce with previous block
  if (sLHeap[sLOffset - 1] & 1 == 0) {
    prevSize = sLHeap[sLOffset - 1] >> 1;
    /// The block that precedes is a <3 block,
    /// there might be additional free block beyond
    if (prevSize < 4) {
      prevIndex = sLOffset - prevSize;
      if (!(sLHeap[prevIndex] & 1) && ((sLHeap[prevIndex] >> 1) < 4))
	prevSize = prevSize + sLHeap[prevIndex] >> 1;      
    }
    /// If not, check if <3 byte block precedes this free chunk
    else if (!(sLHeap[sLOffset - prevSize - 1] & 1) &&
	     ((sLHeap[sLOffset - prevSize - 1]) >> 1 < 4))
      prevSize = prevSize + (sLHeap[sLOffset - prevSize - 1] >> 1);
  }

  mm_addToFreeList(sLOffset - prevSize, prevSize + thisSize + nextSize);

  //printf("After freeing memory:\n");
  //printf("Freeing %d bytes from allocation", prevSize + thisSize + nextSize);
  //{
  //int i;
  //for (i = 0; i < 15; i++)
  //if (sLHeap[i] != NONE) {
  //int nextIndex = sLHeap[i];
  //printf("\n   sLHeap[%d] = %d @ %d ", i, sLHeap[nextIndex] >> 1, nextIndex);
  //while (sLHeap[nextIndex + 2] != NONE) {
  //nextIndex = sLHeap[nextIndex + 2];
  //printf("%d @ %d ", sLHeap[nextIndex] >> 1, nextIndex);
  //}
  //}
  //}
  //for (i = 0; i < 15; i++)
  //if (sLHeap[i] != NONE)
  //printf("   sLHeap[%d] = %d with size %d\n", i, sLHeap[i], sLHeap[sLHeap[i]] >> 1);
      
  //printf("\n\n"); */
}
