/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "<font color=#0000FF>Necrophiliacs are Yummy</font>",
    /* First member full name */
    "Samuel Spiro",
    /* First member email address */
    "sspiro@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Adam Murray",
    /* Second member email address (blank if none) */
    "ajmurray@andrew.cmu.edu"
};


#define start   (unsigned int*)((unsigned int*)dseg_lo)[0]
#define current (unsigned int*)((unsigned int*)dseg_lo)[1]
#define best    (unsigned int*)((unsigned int*)dseg_lo)[2]
#define uint unsigned int
#define current_left *(current+1)
#define current_right *(current+2)
#define best_left *(best+1)
#define best_right *(best+2)
#define start_left *(start+1)
#define start_right *(start+2)
#define current_header (*current)
#define current_footer *((uint*)((uint)current+(*current)-4))
#define best_header (*best)
#define best_footer *((uint*)((uint)best+(*best)-4))
#define start_header (*start)
#define start_footer *((uint*)((uint)start+(*start)-4))
#define total_size (uint)(size+(8-(size%8))+8)


int mm_init (void)
{
  /* if no memory is allocated, allocate a page */
  if(dseg_lo>=dseg_hi)
    if(mem_sbrk(mem_pagesize())==NULL)
      return -1;

  /* pointer to beginning of linked list of free blocks */
  start = (uint*)&dseg_lo[12];

  /* dseg_lo[4] will hold pointer to current free block in 
     linked list    
     dseg_lo[8] will hold pointer to best free block (implemented as first fit) */

  /* header and footer for linked list of free blocks
     contains the size of the free block, which initially
     is the size of the heap - 16 (12 used bytes at the beginning
     and 4 at the end (for the new header once we add a page)
     headers are aligned four bytes before an 8 byte block
     footers are aligned to 8 bytes */
  /* the +1's are because dseg_hi is an allocatable byte */
  /*((uint*)dseg_lo)[3] = ((uint*)(dseg_hi - 7))[0] = (uint)(dseg_hi - dseg_lo - 16 + 1); */
  start_header = (uint)(dseg_hi - dseg_lo - 16 + 1);
  start_footer = start_header;
  /* initial left and right pointers for the linked list of free blocks */
  /* ((uint*)dseg_lo)[4] = ((uint*)dseg_lo)[5] = (uint)NULL; */
  start_left = start_right = (uint)NULL;

  return 0;
}

/* size_t = unsigned int */
void *mm_malloc (size_t size)
{
  int maxdepth = 25;

  if (start==NULL) /* case where every free block is used */
    {
      start=dseg_hi-3; /* new header is last 4 bytes of current heap */
      if(mem_sbrk(mem_pagesize())==NULL)
	return NULL;
      start_header = mem_pagesize();
      start_footer = start_header;
      start_left = start_right = (uint)NULL;
    }
      
  current = start;
  best = (uint)NULL;
 
  /* only search the first 25 free blocks, or until we find something that fits */
  while((best == NULL || maxdepth > 0) && current != NULL)
    {      
      if(current_header >= total_size)
	if(best == NULL || current_header < best_header)
	  best = current;	
      maxdepth--;
      current = current_right;
    }
 
  if(best != (uint)NULL)
    {
      /* best fit for first 25 free blocks */
      if(*best - total_size >= 16) /* 16 = (1 header + 1 footer + 2 pointers)*4 bytes */
	/* then split block */
	{			
	  current = ((uint)best + total_size); /* new free block */	 
	  current_header = best_header - total_size;	 
	  current_footer = current_header;
	  current_left = best_left;
	  current_right = best_right;
	 
	  /* insert new block into list */	
	  if (current_left == (uint)NULL) /* first element in list */
	    start = current;
	  else
	    *(uint*)(current_left+8) = (uint)current;  /* left->right = this free block */
	  if (current_right != (uint)NULL)             /* not the last element */
	    *(uint*)(current_right+4) = (uint)current; /* right->left = this free block */	      	   

	  /* allocate block */
	  best_header = total_size;
	  best_footer = best_header + 1; /* least sig bit set to 1 indicates this block is allocated  */
	  best_header = best_header + 1;
	}
      else
	/* return whole block */
	{	
	  /* delete block from linked list */
	  if (best_left == (uint)NULL) /* first element in list */
	    start = best_right;
	  else
	    *(uint*)(best_left+8)= best_right;   /* left->right = right */

	  if (best_right != (uint)NULL)             /* not the last element */
	    *(uint*)(best_right+4)= best_left;   /* right->left = left */	
	  
	  best_footer = best_header + 1; /* least sig bit set to 1 indicates this block is allocated  */
	  best_header = best_header + 1;				       
	}
      return (void*)(best+1);
    }

  else
    /* not enough room, allocate more memory */
    {         
      current = (uint*)((void*)dseg_hi - 3);  /* this will be the header of the page we are about to allocate */
       
      if(mem_sbrk( ((uint)(total_size/mem_pagesize()) + 1) * mem_pagesize() ) == NULL)
	  return NULL;       
    
      if( ((uint)(*(current-1)) & 1) == 0 )  /* if previous footer indicates that block is free */
	/* then coalesce */
	{	 
	  current = (uint*)(((uint)current) - *(current-1));
	  current_header = current_header + ((uint)(total_size/mem_pagesize()) + 1) * mem_pagesize();
	  current_footer = current_header;
	  
	  /* delete block from linked list */
	  if (current_left == (uint)NULL)  /* first element in list */
	    start = current_right;
	  else
	    *(uint*)(current_left+8)= current_right;  /* left->right = right */
	  
	  if (current_right!=(uint)NULL)                /* not the last element */
	    *(uint*)(current_right+4)= current_left;  /* right->left = left */
	}      
      
      if( ((uint)dseg_hi - (uint)current - 4 + 1) - total_size >= 16)
	/* split block */
	{	   
	  current_header = total_size; /* least sig bit set to 1 indicates this block is allocated  */
	  current_footer = current_header + 1;
	  current_header = current_header + 1;
	  best = ((uint)current) + total_size;   /* best = header of free block */   
	  best_header = (uint)(((uint)dseg_hi) - ((uint)current) - total_size - 4 + 1);
	  best_footer = best_header;
	  
	  /* insert at start of list */
	  best_left = (uint)NULL;
	  (uint*)best_right = start;
	  if((uint)start != (uint)NULL)
	    start_left = (uint)best;
	  start = best;
	}
      else /* return whole block */	 
	{
	  current_header = (uint)dseg_hi - (uint)current - 4 + 1; 
	  current_footer = current_header + 1;  /* least sig bit set to 1 indicates this block is allocated  */
	  current_header = current_header + 1;
	}
      
      return (void*)(current+1);
    }
  return NULL;
}

void mm_free (void *ptr)
{
  if ((ptr > (void*)(dseg_hi-4)) || (ptr < (void*)(dseg_lo+12)))
    return;

  current = (uint*)(ptr-4); /* current = block to free */
  current_header = (uint)current_header - 1; /* free the block by setting least dig to 0 */
  current_footer = current_header;

  if ( (((uint)(*((uint*) ((uint)current + current_header))) & 1) == 0) && 
       ( ((uint)current + current_header) <= ((uint)dseg_hi - 4) ) ) /* if the block after this one is free and its not off the edge*/
    {
      best = (uint*)(((uint)current) + current_header); /* best = block after current block */

      /* remove best from list */
      if (best_left == (uint)NULL)  /* first element in list */
	start = best_right;
      else
	{	 
	*(uint*)(best_left+8) = best_right;  /* left->right = right */
      
	}
      if (best_right != (uint)NULL)                /* not the last element */
	*(uint*)(best_right+4) = best_left;  /* right->left = left */

      current_header = current_header + best_header;
      current_footer = current_header;
    } 

  if ( (((uint)(*(current-1)) & 1) == 0) && (((uint)(current-1)) >= (((uint)dseg_lo)+12) ) )
    /* if the block before the one we are freeing is free and its not before the beginning*/
    {
      best = ((uint)current)-(*(current-1)); /* best = block before current block */
      /* remove best from list */
      if (best_left == (uint)NULL)  /* first element in list */
	start = best_right;
      else
	*(uint*)(best_left+8)= best_right;  /* left->right = right */
      
      if (best_right!=(uint)NULL)                /* not the last element */
	*(uint*)(best_right+4)= best_left;  /* right->left = left */
    
      best_header = (uint)best_header + (uint)current_header;
      best_footer = best_header;
      current = best;
    }

  /* add current to front of list */
  if ((uint)start != (uint)NULL)
    {
      start_left = (uint)current;
    }
  current_left = (uint)NULL;
  current_right = (uint)start;
  start = current;
  

}

