/* $Id: malloc.c,v 1.2 99/10/11 19:51:52 pjo Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "ether bingers",
    /* First member full name */
    "jacob richman",
    /* First member email address */
    "jsr",
    /* Second member full name (leave blank if none) */
    "pawel opalinski",
    /* Second member email address (blank if none) */
    "pjo"
};


#define DEBUG    (0)
#define ALIGN    (8)

int pagesize;

#define toNextPageSize(x) (((x)+(pagesize-1)) & ~(pagesize-1))
#define sizeAlign(x)      (((x)+(ALIGN-1)   ) & ~(ALIGN-1))

typedef char byte;
#define NBUCKETS (32)
byte *bucket[NBUCKETS];

int sizeToBucketIndex(int size){
	int bucketIndex = 0;
	while(size){
		bucketIndex++;
		size >>= 1;
	}
	return bucketIndex;
}
int bucketIndexToSize(int index){
	return 1<<(index);
}

int mm_init (void)
{
	int i;

	pagesize = mem_pagesize();
	#if DEBUG
		printf("pagesize=%d\n",pagesize);
		printf("toNextPageSize(0)=%d\n",toNextPageSize(0));
		printf("toNextPageSize(1)=%d\n",toNextPageSize(1));
		printf("toNextPageSize(%d)=%d\n",pagesize,toNextPageSize(pagesize));
		printf("toNextPageSize(%d)=%d\n",pagesize+1,toNextPageSize(pagesize+1));
	#endif
	for (i=0;i<NBUCKETS;i++){
		bucket[i] = NULL;
	}
	return 0;
}

void *mm_malloc (size_t size)
{
	int bucketIndex;
	byte *freeLocation = NULL;

	#if DEBUG
		printf("mm_malloc(%d)\n",size);
		printf("sizeAlign(%d)=%d\n",size,sizeAlign(size));
	#endif
	/* size = sizeAlign(size); */

	bucketIndex = sizeToBucketIndex( size );
	if (bucket[ bucketIndex ]){
		freeLocation = bucket[ bucketIndex ];
		bucket[ bucketIndex ] = *(byte **)freeLocation;
	} else {
		size = bucketIndexToSize( bucketIndex );
		freeLocation = (byte *)mem_sbrk(size+ALIGN);	
		*((int *)freeLocation) = bucketIndex;
		freeLocation += ALIGN;
	}

	return freeLocation;
}

void mm_free (void *ptr)
{
	byte* p = (byte *)ptr;
	int bucketIndex = *((int *)(p-ALIGN));
	*(byte **)p = bucket[ bucketIndex ];
	bucket[ bucketIndex ] = p;
}

