/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Unnamed",
    /* First member full name */
    "Matthew Hunter",
    /* First member email address */
    "mhunter",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

// The following values are used for debugging & statistics

int stats[32];

typedef struct malloc_header
{
   void *next;
   size_t size;
} malloc_header;

typedef struct malloc_info
{
   size_t pagesize;
   malloc_header *(lists[32]);
   void *start;

} malloc_info;


/**
 * Taken from the Lab1_log2.c file.
 **/

int log2(int x)
{
  int m16 = ((1<<16) + ~0) << 16;                         /* groups of 16 */
  int m8 = (((1<<8)  + ~0) << 24) + (((1<<8) + ~0) << 8); /* groups of 8 */
  int m4 = (0xf0<<24) + (0xf0<<16) + (0xf0<<8) + 0xf0;    /* groups of 4 */
  int m2 = (0xcc<<24) + (0xcc<<16) + (0xcc<<8) + 0xcc;    /* groups of 2 */
  int m1 = (0xaa<<24) + (0xaa<<16) + (0xaa<<8) + 0xaa;    /* groups of 1 */
  int result = 0;
  int upper;
  int mask;

  /* m16 */
  upper = !!(x & m16);
  result += upper << 4;
  mask = m16 ^ ~((upper<<31)>>31);

  /* m8 */
  upper = !!(x & m8 & mask);
  result += upper << 3;
  mask &= (m8 ^ ~((upper<<31)>>31)); 

  /* m4 */
  upper = !!(x & m4 & mask);
  result += upper << 2;
  mask &= (m4 ^ ~((upper<<31)>>31)); 

  /* m2 */
  upper = !!(x & m2 & mask);
  result += upper << 1;
  mask &= (m2 ^ ~((upper<<31)>>31)); 

  /* m1 */
  upper = !!(x & m1 & mask);
  result += upper;

  return result;
}

__inline void statistics(int size)
{
   stats[log2(size)]++;
}


__inline void clearmem(void *region, int size)
{
   int count;
   char *uregion = (char *)(((int) region) + sizeof(malloc_header));
   for (count = 0; count < size; count++)
   {
      uregion[count] = 0;
   }
}

__inline int valid_header(malloc_header *header)
{
   if (header != NULL)
   {
      if (((void *) header > (void *) dseg_lo) && ((void *) header < (void *) dseg_hi))
      {
         if (header->size != 0) return 1;
         else
         {
            printf("Size field was 0!\n");
            fflush(NULL);
         }
      }
   }
   return 0;
}

__inline int isfree(malloc_header *header)
{
   if (header->size % 2)
   {
      return 1;
   }
   else return 0;
}

__inline malloc_header *next_region(malloc_header *header)
{
   if (valid_header(header))
   {
      return (malloc_header *)(((int) header) + header->size - isfree(header));
   }
   else return NULL;
}

__inline malloc_header *next_list_region(malloc_header *header)
{
   if (valid_header(header))
   {
      return header->next;
   }
   else return NULL;
}

void display_header(malloc_header *header)
{
   if (valid_header(header))
   {
      printf("Region at: %d\n", (int) header);
      if (isfree(header))
      {
         printf("Size     : %d\n", header->size - 1);
         printf("Freed    : Yes\n");
      }
      else
      {
         printf("Size     : %d\n", header->size);
         printf("Freed    : No\n");
      }
      // printf("Next     : %d\n", (int) header->next);
   }
}

void display_list(malloc_header *header)
{
   malloc_header *current = header;

   while (valid_header(current))
   {
      display_header(current);
      current = next_region(current);
   }
}

void check_list(malloc_info *info, int line)
{
   int max;
   int count = 0;
   int counter;
   int size;
   int debug = 0;
   malloc_header *current;
   if (debug)
   {
      printf("check_list(line %d)\n", line);
      for (size = 0; size < 32; size++)
      {
         count = 0;
         current = info->lists[size];
         while (valid_header(current))
         {
            if (count >= (2 * 65536))
            {
               printf("%d is too big!\n", count);
               for (counter = 0; counter < 32; counter++)
               {
                  printf("[%d]: %d\n", counter, stats[counter]);
               }
               fflush(NULL);
               getchar();
            }
            if (current->size <= 0)
            {
               printf("Region with incorrect size!");
               fflush(NULL);
               getchar();
            }
            if (!current->size % 2)
            {
               printf("Allocated region in free list!\n");
               fflush(NULL);
               getchar();
            }
            count++;
            current = next_list_region(current);
         }
         printf("lists[%d]: %d\n", size, count);
         fflush(NULL);
      }
   }
}

void add_to_list(malloc_info *info, malloc_header *region)
{
   int debug = 0;

   if (debug)
   {
      // check_list(info, __LINE__);
      printf("add_to_list() ");
      fflush(NULL);
   }
   
   if (info != NULL)
   {
      if (valid_header(region))
      {
         int lsize = log2(region->size);
         if (region->next != NULL)
         {
            printf("Region already in a list!\n");
            fflush(NULL);
         }
         region->next = info->lists[lsize];
         info->lists[lsize] = region;
         
      }
   }

   if (debug)
   {
      check_list(info, __LINE__);
      fflush(NULL);
   }
}

void rem_from_list(malloc_info *info, malloc_header *region)
{
   int count = 0;
   int debug = 0;

   if (debug)
   {
      // check_list(info, __LINE__);
      printf("rem_from_list() ");
      fflush(NULL);
   }
   
   if (info != NULL)
   {
      malloc_header *current;
      if (valid_header(region))
      {
         int lsize = log2(region->size);
         current = info->lists[lsize];

         if (current == region)
         {
            info->lists[lsize] = region->next;
            region->next = NULL;
            return;
         }

         while (valid_header(current))
         {
            if (current->next == region)
            {
               current->next = region->next;
               region->next = NULL;
               return;
            }
            if (current->size <= 0)
            {
               printf("Zero size region!");
               fflush(NULL);
               getchar();
            }
            count++;
            if (count >= (2 * 65536))
            {
               check_list(info, __LINE__);
               printf("Infinite loop detected!");
               fflush(NULL);
               getchar();
            }
            current = next_list_region(current);
         }
         printf("Could not remove!");
      }
   }
}

__inline void init_header(malloc_header *header, int size, int free, void *next)
{
   header->size = size + free;
   header->next = next;
   clearmem(header, size - free - sizeof(malloc_header));
}

void coalesce(malloc_header *start)
{
   int debug = 0;
   malloc_header *current = start;
   malloc_header *last = NULL;
   if (debug)
   {
      printf("Coalescing: \n");
      fflush(NULL);
   }

   while (valid_header(current))
   {
      if (last != NULL)
      {
         if (isfree(last) && isfree(current))
         {
            last->size = last->size + current->size - 1;
            current = last;
            last = NULL;
         }
      }
      last = current;
      current = next_region(current);
   }
}

__inline malloc_header *find_fit(malloc_info *info, int size)
{
   int debug = 0;
   if (debug)
   {
      printf("find_fit(%d) ", size);
      fflush(NULL);
   }

   if (info != NULL)
   {
      int csize = 0;
      int cfree = 0;
      int lsize = 0;
      int lfree = 0;
      int count = 0;
      int counter = 0;
      malloc_header *current = NULL;
      malloc_header *last = NULL;
      malloc_header *ptr = NULL;

      // Walk each freelist large enough to be possible
      
      for (count = log2(size); count < 32; count++)
      {
         counter = 0;
         if (debug > 1) printf("[%d]: ", count);
         current = info->lists[count];
         while (valid_header(current))
         {
            // Get current size, masking out lowest-order bit
            csize = current->size - 1;

            // If this block is free and big enough for the current request,
            // we can fill that request with this block.

            if (csize >= size)
            {
               if (debug)
               {
                  printf("fits in existing %d block at %d", csize, (int) current);
                  fflush(NULL);
               }

               // If the block is large enough to split, split it;
               // otherwise, leave the size unchanged
               if (debug) check_list(info, __LINE__);
               rem_from_list(info, current);
               if (debug) check_list(info, __LINE__);
               if ((csize - size) > (2 * sizeof(malloc_header)))
               {
                  malloc_header *temp;
                  init_header(current, size, 0, NULL);
                  temp = next_region(current);
                  init_header(temp, csize - size, 1, NULL);
                  add_to_list(info, temp);
                  if (debug) check_list(info, __LINE__);
               }
               else
               {
                  init_header(current, csize, 0, NULL);
               }
               return current;
            }
            current = next_list_region(current);
            counter++;
         }
         if (debug > 1) printf("%d\n", counter);
      }
   }
   return NULL;
}

int mm_init (void)
{
   int count;
   int debug = 0;
   malloc_info *info = (malloc_info *) dseg_lo;
   if (dseg_lo >= dseg_hi)
   {
      mem_sbrk(mem_pagesize());
   }
   else
   {
      memset(dseg_lo, 0, dseg_hi - dseg_lo);
   }
   info->pagesize = mem_pagesize();
   info->start = (void *)(((int) dseg_lo) + sizeof(malloc_info));

   for (count = 0; count < 32; count++)
   {
      info->lists[count] = NULL;
   }

   init_header(info->start, info->pagesize - sizeof(malloc_info), 1, NULL);
   add_to_list(info, info->start);
   
   if (debug)
   {
      check_list(info, __LINE__);
      printf("pagesize: %d\n", info->pagesize);
      printf("dseg_lo: %d\n", (int) dseg_lo);
      printf("dseg_hi: %d\n", (int) dseg_hi);
      printf("malloc_info: %d bytes\n", sizeof(malloc_info));
      printf("malloc_header: %d bytes\n", sizeof(malloc_header));
      // display_list(info->start);
      printf("Statistics from previous run:\n");
      for (count = 0; count < 32; count++)
      {
         printf("[%d]: %d\n", count, stats[count]);
      }
   }
   
   return 0;
}

void *mm_malloc (size_t size)
{
   malloc_info *info = (malloc_info *) dseg_lo;
   int debug = 0;
   size_t rsize = 0;
   void *ptr;

   // Debugging stuff
   if (debug)
   {
      if (debug > 1) display_list(info->start);
      printf("malloc(%d): ", size);
      fflush(NULL);
      rsize = 0;
   }

   // Calculate the real size in bytes by adding the size
   // of the header
   rsize = size + sizeof(malloc_header);

   // Ensure 8-byte alignment by adding any necessary size
   if ((rsize % 8) > 0)
   {
      rsize += 8 - (rsize % 8);
   }

   if (debug)
   {
      printf("%d bytes ", rsize);
      fflush(NULL);
   }
   
   // Check for usable freed blocks
   ptr = NULL;
   if (dseg_lo < dseg_hi) ptr = find_fit(info, rsize);

   // If there are no free blocks with enough space, ask for more
   if (ptr == NULL)
   {
      // How many pages will we need to allocate?
      int numpages;
      int remainder;

      numpages = rsize / info->pagesize;
      if ((rsize % info->pagesize) > 0) numpages++;
      remainder = (numpages * info->pagesize) - rsize;

      if (debug)
      {
         printf("in %d pages, %d bytes extra ", numpages, remainder);
         fflush(NULL);
      }
      // Allocate new block
      ptr = mem_sbrk(numpages * info->pagesize);
      // Initialize the block we'll return
      init_header(ptr, rsize, 0, NULL);
      // Initialize the remaining space as freed
      init_header((void *)(((int) ptr) + rsize), remainder, 1, NULL);
      add_to_list(info, (malloc_header *)(((int) ptr) + rsize));
   }

   if (ptr != NULL)
   {
      // ((int *) ptr)[0] = rsize;
      // if (debug) printf("with size %d ", ((int *) ptr)[0]);
      
      ptr = (void *)(((int) ptr) + sizeof(malloc_header));
      if (debug)
      {
         printf("at %d\n", ((int) ptr));
         fflush(NULL);
      }
      // if (debug) display_list(info->start);
      return ptr;
   }
   else return NULL;
}

/**
 * Takes the (adjusted) size of a memory region, and clears it.
 **/

void mm_free (void *ptr)
{
   malloc_header *current;
   malloc_info *info = (malloc_info *) dseg_lo;
   int debug = 0;

   if (debug)
   {
      if (debug > 1) display_list(info->start);
      printf("mm_free(%d): ", (int) ptr);
      fflush(NULL);
   }

   // Check that the pointer is in the valid range
   current = (malloc_header *)(((int) ptr) - sizeof(malloc_header));
   if (valid_header(current))
   {
      // If the pointer is in the valid range, mark it freed;
      statistics(current->size);
      if (!isfree(current))
      {
         init_header(current, current->size, 1, NULL);
         add_to_list(info, current);
      }
      else printf("Error!  Freed region twice!\n");

      if (debug)
      {
         printf("%d bytes", current->size - 1);
      }
      
      // After freeing, walk the rest of the list to coalesce it
      // coalesce(info->start);
   }

   if (debug) printf("\n");
}

