/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "the ubiquitous state of foobar",
    /* First member full name */
    "Lee Sheng",
    /* First member email address */
    "lsheng",
    /* Second member full name (leave blank if none) */
    "Matt McGrath",
    /* Second member email address (blank if none) */
    "mmcgrath"
};


int mm_init (void)
{
    /* get initial page */
    if (mem_sbrk(mem_pagesize()) == NULL) return -1;

    /* set dseg_hi to be 4-aligned */
    (int) dseg_hi = (int) dseg_hi - 3;

    /* point the value in dseg_lo to first possibly available memory */
    *((int*)dseg_lo) = (int) dseg_lo + 4;

    /* set boundary tags on initial page */
    *((int*)(dseg_lo + 4)) = *((int*)(dseg_hi - 4)) = (mem_pagesize() - 16);

    return 0;
}

void *mm_malloc (size_t size)
{
    if (size == 0) return NULL;
    /* printf("\n\n>%x\n", size); */

    /* 8-align size */
    size = ((size + 7) / 8) * 8;

    /* point the value in dseg_lo to first possibly available memory */
    *((int*)dseg_lo) = (int) dseg_lo + 4;

    /* if (*((int*)dseg_lo) < ((int)dseg_hi - 4)) printf("In while.\n"); */

    /* while looking within allocated heap */
    while (*((int*)dseg_lo) < ((int)dseg_hi))
      {
	/* printf("%x\t",(int)(*((int*)dseg_lo))); */ 
        /* look for a free block that's big enough */
        if (!(*((int*)(*((int*)(dseg_lo)))) & 1) && (size < *((int*)(*((int*)(dseg_lo)))) )) {
          if (size == (*((int*)dseg_lo) & -2)) {
            *((int*)(*((int*)(dseg_lo)) + size + 4)) = size + 1;
            *((int*)(*((int*)(dseg_lo)))) = size + 1;
            } else {
            if ((*((int*)(dseg_lo) + 1) - size - 16) <= 0) printf("MEEEEP!\n");
            *((int*)(*((int*)(dseg_lo)) + (*((int*)(*((int*)(dseg_lo))))) + 4)) = *((int*)(*((int*)(dseg_lo)))) - size - 8;
            *((int*)(*((int*)(dseg_lo)) + size + 8)) = *((int*)(*((int*)(dseg_lo)))) - size - 8; 
            *((int*)(*((int*)(dseg_lo)) + size + 4)) = size + 1;
            *((int*)(*((int*)(dseg_lo)))) = size + 1;
          } 
	  /* printf("No new pages.  %x %x %x\n", size, (int)dseg_lo, (int)dseg_hi); */
          /* printf("Returning.  %x\n", (*((int*)(dseg_lo)) + 4)); */
          return((void*)(*((int*)(dseg_lo)) + 4));
        }

        /* move to the next block */
	/* printf("%x\t",(int)(*((int*)dseg_lo))); */ 
        if (*((int*)dseg_lo) > *((int*)dseg_lo) + ((*((int*)(*((int*)(dseg_lo))))) & -2) +8) printf("Eek.\n");
        *((int*)dseg_lo) = *((int*)dseg_lo) + ((*((int*)(*((int*)(dseg_lo))))) & -2) +8;
      }

    /* 
     * not enough space in current heap pages, 
     * so allocate an integer number of them if possible
     */
    *((int*)dseg_lo) = (int) dseg_hi;

    /* if out of memory, return NULL */
    /* the +8 compensates for a pathological case resulting from allocating
     * 8 less bytes than the page size */
    if (mem_sbrk((size / mem_pagesize() + 1) * mem_pagesize()) == NULL) return NULL;

    /* put a 0-byte allocated space across the boundary */
    *((int*)(*(((int*)dseg_lo)))) = *((int*)(*(((int*)dseg_lo))) + 1) = 1;

    /* fill in the tags on the new space */
    *((int*)(dseg_hi - 4)) = (size / mem_pagesize() + 1) * mem_pagesize() - 24 - size;
    *((int*)(dseg_hi - ((size / mem_pagesize() + 1) * mem_pagesize() - size) + 16)) =
      (size / mem_pagesize() + 1) * mem_pagesize() - 24 - size;
    *((int*)(dseg_hi - ((size / mem_pagesize() + 1) * mem_pagesize() - size) + 12)) = size + 1;
    *((int*)(dseg_hi - ((size / mem_pagesize() + 1) * mem_pagesize()) + 8)) = size + 1;
    /* printf("    new pages.  %x %x %x\n", size, (int)dseg_lo, (int)dseg_hi); */
    /* printf("Returning.  %x\n", dseg_hi - ((size / mem_pagesize() + 1) * mem_pagesize()) + 12); */
    return(dseg_hi - ((size / mem_pagesize() + 1) * mem_pagesize()) + 12);
}

/* please, for the love of God, don't free unallocated memory! */
void mm_free (void *ptr)
{
  /* mark the block free */
     
  *((int*)(ptr - 4)) = *((int*)(ptr - 4)) & -2;
  *(((int*)(ptr - 4)) + (*((int*)(ptr - 4)) -1) / 4 + 2) = *((int*)(ptr - 4));
  
}

