/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

/*  IMPLEMENTATION NOTES
 *  -------------------- 
 *
 *  DATA STRUCTURE
 *  The memory blocks are arranged as an uni-directional implicit list.  
 *  Each memory block is proceeded by a 'header' which is has the size
 *  of 8 bytes.  The header contains information about whether the memory
 *  block is allocated (by checking whether the least significant bit is 1) 
 *  and the size of the memory block (by masking out the least significant
 *  bit.
 *
 *  ALGORITHM: MALLOC
 *  The placement policy adopted is best-fit.  The first free block that fits 
 *  is searched from the beginning.  Then other free blocks that better bits
 *  are searched.
 * 
 *  ALGORITHM: FREE
 *  The block is freed by setting the least significant bit of its header to 0.
 *  Then it is coalesced with the next block if the later is also free.
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "LL",
    /* First member full name */
    "Kin Pou Lie",
    /* First member email address */
    "klie@cs.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

int mm_init (void)
{
       return 0;
}

void *mm_malloc (size_t size)
{
    size_t oldsize;
    size_t newsize;
    size_t bestfitsize;
    char *header;
    char *bestfitheader;
    header = dseg_lo;
    newsize = 8 + (((size+7) >> 3) << 3);
    oldsize = ((*(size_t *)header) & -2);
    // Find the first free block that fits
    while((((*header) & 1) || (oldsize<newsize)) && (header < dseg_hi)) {
        header += oldsize;
        oldsize = (*((size_t *)header) & -2);
    }
    bestfitheader = header;
    // If there is no free block that fits then expand the heap
    if(bestfitheader > dseg_hi)
        bestfitheader = mem_sbrk(newsize);
    // Find
    else {
        bestfitsize = oldsize;
        do {
            if((((*header) & 1)==0) && (newsize <= oldsize) && (oldsize < bestfitsize)) {
                bestfitheader=header;
                bestfitsize=oldsize;
	    }
            header += oldsize;
            oldsize = (*((size_t *)header) & -2);
        } while(header < dseg_hi);
    // Set the size of the remaining part of block
    if(newsize < bestfitsize)
        *(size_t *)(bestfitheader+newsize) = bestfitsize - newsize;
    }
    // Set the least significant bit to 1 to indicate that the block is 
    // allocated
    *((size_t *)bestfitheader) = (newsize | 1);   
    return(bestfitheader + 8);
} 

void mm_free (void *ptr)
{
    char *header;
    char *next;
    header = ((char *)ptr) - 8;
    // Set the least significant bit to 0 to indicate that the block is free
    *header = (*(size_t *)header) & -2;
    next = header + *((size_t *)header);
    // Coalesce with the next block if it is also free
    if((((*next) & 1)==0) && (next < dseg_hi))
        *((size_t *)header) += *((size_t *)next);
}
