/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "from a 0 to a 100 in one line of code",
    /* First member full name */
    "James Irwin",
    /* First member email address */
    "jti",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


/*free blocks: first 4 bytes = size of block, low bit = 1 if free 0 not free
               bytes 4-8 = pointer to previous block
               bytes 8-12 = pointer to previous free block
	       bytes 12-16 = pointer to next free block
	       rest = empty*/

/*used blocks: first 4 bytes = size of current block, low bit =1 if free 0 not
               bytes 4-8 =pointer to previous block
	       rest = allocatted memory*/

/*I keep the free list sorted in largest to smallest order
although it is inefficient, I store whatever new size we get
into the largest available free spot*/

/*there is only a single free list*/

typedef struct freeblock
{
  int size;
  void *prev_block;
  struct freeblock *prev_free;
  struct freeblock *next_free;
} freeblock;

freeblock *free_list;
void **end_list;
int min_free_block_size = 16;
int end_list_size = 8;

int add_to_stack(size_t size)
{ /*adds to stack, returns # of bytes actually added*/
  int pagesize = mem_pagesize();
  int numpages = size/pagesize+1;
  if(!mem_sbrk(pagesize*numpages)) printf("failed adding to stack\n");
  return(pagesize*numpages);
}

int size_needed(size_t size)
{
  int size_for_mem = ((size-1)/8+1)*8;
  int size_for_header = 8;
  return(size_for_mem + size_for_header);
}

char is_block_free(void *p)
{
  int *sizep = (int *) p;
  return((char) (*sizep&1));
}

void *get_mem_address(void *p)
{
  return(p+8);
}

void *get_block_from_mem(void *p)
{
  return(p-8);
}

void **get_prev_block(void *p)
{
  return(p+4);
}

void insert_free_block(freeblock* cur_block, freeblock* start)
{
  freeblock *place = start;
  while(place->next_free &&
	place->next_free->size > cur_block->size)
    {
      place = place->next_free;
    }
  cur_block->next_free = place->next_free;
  cur_block->prev_free = place;
  place->next_free = cur_block;
  if(cur_block->next_free)
    {
      cur_block->next_free->prev_free = cur_block;
    }
}

void remove_free_block(freeblock* cur_block)
{
  cur_block->prev_free->next_free = cur_block->next_free;
  if (cur_block->next_free)
    {
      cur_block->next_free->prev_free = cur_block->prev_free;
    }
}

void add_block(freeblock* cur_block, size_t size)
{
  int oldsize = cur_block->size;
  int newsize = size_needed(size);
  remove_free_block(cur_block);
  if(oldsize-newsize>=min_free_block_size)
    {
      freeblock* new_block;
 
      cur_block->size = newsize;
      new_block = (freeblock *) ((void *) cur_block + newsize);
      new_block->size=oldsize-newsize;
      new_block->prev_block = cur_block;
      *get_prev_block((void *) new_block + (new_block->size & ~0x1))=new_block;
      insert_free_block(new_block, free_list);
      if((void *) new_block + new_block->size -1 == end_list)
	{ /* if we are the last block*/
	  *end_list = new_block; 
	}
    }
  else
    { /*not enough room for a new free header*/
      cur_block->size = oldsize-1; /*-1 for allocated designation*/
    }
}



void check_list()
{
  freeblock * p = free_list;
  freeblock * last_block = NULL;
  char didoccur = 0;
  if(is_block_free(*end_list)) 
    {
      last_block = *end_list;
    }
  else
    {
      didoccur = 1;
    }
  while(p->next_free)
    {
      if(p==last_block)
	{
	  didoccur = 1;
	}
      p = p->next_free;
      if(p->next_free&&p->next_free->prev_free != p)
	{
	  printf("next free's previous free does not point to this\n");
	}
      if(p->next_free&& (p->size < p->next_free->size))
	{
	  printf("not in sequential order\n");
	}
      if(p->size%2==0)
	{
	  printf("not odd\n");
	}
    }
      if(p==last_block)
	{
	  didoccur = 1;
	}
  if(!didoccur)
    {
      printf("the last block, which was free, is not in the list\n");
    }
}


int mm_init (void)
{
  freeblock* first_block;
  add_to_stack(0);
  free_list = (freeblock *) dseg_lo;
  end_list =(void *) dseg_hi-end_list_size+1;
  first_block = (freeblock *) ((void *) free_list + min_free_block_size);

  free_list->size = min_free_block_size;
  free_list->prev_block = NULL;
  free_list->prev_free = NULL;
  free_list->next_free = first_block;

  first_block->size = (int) mem_usage() - min_free_block_size-end_list_size+2;
  first_block->prev_block = free_list;
  first_block->prev_free = free_list;
  first_block->next_free = NULL;

  *end_list = first_block; 
  return 0;
}

void *mm_malloc (size_t size)
{
  freeblock* cur_block= free_list;
  if(cur_block->next_free)
    {
      cur_block = cur_block->next_free;

      if(size_needed(size)>cur_block->size) /*there is not enough room*/
	{ /*add room*/
	  freeblock* new_block;
	  if(is_block_free(*end_list))
	    {
	      freeblock* old_block = (freeblock *) *end_list;
	      new_block = old_block;
	      remove_free_block(old_block);
	      new_block->size = old_block->size + add_to_stack(size);

	      /* new_block->prev_block = old_block->prev_block; can remove*/
	    }
	  else
	    {
	      new_block = (freeblock *) end_list;
	      new_block->prev_block = *end_list;
	      new_block->size = add_to_stack(size)+1;
	    }
	  insert_free_block(new_block, free_list);
	  end_list = (void *) dseg_hi-end_list_size+1;
	  *end_list = new_block;
	  cur_block = new_block;
	}
    }
  else /*there are no free blocks - create space and make one*/
    {
      freeblock* new_block;
      new_block = (freeblock *) end_list;
      new_block->prev_block = *end_list;
      new_block->size = add_to_stack(size)+1;
      insert_free_block(new_block, free_list);
      end_list = (void *) dseg_hi-end_list_size+1;
      *end_list = new_block;
      cur_block = new_block;
    }
  add_block(cur_block, size);
  return(get_mem_address((void *) cur_block));
}

void mm_free (void *ptr)
{
  void * current_block = get_block_from_mem(ptr);
  freeblock* prev_block = NULL;
  freeblock* next_block = NULL;
  int* sizep = (int *) current_block;
  if(is_block_free(*get_prev_block(current_block)))
    {
      prev_block = (freeblock *) *get_prev_block(current_block);
    }
  if(is_block_free(current_block + *sizep))
    {
      next_block = (freeblock *) (current_block + *sizep);
    }

  if(prev_block) /*is it free*/
    {
      if(next_block)
	{ /*both blocks are free*/
	  /*remove both blocks and insert the larger one*/

	  freeblock *new_block = (freeblock *) prev_block;
	  remove_free_block(next_block);
	  remove_free_block(prev_block);
	  new_block->size = *sizep+next_block->size+prev_block->size-1;
	  new_block->prev_block = *get_prev_block(prev_block);
    	  *get_prev_block((void *) next_block + next_block->size -1)=prev_block;
	  if(next_block == *end_list)
	    {
	      *end_list = new_block;
	    }
	  insert_free_block(new_block, free_list);
     	}
      else
	{ /*prev block is free, next block is allocated*/
	  freeblock *new_block = (freeblock *) prev_block;
	  remove_free_block(prev_block);
	  new_block->size = *sizep+prev_block->size;
	  new_block->prev_block = *get_prev_block(prev_block);
    	  *get_prev_block(current_block + *sizep)=prev_block;

	  insert_free_block(new_block, free_list);
       } 
    }
  else
    {
      if(next_block)
	{ /*previous block is allocated, next is free*/
	  /*remove next block and reinsert the new bigger one */
	  freeblock *new_block = (freeblock *) current_block;
	  remove_free_block(next_block);
	  new_block->size = *sizep+next_block->size;
	  new_block->prev_block = *get_prev_block(current_block);
	  *get_prev_block((void *) next_block + next_block->size -1)=new_block;
	  
	  if(next_block == *end_list)
	    {
	      *end_list = new_block;
	    }
	  insert_free_block(new_block,free_list);
	}
      else
	{ /*both previous and next blocks are allocated*/
	  /*make a new free block and insert it*/

	  freeblock *new_block = (freeblock *) current_block;
	  new_block->size = *sizep+1; 
	  new_block->prev_block = *get_prev_block(current_block);
	  insert_free_block(new_block, free_list);
      	}
    }
}

