/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define UI(x)                 ((unsigned int)(x))
#define DREF_UINT(p)          (*(unsigned int *)(void *)(p))
#define BLOCK_SIZE(p)         (DREF_UINT(p)&(unsigned int)(~0x1))
/* the block size does not include 4 bytes on each side */

#define FREE_LIST (DREF_UINT(dseg_lo))
#define TEMP_VAR  (DREF_UINT((UI(dseg_lo)+4)))
#define PTEMP_VAR ((void *)(UI(dseg_lo)+4))
#define PFREE_LIST ((void *)dseg_lo)


#define END_OF_BLOCK(p)       ((void *)(UI(p)+(BLOCK_SIZE(p))+4))
#define BLOCK_IS_FREE(p)      (DREF_UINT(p)&(1))
#define SET_BLOCK_FREE(p)     (DREF_UINT(p)=DREF_UINT(p)|1) 

/* takes pointer, sets it to free */

/* if it has a 1, its free */

#define SET_BLOCK_END_FREE(p) (DREF_UINT(END_OF_BLOCK(p))=DREF_UINT(END_OF_BLOCK(p))|1)
#define SET_BLOCK_FULL(p)     (DREF_UINT(p)=BLOCK_SIZE(p))
#define SET_BLOCK_END_FULL(p) (SET_BLOCK_FULL(END_OF_BLOCK(p)))
#define WHOLE_BLOCK_SIZE(p)   (BLOCK_SIZE(p)+8)
#define NEXT_BLOCK(x)         (x+WHOLE_BLOCK_SIZE(x))
#define PREV_BLOCK(x)         ((x-4)-(BLOCK_SIZE(x-4))-4)


#define IS_ALIGNED(x)         (!(x&7))
#define C_EIGHT_BYTE_ALIGN(x) (((x)&(~7))+8)
/* ceiling eight byte align */
#define F_EIGHT_BYTE_ALIGN(x) ((x)&(~7))
/* floor eight byte align */

#define FREE_LIST_FOLLOW(p)   ((void *)DREF_UINT(p))
#define FREE_LIST_NEXT(p)     ((void *)(UI(p)+8))
#define FREE_LIST_PREV(p)     ((void *)(UI(p)+4))

#define MEM_USAGE             (UI(mem_usage))
#define DSEG_LO               (UI(dseg_lo))
#define DSEG_HI               (UI(dseg_hi))
#define MY_SIZE               (DSEG_HI-DSEG_LO)

#define START_SPOT            ((void *)(DSEG_LO+8))
#define END_SPOT              ((void *)(DSEG_HI-4))
#define HEADER_SIZE           (8)




team_t team = {
    /* Team name to be displayed on webpage */
    "<blink>Three MCs and One DJ</blink>",
    /* First member full name */
    "Ignacio Thayer",
    /* First member email address */
    "iet",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


int mm_init (void)
{

  if ((int)MY_SIZE==-1) 
    {
      if (mem_sbrk(mem_pagesize())==NULL)
	return -1;
    }
  
  if ((int)MY_SIZE!=-1)
    {
      DREF_UINT(START_SPOT)=UI(MY_SIZE-HEADER_SIZE-7); /* take off header and control blocks */
      DREF_UINT(START_SPOT)=BLOCK_SIZE(START_SPOT);
      DREF_UINT(END_OF_BLOCK(START_SPOT))=BLOCK_SIZE(START_SPOT);

      SET_BLOCK_FREE(START_SPOT);
      SET_BLOCK_FREE(END_OF_BLOCK(START_SPOT));
      
      FREE_LIST=UI(START_SPOT);

      (void *)DREF_UINT(FREE_LIST_PREV(START_SPOT))=NULL;

      (void *)DREF_UINT(FREE_LIST_NEXT(START_SPOT))=NULL;


      return 0;
    }
  else 
    return -1;
}

void *mm_malloc (size_t size)
{


  if (FREE_LIST==0)
    {
      TEMP_VAR=DSEG_HI+1;
      if (mem_sbrk(mem_pagesize())==NULL)
	{
	  return -1;
	}
      if (BLOCK_IS_FREE(TEMP_VAR-4)) /* then coalesce by setting tempvar to
					block before it*/
	{
	  TEMP_VAR=((TEMP_VAR-4)-(BLOCK_SIZE(TEMP_VAR-4))-4);
	  /*DREF_UINT((TEMP_VAR-4)-(BLOCK_SIZE(TEMP_VAR-4))-4)=DSEG_HI;*/
	  /* if you're coalescing leave this block at the same spot in free list */
	}
      else
	{ /* if not coalescing, put at beginning of free list */
	  (void *)DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))=FREE_LIST;
	  if (DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))!=0)
	    DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))))=
	      TEMP_VAR;
	  (void *)DREF_UINT(FREE_LIST_PREV(TEMP_VAR))=NULL;
	  FREE_LIST=TEMP_VAR;
	}
      
      DREF_UINT(TEMP_VAR)=DSEG_HI-TEMP_VAR-6; /* -8 for the two size blocks */
      SET_BLOCK_FREE(TEMP_VAR);
      DREF_UINT(END_OF_BLOCK(TEMP_VAR))=BLOCK_SIZE(TEMP_VAR);
      SET_BLOCK_END_FREE(TEMP_VAR);
    }
  else
    {
      TEMP_VAR = FREE_LIST;
      
      while ((TEMP_VAR!=0)&&(BLOCK_SIZE(TEMP_VAR)<size+7))
	{
	  
	  TEMP_VAR = DREF_UINT(FREE_LIST_NEXT(TEMP_VAR));
	  if ((TEMP_VAR==0)||(FREE_LIST==0))
	    {
	      /* no block big enough in free list */
	      /* allocate new page, then incorporate it into free list */
	      TEMP_VAR=DSEG_HI+1;
	      if (mem_sbrk(mem_pagesize())==NULL)
		{
		  return -1;
		}
	      if (BLOCK_IS_FREE(TEMP_VAR-4)) /* then coalesce by setting tempvar to
						block before it*/
		{
		  TEMP_VAR=((TEMP_VAR-4)-(BLOCK_SIZE(TEMP_VAR-4))-4);
		  if (BLOCK_SIZE(TEMP_VAR)>=8)
		    {/* then it has blocks of its own, keep them */
		      /* really should move this to beginning of free list */
		    }
		  else
		    { /* have to put new blocks in, this has no blocks */
		      DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))=FREE_LIST;
		      if (DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))!=0)
			DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))))=
			  TEMP_VAR;
		      DREF_UINT(FREE_LIST_PREV(TEMP_VAR))=0;
		      FREE_LIST=TEMP_VAR;
		    }
		}
	      else
		{ /* if not coalescing, put at beginning of free list */
		  (void *)DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))=FREE_LIST;
		  if (DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))!=0)
		    DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))))=TEMP_VAR;
		  (void *)DREF_UINT(FREE_LIST_PREV(TEMP_VAR))=NULL;
		  FREE_LIST=TEMP_VAR;
		}
	      
	      DREF_UINT(TEMP_VAR)=DSEG_HI-TEMP_VAR-6; /* -8 for the two size blocks */
	      SET_BLOCK_FREE(TEMP_VAR);
	      DREF_UINT(END_OF_BLOCK(TEMP_VAR))=BLOCK_SIZE(TEMP_VAR);
	      SET_BLOCK_END_FREE(TEMP_VAR);
	      
	    }
	  
	}
    }
  
  if (TEMP_VAR!=0)
    {
      if (!IS_ALIGNED((UI(TEMP_VAR)+BLOCK_SIZE(TEMP_VAR)-size-4)))
	{
	  
	  size += (((UI(TEMP_VAR)+BLOCK_SIZE(TEMP_VAR)-size-4))-
		   (F_EIGHT_BYTE_ALIGN((UI(TEMP_VAR)+BLOCK_SIZE(TEMP_VAR)-size-4))));
	  
	  
	}
      /* set size at end of big block to requested size*/
      DREF_UINT(END_OF_BLOCK(TEMP_VAR))=size;
      
      if (((int)BLOCK_SIZE(TEMP_VAR)-size)>16) /* if free block has enough to hold 2 controlblocks plus free list pointers */
	{
	  
	  /* set size of leftover block to leftover */
	  DREF_UINT(TEMP_VAR)=BLOCK_SIZE(TEMP_VAR)-size-8;
	  
	  /* the other -8 is to keep track of new blocks' size */
	  /* set leftover size at end of new free block */
	  DREF_UINT(END_OF_BLOCK(TEMP_VAR))=BLOCK_SIZE(TEMP_VAR);
	  
	  /* set leftover to free */
	  SET_BLOCK_FREE(TEMP_VAR);
	  SET_BLOCK_END_FREE(TEMP_VAR);
	  
	  
	  /* set tempvar to point to the new full block */
	  TEMP_VAR = UI(END_OF_BLOCK(TEMP_VAR))+4;
	  
	}
      
      else 
	{ 
	  /* take it out of free list */
	  if (DREF_UINT(FREE_LIST_PREV(TEMP_VAR))!=0)
	    {
	      DREF_UINT(FREE_LIST_NEXT(DREF_UINT(FREE_LIST_PREV(TEMP_VAR))))=
		DREF_UINT(FREE_LIST_NEXT(TEMP_VAR));
	    }
	  else
	    {/* if it is 0 then we're being pointed to by freelist */
	      FREE_LIST=(DREF_UINT(FREE_LIST_NEXT(TEMP_VAR)));
	    }
			  
	  if (DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))!=0)
	    DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))))=
	      DREF_UINT(FREE_LIST_PREV(TEMP_VAR));
	  
	  /* set it to be usable space */
	  if ((int)((int)(BLOCK_SIZE(TEMP_VAR))-size-8)>=8)
	    {
	      DREF_UINT(TEMP_VAR)=((int)((int)BLOCK_SIZE(TEMP_VAR)-size-8));
	      DREF_UINT(END_OF_BLOCK(TEMP_VAR))=BLOCK_SIZE(TEMP_VAR);
	      
	      SET_BLOCK_FREE(TEMP_VAR);
	      SET_BLOCK_END_FREE(TEMP_VAR);
	      
	      TEMP_VAR = UI(END_OF_BLOCK(TEMP_VAR))+4;
	      
	    }
	  else
	    {
	      /* otherwise waste it */
	      SET_BLOCK_FULL(TEMP_VAR);
	      SET_BLOCK_FULL(TEMP_VAR+((int)BLOCK_SIZE(TEMP_VAR)-size-8)+4);
	      /* set tmepvar to point to the new full block */
	      TEMP_VAR = (UI(TEMP_VAR)+BLOCK_SIZE(TEMP_VAR)-size-8);
	    }
	  
	  
	}
      
      DREF_UINT(TEMP_VAR) = size;
      
      /* set returned block to full */
      SET_BLOCK_FULL(TEMP_VAR);
      SET_BLOCK_END_FULL(TEMP_VAR);
      
      
      return (void *)(UI(TEMP_VAR)+4);
    }
  else
    {
      return NULL;
    }

}

void mm_free (void *ptr)
{

 TEMP_VAR=(unsigned int)(ptr)-4;
 
 
 if (!BLOCK_IS_FREE(TEMP_VAR)) /* make sure its been allocked */
   {

     if ((TEMP_VAR>START_SPOT)&&(NEXT_BLOCK(TEMP_VAR)<dseg_hi)&&(BLOCK_IS_FREE(TEMP_VAR-4))&&
	 (BLOCK_IS_FREE(NEXT_BLOCK(TEMP_VAR))))
       {/* if the two blocks surrounding are free */
	 /* coalesce into giant block */
	 
	 /* check to see if block after me has free list pointers and
	    fix them (get rid of them) */
	 if (BLOCK_SIZE(NEXT_BLOCK(TEMP_VAR))>=8)
	   { /* yes has pointers */
	     if (DREF_UINT(FREE_LIST_NEXT(NEXT_BLOCK(TEMP_VAR)))!=0)
	       DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(NEXT_BLOCK(TEMP_VAR)))))=DREF_UINT(FREE_LIST_PREV(NEXT_BLOCK(TEMP_VAR)));
	     
	     if (DREF_UINT(FREE_LIST_PREV(NEXT_BLOCK(TEMP_VAR)))!=0)
	       {
		 DREF_UINT(FREE_LIST_NEXT(DREF_UINT(FREE_LIST_PREV(NEXT_BLOCK(TEMP_VAR)))))=DREF_UINT(FREE_LIST_NEXT(NEXT_BLOCK(TEMP_VAR)));
	       }
	     else if (FREE_LIST=NEXT_BLOCK(TEMP_VAR))
	       {
		 FREE_LIST=DREF_UINT(FREE_LIST_NEXT(NEXT_BLOCK(TEMP_VAR)));
	       }
	   } /* if it has no pointers, dont worry about it */
	 
	 /* check to if the block before me has pointers */
	 if (BLOCK_SIZE(PREV_BLOCK(TEMP_VAR))>=8)
	   {
	     /* yes has poitnres */
	     if (DREF_UINT(FREE_LIST_NEXT(PREV_BLOCK(TEMP_VAR)))!=0)
	       DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(PREV_BLOCK(TEMP_VAR)))))=DREF_UINT(FREE_LIST_PREV(PREV_BLOCK(TEMP_VAR)));
	     
	     if (DREF_UINT(FREE_LIST_PREV(PREV_BLOCK(TEMP_VAR)))!=0)
	       {
		 DREF_UINT(FREE_LIST_NEXT(DREF_UINT(FREE_LIST_PREV(PREV_BLOCK(TEMP_VAR)))))=DREF_UINT(FREE_LIST_NEXT(PREV_BLOCK(TEMP_VAR)));
	       }
	     else if (FREE_LIST=PREV_BLOCK(TEMP_VAR))
	       {
		 FREE_LIST=DREF_UINT(FREE_LIST_NEXT(PREV_BLOCK(TEMP_VAR)));
	       }
	   } /* if it has no pointers, dont worry about it */
	 
	 /* now that we've dealt with the free list pointers 
	    lets set the size of the new block and set its pointers */
	 
	 DREF_UINT(PREV_BLOCK(TEMP_VAR))=BLOCK_SIZE(PREV_BLOCK(TEMP_VAR))
	   +BLOCK_SIZE(TEMP_VAR)
	   +BLOCK_SIZE(NEXT_BLOCK(TEMP_VAR))+16; /* absorbing 4 control blocks */
	 
	 TEMP_VAR=PREV_BLOCK(TEMP_VAR);
	 DREF_UINT(END_OF_BLOCK(TEMP_VAR))=BLOCK_SIZE(TEMP_VAR);
	 
	 DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))=FREE_LIST;
	 if (DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))!=0)
	   DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))))=TEMP_VAR;
	 DREF_UINT(FREE_LIST_PREV(TEMP_VAR))=0;
	 FREE_LIST=TEMP_VAR;
	 
	 SET_BLOCK_FREE(TEMP_VAR);
	 SET_BLOCK_END_FREE(TEMP_VAR);
	 /* also set it to free */
	 
       } 
     /* ok, not surrounded by freeness, but check one right before it */
     else if ((TEMP_VAR>START_SPOT)&&(BLOCK_IS_FREE(TEMP_VAR-4)))
       {
	 /* coalesce */
	 
	 /* check to see if block before has free pointers */
	 if (BLOCK_SIZE(PREV_BLOCK(TEMP_VAR))>=8)
	   {
	     /* yes has pointers */
	     if (DREF_UINT(FREE_LIST_NEXT(PREV_BLOCK(TEMP_VAR)))!=0)
	       DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(PREV_BLOCK(TEMP_VAR)))))=DREF_UINT(FREE_LIST_PREV(PREV_BLOCK(TEMP_VAR)));
	     
	     if (DREF_UINT(FREE_LIST_PREV(PREV_BLOCK(TEMP_VAR)))!=0)
	       {
		 DREF_UINT(FREE_LIST_NEXT(DREF_UINT(FREE_LIST_PREV(PREV_BLOCK(TEMP_VAR)))))=
		   DREF_UINT(FREE_LIST_NEXT(PREV_BLOCK(TEMP_VAR)));
	       }
	     else if (FREE_LIST=PREV_BLOCK(TEMP_VAR))
	       {
		 FREE_LIST=DREF_UINT(FREE_LIST_NEXT(PREV_BLOCK(TEMP_VAR)));
	       }
	   } /* if it has no pointers, leave it alone */
	     
	 /* now we set the size of the new block thats a summation of me and the block in front of
	    me */
	 DREF_UINT(PREV_BLOCK(TEMP_VAR))=BLOCK_SIZE(PREV_BLOCK(TEMP_VAR))
	   +BLOCK_SIZE(TEMP_VAR)+8; /* absorbing 2 control blocks */
	 
	 TEMP_VAR=PREV_BLOCK(TEMP_VAR);
	 DREF_UINT(END_OF_BLOCK(TEMP_VAR))=BLOCK_SIZE(TEMP_VAR);
	 
	 DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))=FREE_LIST;
	 if (DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))!=0)
	   DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))))=TEMP_VAR;
	 DREF_UINT(FREE_LIST_PREV(TEMP_VAR))=0;
	 FREE_LIST=TEMP_VAR;
	 
	 SET_BLOCK_FREE(TEMP_VAR);
	 SET_BLOCK_END_FREE(TEMP_VAR);

       }
     else /* ok doesnt have free block in front either */
       { /* just set this block to free and put it in the free list if room */
	 SET_BLOCK_FREE(TEMP_VAR);
	 SET_BLOCK_END_FREE(TEMP_VAR);

	 /* have this point to first block on free list */
	 if (BLOCK_SIZE(TEMP_VAR)>8)
	   
	   {
	     DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))=FREE_LIST;
	     if (DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))!=0) /* if its not null */
	       /* follow it and have that block point back to me */
	       DREF_UINT(FREE_LIST_PREV(DREF_UINT(FREE_LIST_NEXT(TEMP_VAR))))=TEMP_VAR;
	     
	     /* put me first on the free list */
	     DREF_UINT(FREE_LIST_PREV(TEMP_VAR))=0;
	     FREE_LIST=TEMP_VAR;
	   }
       }
     
     
     
   }     /* if block is not full, do nothing */
 
     
     

}
