/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Jesiatha",
    /* First member full name */
    "Eric Heutchy",
    /* First member email address */
    "eheutchy",
    /* Second member full name (leave blank if none) */
    "Ethan Tira-Thompson",
    /* Second member email address (blank if none) */
    "ejt"
};

#define BUCKETS ((unsigned int *)dseg_lo)
#define BUCKSIZE (32 * 4)
#define ALIGN(n) ((n + 7) & (~7))

inline int ToBucket(int n)
{
	int count = 0;
	while (n) { count++; n >>= 1; }
	if (count < 4) count = 4;
	return count;
}

int mm_init (void)
{
	unsigned int i;
	if ((int)dseg_hi - (int)dseg_lo < BUCKSIZE)
	{
		mem_sbrk(BUCKSIZE + (int)dseg_lo - (int)dseg_hi);
	}

	for (i = 0; i < 32; i++) BUCKETS[i] = 0;

    return 0;
}

void *mm_malloc (size_t size)
{
	char *temp;
	int bucket;
	unsigned int *previous;
	unsigned int *current;
	size = ALIGN(size);
	bucket = ToBucket(size);
	previous = &(BUCKETS[bucket]);
	current = *previous;
	while (0 != current)
	{ // have a bucket
		if (*(current - 2) >= size)
		{
			*previous = *current;
			return current;
		}
		previous = current;
		current = *current;
	} // have a bucket

	{ // make a bucket
		temp = dseg_hi;
		if (NULL == mem_sbrk(size + 8)) printf("Dang");
		*((unsigned int *)temp) = size;
		return temp + 8;
	} // make a bucket

}

void mm_free (void *ptr)
{
	int bucket;
	unsigned int prior;
	bucket = ToBucket(*((int *)(ptr) - 2));

	prior = BUCKETS[bucket];
	*((unsigned int*)ptr) = prior;
	BUCKETS[bucket] = (unsigned int)ptr;
}