/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Operation: Power Lunch",
    /* First member full name */
    "Konstantine Prevas",
    /* First member email address */
    "kprevas",
    /* Second member full name (leave blank if none) */
    "Douglas Strain",
    /* Second member email address (blank if none) */
    "dstrain"
};

/**********************************************************
Summary:
Our malloc keeps 30 segregated lists, corresponding to
sizes below a given power of 2, with 16 being the minimum
block size.  Every block has an 8-byte header, with the
first four bytes representing the size of the previous
block, the second four representing the size of the block
in question, and the last bit of the first four bytes
indicating whether the block is free or not.  Free blocks
use the third four bytes to store a pointer to the previous
block, and the fourth four bytes for a pointer to the next
block.
***********************************************************/

int log2(unsigned long x)
{
int p=!((x>>16)>>31)&(!!(x>>16));
int c=p<<4;
x=x>>(p<<4);
p=!((x>>8)>>31)&(!!(x>>8));
c=c + (p<<3);
x=x>>(p<<3);
p=!((x>>4)>>31)&(!!(x>>4));
c=c + (p<<2);
x=x>>(p<<2);
p=!((x>>2)>>31)&(!!(x>>2));
c=c + (p<<1);
x=x>>(p<<1);
p=!((x>>1)>>31)&(!!(x>>1));
c=c + (p);
return c;
}

int class_of(unsigned long size)
{
  return log2(size/8);
}



int mm_init (void)
{
  void **start = (void **)dseg_lo;
  int t;
  const int numclasses = 30;

  if(mem_usage()<=0){              /*need to allocate heap space*/
    if(!mem_sbrk(mem_pagesize()*3)) return -1;
  }
  for(t=0; t<numclasses; t++)          /*init table of list head ptrs*/
    start[t]=0;
  start[class_of(mem_usage()-(numclasses*sizeof(int *)-1))]=(start+numclasses);
  /*init first list*/
  start[numclasses]=(void *)1;  /*block is free, no previous block*/
  start[numclasses+1]=(void *)((mem_usage()+1)-(numclasses*sizeof(int *)));
                                /*set size of first block*/
  start[numclasses+2]=NULL;     /*no previous block*/
  start[numclasses+3]=NULL;     /*no next block*/
  return 0;
}

void insert(void *ptr, unsigned long size)
{
  void **start = (void **)dseg_lo;
  int class =class_of(size);

  if(start[class]!=NULL)
    ((void **)start[class])[2] = ptr;   /*set old first's PREV to new element*/

  ((int *)ptr)[0] = ((int *)ptr)[0] | 1;/*indicate free block*/
  ((void **)ptr)[1] = (void *)size;     /*set new element's size*/
  ((void **)ptr)[3] = start[class];     /*set new element's NEXT to old first*/
  ((void **)ptr)[2] = NULL;             /*set new element's PREV to null*/

  if (ptr+size<(void *)dseg_hi){        /*if there's a next block*/
    ((int *)ptr)[size/4] = size | (((int *)ptr)[size/4]&1);
  }                                     /*set backtrace size on next block*/

  start[class] = ptr;                   /*update list header*/
}

void delete(void *ptr, int class)
{
  void *prev=*((void **)(ptr+8));
  void *next=*((void **)(ptr+12));
  /*read previous and next pointers*/

  if(prev!=NULL) ((void**)prev)[3]=next;
  /*set PREV's NEXT to NEXT*/

  if(prev==NULL) ((void **)dseg_lo)[class]=next;
  /*if first in list, point list header to NEXT*/

  if(next!=NULL) ((void**)next)[2]=prev;
  /*set NEXT's PREV to PREV*/
}

void *mm_malloc (size_t size)
{
  void **start = (void**)dseg_lo;
  void *top;
  int class = class_of(size+8);
  const int numclasses = 30;
  unsigned long currsize;
  unsigned long newsize;
  void *current;

  size+=8; /*for header*/
  while(class<numclasses){
    current = start[class];
    while(current!=NULL){            /*traverse list*/
      currsize=((int *)current)[1];
      if(currsize>=size){            /*fits!*/
	if(currsize-size<16){        /*fits perfectly!*/
	  delete(current, class);    /*remove from free list*/
	  ((int *)current)[0]=((int *)current)[0]&(~1); /*indicate used*/
	  return (current+8);
	} else {               /*fits not so perfectly.*/
	  delete(current, class);    /*remove from free list*/
	  newsize = currsize-size;
	  newsize-=newsize%8;
	  insert(current+(currsize-newsize), newsize); /*insert new chunk*/
	  ((int *)current)[0]=((int *)current)[0]&(~1);/*indicate used*/
	  ((int *)current)[1]=currsize-newsize;        /*set size*/
	  ((int *)current)[(currsize-newsize)/4]=(currsize-newsize)|1;
                                                       /*set backtrace size*/
	  return(current+8);
	}
      }
      current = ((void **)current)[3];/*try next block*/
    }
    class++;      /*no room, try next class*/
  }
  top = dseg_hi+1;
  if(!mem_sbrk((size+8)-((size+8)%mem_pagesize())+mem_pagesize())){
    return NULL;  /*no room at all!*/
  } else {        /*allocate some more space*/
    insert(top, (size+8)-((size+8)%mem_pagesize())+mem_pagesize());
    ((int *)top)[0] = 1;
  }
  return mm_malloc(size);
}

void mm_free (void *ptr)
{
  int size = *((int *)(ptr-4));
  void *current=ptr-8+size;
  int backsize;

  /*forwards coalesce*/
  if(current<=(void *)dseg_hi)
    {
      if((*((int *)(current))&1)==1){  /*next block is free*/
	delete(current, class_of(*((int *)(current+4)))); /*delete from free*/
	size+=*((int *)(current+4));   /*increase size of new free block*/
      }
    }

  /*backwards coalesce*/
  current = ptr-8;
  if((*((int *)(current))&(~1))!=0){   /*previous block exists*/
    if((*((int *)(current - (*((int *)(current))))) & 1)  ==  1){ /*& is free*/
      backsize=(*((int *)current)&(~1));
      ptr-=backsize;
      delete(ptr-8, class_of(*((int *)(ptr-4)))); /*delete from free*/
      size+=backsize;                  /*increase size of new free block*/
    }
  }

  insert(ptr-8,size); /*insert new free block*/
}

















