/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "At least it ain't ML",
    /* First member full name */
    "David N. Dixon",
    /* First member email address */
    "dnd@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

#define LASTSIZE 13
#define INTSIZE 1
#define EIGHT 2
#define FIRSTB 16      /* 16 */
#define SECONDB 64     /* 64 */
#define THIRDB  128    /* 128 */
#define FOURTHB 512   /* 512  */
#define FIFTHB 4080    /* 4080 */
#define SIXTHB 8000   /* 7000 */


/*
data structure as follows (notes for you and for me, because i would forget)
dseg_lo +  1 -> 16 bytes <= size < 64 bytes
dseg_lo +  3 -> 64 bytes <= size < 128 bytes
dseg_lo +  5 -> 128 bytes <= size < 512 bytes
dseg_lo +  7 -> 512 bytes <= size < 4080 bytes
dseg_lo +  9 -> 4080 bytes <= size < 8000 bytes
dseg_lo + 11 -> 8000 bytes <= size < positive infinity (well, if you had a rudich machine).

each 8-byte header location is comprised of 4-bytes of NULL (to identify as the head pointer) and then the pointer in the next four bytes

dseg_lo pointer points to new place to allocate things

data allocation begins at 15 (int*) sizes or 60 bytes afterwords
1 in last bit if allocated, 0 if not allocated

sizes are stored in byte sizes and converted to (int*) sizes
all pointer arithmetic done in int *, casting to void* before the final return of malloc

*pointer gets size
*(pointer + INTSIZE) gets forward pointer
*(pointer + size/4 - INTSIZE) gets size
*(pointer + EIGHT) gets backwards pointer

Credits: Kevin Milans taught me pointer arithmetic

*/


int mm_init (void)
{
  int* base = (int*) dseg_lo, i;
  if (mem_sbrk(mem_pagesize()) == NULL) return -1;
  for (i=INTSIZE;i<LASTSIZE+EIGHT;i++) /* clear out space for my data structure, plus additional one for safety */
    {
      *(base+i) = NULL;
    }
  *base = (int) base + (LASTSIZE+EIGHT) * 4;  /* initial setup - put base location into base dereferenced */
  return 0;
}


void mm_spliceblockout(int* first)
{
  if (*(first+INTSIZE)!=NULL)
    {
      *(*(int**)(first+INTSIZE)  + EIGHT) = *(first+EIGHT);  /* forward's back to my back */
    }
      *(*(int**)(first + EIGHT) + INTSIZE ) = *(first+INTSIZE); /* back's forward to my forward */
}

/* takes in size in bytes */
/* funky cascading selection */
int mm_findoffset(int size)
{
  if (SIXTHB<=size) return 11;
  if (FIFTHB<=size) return 9;
  if (FOURTHB<=size) return 7;
  if (THIRDB<=size) return 5;
  if (SECONDB<=size) return 3;
  return 1;
}


/* i know this function looks goopy, but everytime I mess with it the dang thing breaks */
void mm_insertinto(int* first)
{
  int *base= (int*) dseg_lo,size=(*first),*temp;
  base += mm_findoffset(size);  /* find the proper header location */
  *(first + EIGHT) = (base);  /* set back to base */
  *(first + INTSIZE) = *(base+INTSIZE); /* set forward to base's forward */
  if (*(base+INTSIZE) != NULL) /* if base doesn't point to NULL */
    {
      temp = (int*) *(base+INTSIZE);
      *(temp + EIGHT) = first;  /* set base's forward's back to myself */
    }
  *(base+INTSIZE) = first;  /* standard forward */
}


void *mm_malloc (size_t size)
{
    int i,oldsize,*forward,leftoversize,*temp;
    int* base = (int*) dseg_lo;
    size = (((size+0xF) >> 3) << 3);
    i=mm_findoffset(size);  /* find the offset position */
    for (;i<LASTSIZE;i+=2)  /* scan our header tags */
      {
	forward = *((int**) base+i+INTSIZE); /* deref header tags - points to next free object */
	while(forward != NULL)
	  {
	    if (*(forward) >= size) /* if we can put it into this area */
	      {
		oldsize = *forward;
		leftoversize = oldsize - size;
		mm_spliceblockout(forward);  /* remove it from the data structure */
		
		if (leftoversize>=16)  /* what should I do with the remaining space? */
		  {
		    temp = forward + size/4;
		    *(temp + leftoversize/4 - INTSIZE) = leftoversize;
		    *(temp) = leftoversize;
		    mm_insertinto(temp); /* put remaining space back into the data structure */
		  }
		else
		  {
		    size = oldsize;  /* we can't, so we've just lost a small amount of space */
		  }

		*(forward) = size | 1;  /* set header size */
		*(forward + size/4 - INTSIZE) = size | 1;  /* set footer size */
		forward = (int*) (forward+1); /* increment header to next dword */
		return (void*) forward;
	      }
	    forward = *(forward+INTSIZE); /* move down the list */
	  }
      }

    /* so we have to create a new block -- bummer */
    if ((size + (int) *base) >= dseg_hi) /* if we have to create a new page on the stack */
      {
	mem_sbrk(size);
      }
    forward = (int*) *base;
    *forward = size | 1;
    *(forward + size/4 - INTSIZE) = size | 1;
    forward = (void*) (*base + 4);
    *base = *base + (size);  /* the trick, increment the size properly */
    return forward;
}


void mm_free (void *ptr)
{
  int *current = (int*) ptr,size,*next;
  current--; /* decrement to get our size value */
  size = *current & -2; /* block out last bit */
  next = (current + size/4);
  if (((*next & 0x1) == 0) && ( (int) (current+size) < (*dseg_lo)) && ((int) *next != 0)) /* if the next block is empty */
    {
      mm_spliceblockout(next); /* remove it from the list */
      size += *next;
    }
  next = current-INTSIZE;
  if (((*next & 0x1) == 0) && (*next != 0)) /* if the previous block is empty */
    {
      
      current = current - ((*next)/4);
      mm_spliceblockout(current);
      size += *next;
    }
  *current = size; /* change header size value */
  *(current + size/4 - INTSIZE) = size; /* change footer size value */
  mm_insertinto(current); /* insert ourselves back into the list */
}
