/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Angry Penguins",
    /* First member full name */
    "Daniel Jacobowitz",
    /* First member email address */
    "dmj@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Alyssa Wolf",
    /* Second member email address (blank if none) */
    "alyssaw@andrew.cmu.edu"
};

#if 0

To improve: which_bucket



#endif

struct sizes {
  size_t           size;
  size_t           prev_size;
};

struct freeblock {
  struct sizes     s;
  struct freeblock *prev;
  struct freeblock *next;
};

struct usedblock {
  struct sizes     s;
  char             data[0];
};


/* In 2^(n+3), as index into free_lists[]. */
/* free_lists[excess_free_list] can have an unbounded max size. */
const int excess_free_list = 15;

struct mm_status {
  size_t           highest_used;
  size_t           last_size;
  struct freeblock *free_lists[16];
};

int get_more_space(int size);
int which_bucket(size_t size);
size_t round_up_word(size_t n);


/* Size will not be 0 (malloc(0) is undefined?) */
int which_bucket(size_t size)
{
  int i = 0;
  unsigned int shift = 16;

  while(shift) {
    size_t shifted_size = size >> shift;
    if(shifted_size) {
      size = shifted_size;
      i += shift;
    }
    shift = shift / 2;
  }

  if(i < 3)
    return 0;
  else if(i < 3 + excess_free_list)
    return i - 3;
  else
    return excess_free_list;
}

size_t round_up_word(size_t n)
{
  return ((n + 7) & ~7);
}

int get_more_space(int size)
{
  int pagesize = mem_pagesize();
  int wanted;

  wanted = size + pagesize - 1;
  wanted = wanted - (wanted % pagesize);

  return (mem_sbrk(wanted) != NULL);
}

int mm_init (void)
{
  struct mm_status *state;
  int i;

  if( !get_more_space(sizeof(struct mm_status)) ) {
    return -1;
  }
  state = (struct mm_status *)dseg_lo;

  state->highest_used =
    round_up_word( (size_t)dseg_lo + sizeof(struct mm_status) );

  for(i = 0; i <= excess_free_list; i++) {
    state->free_lists[i] = 0;
  }

  state->last_size = 0;

  return 0;
}

void *mm_malloc (size_t size)
{
  struct mm_status *state = (struct mm_status *)dseg_lo;
  int bucket;
  size_t available, next_above_size = 0;
  struct freeblock *free_walk, *next_above = NULL;
  struct usedblock *new_block;

  size = round_up_word(size);

  bucket = which_bucket(size);

  free_walk = state->free_lists[bucket];
  while(free_walk) {
    /* Bucket was not NULL */
    size_t this_size = free_walk->s.size;

    if(this_size == size) {
      next_above = free_walk;
      next_above_size = this_size;
      break;
    } else {
      if(this_size > size)
	if((this_size < next_above_size) || (next_above == NULL)) {
	  next_above_size = this_size;
	  next_above = free_walk;
	}
      free_walk = free_walk->next;
    }
  }

  if(next_above) {
    struct freeblock *next, *prev;
    
    next_above->s.prev_size = next_above->s.prev_size | 1;
    
    prev = next_above->prev;
    next = next_above->next;
    
    if(prev) {
      prev->next = next;
    } else {
      state->free_lists[bucket] = next;
    }
    
    if(next) {
      next->prev = prev;
    }
    
    return (void *) ((struct usedblock *)next_above)->data;
  }
  
  /* Nothing on this free list could hold what we needed */
  /* Do something about it. */
  /* Helpful comments here. */
  /* This is where you STOPped. */

  available = (size_t)dseg_hi - state->highest_used;
  if(available < size + sizeof(struct usedblock)) {
    size_t needed = size + sizeof(struct usedblock) - available;
    if( !get_more_space(needed) )
      return NULL;
  }

  new_block = (struct usedblock *)(state->highest_used);
  new_block->s.size = size;
  new_block->s.prev_size = (state->last_size) | 1;

  state->last_size = size;
  state->highest_used += size + sizeof(struct usedblock);

  return (void *)(new_block->data);
}

void mm_free (void *ptr)
{
  struct mm_status *state = (struct mm_status *)dseg_lo;
  int bucket;
  size_t size;
  struct freeblock *block_start = ptr - sizeof(struct usedblock);

  /* Mark the block as unused */
  block_start->s.prev_size = block_start->s.prev_size & ~7;

  /* Figure out which bucket to put it in */
  size = block_start->s.size;
  bucket = which_bucket(size);

  /* Previous block pointer */
  block_start->prev = NULL;
  
  /* Next block pointer */
  block_start->next = state->free_lists[bucket];

  if(block_start->next)
    block_start->next->prev = block_start;

  state->free_lists[bucket] = block_start;
}

