/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define SIZE_MASK 0xfffffffe
#define FREE 0
#define ALLOCATED 1
#define loPtr ( ((int *)dseg_lo) + 2)
#define hiPtr ((int *)dseg_hi)
#define PTR_NEG_ONE ((void *)0xffffffff)

#define THIS_DATA *(p-2)
#define PREV_DATA *(p-1)
#define NEXT_DATA *(p - 2 + (THIS_DATA & SIZE_MASK))

#define lastSize ( *((int *)dseg_lo) )
#define lastPtr  ( *( ((int**)dseg_lo) + 1) )

team_t team = {
    /* Team name to be displayed on webpage */
    "No Sex in the Champagne Room",
    /* First member full name */
    "Ari Heitner",
    /* First member email address */
    "aheitner",
    /* Second member full name (leave blank if none) */
    "Chris Tremonte",
    /* Second member email address (blank if none) */
    "cmt2"
};

int mm_init (void)
{
  mem_sbrk(4096);

// first we set up the page of memory to be an empty block of size 1020
//   == 1024 words - 2 words of tags - 2 words of housekeeping

  *loPtr = ((1020) & SIZE_MASK) | FREE;
  *(loPtr+1)    = 0 | ALLOCATED;
  *(loPtr+1020) = 0 | ALLOCATED;
  *(loPtr+1021) = 1020 | FREE;

  lastSize = 0;
  lastPtr = loPtr;

  if ( 1 ) 
    return 0;  // successful init
  return -1; // error
}

void *mm_malloc (size_t size)
{
  int * p=lastPtr;
//  size += 8;  // to hold header & footer
//  size = (size + 3) >> 2;  // number of int words I will need
//  size = ((size+1)>>1)<<1;   // round up

  size = ((size+15)>>3)<<1;  // a slightly faster composite operation


// this loop searched through the heap for an empty slot big enough for our var
// if it reached the end of the heap, it allocates more space

  while ( (*p & 1) || ((*(int *)p) < size) )
    {
    if ( *p == (0 | ALLOCATED) )   // end of the heap
      {
      *p = 0;
      while (*p < size)
        {
        if (mem_sbrk(4096) == PTR_NEG_ONE) return NULL;
        *p += 1024;
        *(p + *p) = 0 | ALLOCATED;
        *(p + *p + 1) = *p;
        }
      break;  // now that we have a big enough block, advance to tag setup
      }
    p += (*p) & SIZE_MASK;  // jump to next block, continue searching
    }

  if ( (*p & SIZE_MASK) > size )
       // if this block is only partially full, fix some tags
    {
    *(p + size)     = ((*p & SIZE_MASK) - size);
    *(p + (*p & SIZE_MASK) + 1) -= size;
    }
    else
      *(p - 1 + size) |= ALLOCATED;

// set the tags at the beginning and end to proper vals
  *p              = size | ALLOCATED;
  *(p + size + 1) = size | ALLOCATED;

// adjust our housekeeping vars -- these help its speed
  lastSize = size;
  lastPtr = p;

// p points to the first of two tag words, data starts at p+2
  return p + 2;
}

void mm_free (void *ptr)
{

// typecaast the ptr, b/c we are using word ptrs here
  int * p = ptr;

// clear the ALLOCATED bit of the pre- and post- tags
  *(p-2) &= SIZE_MASK;
  *(p+*(p-2)-1) &= SIZE_MASK;


// Coalescing Below

  if ( (PREV_DATA & ALLOCATED) == 0)   // coalesce w/ prev
    {
    *(p - 2 - (PREV_DATA & SIZE_MASK) ) += THIS_DATA & SIZE_MASK;
    *(p - 1 + (THIS_DATA & SIZE_MASK) ) += PREV_DATA & SIZE_MASK;
    p -= PREV_DATA & SIZE_MASK; // just in case we double-coalesce
    }

  if ( ( NEXT_DATA & ALLOCATED ) == 0)  
       // coalesce w/ next
    {
    *(p - 1 + THIS_DATA + NEXT_DATA ) += THIS_DATA;
    THIS_DATA += NEXT_DATA;
    }

  lastPtr = loPtr;
}

