/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "RoachSmack",
    /* First member full name */
    "Cory Williams",
    /* First member email address */
    "cgw",
    /* Second member full name (leave blank if none) */
    "Jason Cohen",
    /* Second member email address (blank if none) */
    "cohen3"
};

/* macros */

#define LIST_HEAD ((long *)dseg_lo)
#define WILDERNESS_PTR ((long *)dseg_lo + 1)
#define REAL_SIZE(x) ((x) & ~1L)
#define FOOTER_PTR(x) ((long *)((char *)(x) + REAL_SIZE((x)[0]) - sizeof(long)))
#define NEXT_BLOCK(x) ((long *)((char *)(x) + REAL_SIZE((x)[0])))
#define PREV_BLOCK(x) ((long *)((char *)(x) - (x)[-1]))
#define NEXT(x) ((long *)((x)[1]))
#define PREV(x) ((long *)((x)[2]))

int mm_init (void)
{
  long * curr;

  if (dseg_hi - dseg_lo > 6 * sizeof(long)) 
    if (mem_sbrk(mem_pagesize()) == NULL) return -1;

  /* set LIST_HEAD to point to the first block i.e. one word after
     LIST_HEAD */
  *LIST_HEAD = (long)(LIST_HEAD + 3); 
  *WILDERNESS_PTR = *LIST_HEAD;

  /* initialize the first block: size, pointers for list (both null) */
  curr = LIST_HEAD + 3;

  curr[0] = ((dseg_hi - (char *)curr + 3) & ~7L) + 1;
  NEXT(curr) = NULL;
  /* Note that this is a hack.  The only time that we will use the 
     PREV of a block is to access the NEXT of that PREV.  This will work
     with the value we have given to the PREV of this first block. */
  PREV(curr) = LIST_HEAD - 1;
  /**FOOTER_PTR(curr) = REAL_SIZE(curr[0]);*/
  /* This is a field used to simulate a block after the last block.
     It is used in coelescing */
  FOOTER_PTR(curr)[1] = 0;
  
  return 0;
}

void *mm_malloc (size_t size)
{
  long *curr, *split, *best, *secondBest;
  long bestSize; 

  /* fix size.  Round small values up to 12 bytes, and round all others
     up to 4 * odd number of bytes. */
  if (size == 0)
    return NULL;
  else if (size < 12)
    size = 12;

  size = ((size + 3) & ~7L) + 4;
  
  /* search through list for a fit.  
     preference order for fits:
     wilderness block
     perfect fit
     block that can be split
     block that cannot be split (becuase the leftover is too small) */
  best = NULL;
  bestSize = 0;
  secondBest = NULL;
  curr = (long *)*LIST_HEAD;
  if (REAL_SIZE(*(long *)*WILDERNESS_PTR) > size + 20) {
    curr = (long *)*WILDERNESS_PTR;
  } else {
    while ((NEXT(curr) != NULL) && (bestSize == 0)) {
      if (size + 4 == REAL_SIZE(curr[0])) {
	/* set allocated bit in next block and remove the block from the 
	   list */
	NEXT_BLOCK(curr)[0] |= 1;
	NEXT(PREV(curr)) = NEXT(curr);
	PREV(NEXT(curr)) = PREV(curr);

	return (void *)(curr + 1);
	
      } else if (size + 20 <= REAL_SIZE(curr[0])) {
	if ((bestSize == 0) || (curr[0] < bestSize)) {
	  best = curr;
	  bestSize = curr[0];
	}
      } else if (size + 4 < REAL_SIZE(curr[0])) {
	secondBest = curr;
      }
      curr = NEXT(curr);
    }
  }

  /* Here we choose a block to split (or not) or whether to take off the 
     wilderness block (possibly allocate more memory) */

  if (best != NULL) {
    /* split the block, set up the first and second, add the second 
       into the list and return the first */
    curr = best;
    split = curr + (size + 4) / 4;
    /* set allocated flag for curr, also */
    split[0] = REAL_SIZE(curr[0]) - (size + 4) + 1;
    *FOOTER_PTR(split) = REAL_SIZE(split[0]);
    NEXT(split) = NEXT(curr);
    PREV(split) = PREV(curr);
    NEXT(PREV(split)) = split;
    PREV(NEXT(split)) = split;
    
    curr[0] = size + 4 + (curr[0] & 1L);
    *FOOTER_PTR(curr) = curr[0];

    return (void *)(curr + 1);
  } else if (secondBest != NULL) {
    /* treat this just like a perfect fit.  We just dont use all the 
       memory we allocate. */
    curr = secondBest;
    NEXT_BLOCK(curr)[0] |= 1;
    NEXT(PREV(curr)) = NEXT(curr);
    PREV(NEXT(curr)) = PREV(curr);

    return (void *)(curr + 1);
  }

  /* by now, we have eliminated all possiblities, so we check the last block
     and allocate more memory if needed. */

  if (size + 20 > REAL_SIZE(curr[0])) {
    if (!mem_sbrk(((size + 20 - REAL_SIZE(curr[0])) / mem_pagesize() + 1) 
		  * mem_pagesize())) {
      return NULL;
    }
    
    curr[0] = ((dseg_hi - (char *)curr) & ~7L) + (curr[0] & 1L);
    /**FOOTER_PTR(curr) = REAL_SIZE(curr[0]);*/
    /* see mm_init for why we do this */
    FOOTER_PTR(curr)[1] = 0;
  }

  split = curr + (size + 4) / 4;
  /* set allocated flag for curr, also */
  split[0] = REAL_SIZE(curr[0]) - (size + 4) + 1;
  /**FOOTER_PTR(split) = REAL_SIZE(split[0]);*/
  NEXT(split) = NEXT(curr);
  PREV(split) = PREV(curr);
  NEXT(PREV(split)) = split;

  *WILDERNESS_PTR = (long)split;
  
  curr[0] = size + 4 + (curr[0] & 1L);
  *FOOTER_PTR(curr) = curr[0];

  return (void *)(curr + 1);
}

void mm_free (void *ptr)
{
  long *curr, *temp, *temp2;

  if (ptr == NULL) return;

  /*check for other free blocks and coalesce with them */
  curr = (long *)ptr - 1;
  if ((curr[0] & 1L) == 0) {
    if ((NEXT_BLOCK(NEXT_BLOCK(curr))[0] & 1L) == 0) {
      /* free block on both sides */
      /* update first block and its new footer, and remove second block
	 and put the first block where the second one was */

      temp = PREV_BLOCK(curr);
      temp[0] += REAL_SIZE(curr[0]) + 
	REAL_SIZE(NEXT_BLOCK(curr)[0]);
      *FOOTER_PTR(temp) = REAL_SIZE(temp[0]);
      NEXT(PREV(temp)) = NEXT(temp);
      PREV(NEXT(temp)) = PREV(temp);

      temp2 = NEXT_BLOCK(curr);
      NEXT(temp) = NEXT(temp2);
      PREV(temp) = PREV(temp2);
      NEXT(PREV(temp2)) = temp;
      if (NEXT(temp2) != NULL)
	PREV(NEXT(temp2)) = temp;
      else
	*WILDERNESS_PTR = (long)temp;
    } else {
      /* free block on left */
      /* update this block and new footer, and set flag in next block */

      temp = PREV_BLOCK(curr);
      NEXT_BLOCK(curr)[0] &= ~1L;
      temp[0] += REAL_SIZE(curr[0]);
      *FOOTER_PTR(temp) = REAL_SIZE(temp[0]);
    }
  } else {
    if ((NEXT_BLOCK(NEXT_BLOCK(curr))[0] & 1L) == 0) {
      /* free block on right */
      /* update this block and new footer, remove next block, add this block */

      temp = NEXT_BLOCK(curr);
      curr[0] += REAL_SIZE(temp[0]);
      *FOOTER_PTR(curr) = REAL_SIZE(curr[0]);

      NEXT(curr) = NEXT(temp);
      PREV(curr) = PREV(temp);
      NEXT(PREV(curr)) = curr;
      if (NEXT(curr) != NULL) 
	PREV(NEXT(curr)) = curr;
      else
	*WILDERNESS_PTR = (long)curr;
    } else {
      /* no bordering free blocks */
      /* set flag in next block, add footer, and insert into front of list */
      curr = (long *)ptr - 1;
      NEXT_BLOCK(curr)[0] &= ~1L;
      *FOOTER_PTR(curr) = REAL_SIZE(curr[0]);
      PREV(curr) = PREV((long *)(*LIST_HEAD));
      NEXT(curr) = (long *)(*LIST_HEAD);
      PREV(NEXT(curr)) = curr;
      NEXT(PREV(curr)) = curr;
    }
  }
}


