#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "<font color=red>yawar mayu</font>",
    /* First member full name */
    "Andrew Gardner",
    /* First member email address */
    "asg",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* define'd functions and helper jazz... */

/* important pointers and their friends */
#define free_list_root_ptr (*((int*)(dseg_lo)))
#define wilderness_chunk_ptr (*((int*)(dseg_lo+8)))

/* used to make overhead stuff */
#define OFFSET 8


/* --------------------> mm_init <-------------------- */

int mm_init (void) {
  int SYS_PAGE_SIZE;
  int INIT_MEM_SIZE; /* initial memory size request */
  int i,j,length;  /* counters, a temp */
  int* curr;
  int mem_init_length;

  int mem_init_chunks[] = { 1, 4104,
			    2, 8200,
			    1,  16 }; /* wilderness chunk */

  mem_init_length = 6;

  INIT_MEM_SIZE = 0;
  
  SYS_PAGE_SIZE = mem_pagesize();

  /* 
     Find INIT_MEM_SIZE 
  */

  for( i = 0; i < mem_init_length; i += 2 ){
    INIT_MEM_SIZE += ( ( mem_init_chunks[i+1] ) ) * mem_init_chunks[i];
  }
  INIT_MEM_SIZE += OFFSET; /* for housekeeping overhead, alignment */

  /* remember wilderness chunk pointer (should be later, but value here now */
  (int*)wilderness_chunk_ptr = INIT_MEM_SIZE;

  /* make INIT_MEM_SIZE page boundary happy */
  INIT_MEM_SIZE = ( (INIT_MEM_SIZE/SYS_PAGE_SIZE) + 1 ) * SYS_PAGE_SIZE;
  
  /* 
     Make INIT_MEM_SIZE request
  */

  if( !mem_sbrk( INIT_MEM_SIZE ) )
    return 1;

  *(dseg_lo) = 0;

  /* 
     Prepare housekeeping overhead words
  */

  /* make free_list_root_ptr */
  (int*)free_list_root_ptr = (int*)dseg_lo+4;

  /* make all of the ckunkies, setting headers and footers and things */

  curr = (int*)dseg_lo+4;

  for( i=1; i<mem_init_length; i+=2 ){ /* for each chunk size */
    for( j=0; j<mem_init_chunks[i-1]; j+=1 ){ /* make this many chunks */
             
      length = ( ( mem_init_chunks[i] ) );
      
      if( i == mem_init_length-1 )
	length = (int)dseg_hi - (int)dseg_lo+4 + OFFSET;
       
      /* first step, write length in header */
      /**((int*)current_ptr) = length;*/
      
      *curr = length;

      /* second step, write length in footer */
      /**((int*)current_ptr+length-4) = length;*/
      
      *(curr+length/4-1) = length;

      /* third step, write forward pointer */
      /**((int*)current_ptr+4) = current_ptr+length; */

      *(curr+1)= (int)curr+length;
      
      if( j != 0 ){
	*(curr+2) = (int)curr-*curr;
      }else{
	if( i != 1 )
	  *(curr+2) = (int)curr - mem_init_chunks[i-2];
	else
	  *(curr+2) = 0;
      }
      
      /* current_ptr += length;*/
      curr += length/4;

    }
  }

  /* modify the wilderness chunk */
  
  curr -= length/4;

  length = (int)dseg_hi - (int)curr;
  *curr = length;
  *(curr+length/4-1) = length;
  *(curr+1)= 0;

  wilderness_chunk_ptr = (int)curr;

  return 0;
}

/* --------------------> mm_malloc <------------------ */

void *mm_malloc( size_t size ) {

  int *curr, *prev_f, *for_p, *extra_chunk;
  int pagesize;

  curr = NULL;

  /* algorith:
     attempt to find something useful in the free list
     if there isn't anything in the free list, mem_sbrk
     more memory
     */

  curr = (int*)free_list_root_ptr;

  while( curr != NULL ){
#if MALLOC_DEBUG > 0
    printf("--->%d",*curr);
#endif
    if( (*curr) > (size+8) ){
      break;
    }
    curr = (int*)*(curr+1);
  }
  
  if(curr){
#if MALLOC_DEBUG > 0    
    printf("\nfound:%d,%d\n",size,*curr);
#endif    
    /* need to remove current node from the free list */
    
    /* first, make previous node point to my next node */

    prev_f = (int*)*(curr+2);
    if( prev_f ){
      prev_f++;
      *prev_f = *(curr+1);
    }else{
      free_list_root_ptr = *(curr+1);
    }

    /* next, make next node point back to my previous */
    
    for_p = (int*)*(curr+1);
    if( for_p ){
      for_p += 2;
      *for_p = *(curr+2);
    }

    /* we may need to hurt this chunk */
    
    if( *curr > 4*size ){
#if MALLOC_DEBUG > 0
      printf("Adjusted...\n");
#endif 
      /* 
	 now that we've established that this is a dumb 
	 malloc to make, give back a chunk of size+8 and
	 turn the extra into a new chunk to put on the
	 free list
      */

      pagesize = ((size+8)/8)*8 + 8;

      extra_chunk = curr+pagesize/4;
      *extra_chunk = *curr-pagesize;

      *curr = pagesize;

      *(extra_chunk+1) = free_list_root_ptr;

      *(extra_chunk+2) = 0;

      free_list_root_ptr = (int)extra_chunk;

      *((int*)free_list_root_ptr+8) = (int)extra_chunk;

    }

      return curr+2;
  }


  /* couldn't find anything in the free list,
     must mem_sbrk new memory */
  
  pagesize = ((size+8)/8) * 8 + 8;
#if MALLOC_DEBUG > 0  
  printf("sbrked\t%d\t%d\n",size,pagesize);
#endif  
  curr = (int*)(dseg_hi+1);
  *curr = pagesize;
  curr += 2;

  if(!mem_sbrk( pagesize )){
    return NULL;
  }
  return curr;
}


/* --------------------> mm_free<--------------------- */

void mm_free( void *ptr ){

  int *chunk, *start;
  
  chunk = (int*)ptr;

  chunk -= 2;

  start = (int*)free_list_root_ptr;
  
  *(chunk+1) = (int)start;
  *(chunk+2) = 0;
  
  *(chunk+(*chunk)/4-1) = *chunk;
  
  free_list_root_ptr = (int)chunk;    

#if FREE_DEBUG > 0  
  printf("Freed:%d\n",*chunk);
#endif

  return;
}
