
/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/*
My malloc performs a next-fit search on a single free list. 

My implementation uses an 8 byte header and footer for each block.  The first 4 bytes of the header contains a pointer to the next element in the free list (if the element is free).  The next 4 bytes contain the size of the block ... the last byte is a 0 if the block is free and a 1 if the block is used.  Next, the first 4 bytes of the footer contain a pointer to the previous block in the free list (if the element is free), and the last 4 bytes of the footer are the same as the last four of the header.

Then, the malloc simply scans the free list looking for the next block that can fit, if it can't find one it simply gets more memory and puts the block there.  Also, a number which is >= max free block size is kept, and if the requested size is over that amount, new memory is gotten immediately.

Coalescing is performed while a block is being freed, and checks for forward and backward coalescing.
*/

team_t team = {
    /* Team name to be displayed on webpage */
    "Heck ya, ADAM ANT!",
    /* First member full name */
    "Adam Wierman",
    /* First member email address */
    "acw",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* Global variables */
int PAGE_SIZE;
int *heap, *tail , *head, *currpos, *first, *last, *curr, *currforptr;
int heap_size, heap_bottom, max_block_size; 

int mm_init (void)
{
  PAGE_SIZE = mem_pagesize();
  heap = (int *)(mem_sbrk(PAGE_SIZE));

  if (heap) {         
    heap_bottom         = (int) dseg_lo +  ((int)(dseg_lo) % 8);
    heap_size           = (int) dseg_hi - heap_bottom + 1 ;

    heap[1]             = (heap_size-16) & (~0x7);  /* header of new block */
    heap[heap_size/4-1] = heap[1];                  /* footer of new block */

    heap[0]             = (int) NULL;    /* forward pointer */    
    heap[heap_size/4-2] = (int) NULL;    /* back pointer */

    tail    = &heap[1];   /* tail of the free list */
    head    = &heap[1];   /* head of the free list */
    currpos = &heap[1];   /* current position on the free list, used for next fit scheme */
    last    = &heap[1];   /* last block of the heap */
    first   = &heap[1];   /* first block of the heap, will never change */

    max_block_size = heap_size-16; /* max size of a free block */

    return 0;
  } else { 
    return -1;
  }
}

void *mm_malloc (size_t size)
{
  /* Note: use currpos as the prevblock, ie currpos is the block you stopped at last time */
  int *newheap, *nextfree, *block, *prevfree, *startpos;
  int currsize, nextsize, newsize, old_heap_size;
  int islastused, newheadpos, oldsize;

  int alsize            = (int)(size) + 8 - ((int)(size) % 8);  /* make the size requested a mult of 8 */
  int gottenbacktostart = 0;                /* have we passed the startnode again */
  int maxsize           = max_block_size;   /* maxsize is used to check max block size, if search goes through every block */

  if (currpos == NULL) { currpos = head; }  /* check and makesure the currpos is useful */

  /* more initialization */
  if (head != NULL) {
    maxsize    = 0;
    prevfree   = currpos;
    block      = (int *) prevfree[-1];
    if (block == NULL) { block = head; }
    startpos   = block;
  }

  while (!gottenbacktostart && head!=NULL && alsize <= max_block_size) {

    currsize  = block[0] & (~0x7);      /* size of block */
    if (currsize > maxsize) { maxsize = currsize; }
    nextfree  = (int *) block[-1];      /* this might be NULL */ 

    /*********************************************************************************/
    if (currsize < alsize) {       /* case1: block is too small */
      /* note: nothing changes in case of head=tail=currpos */
      prevfree = block;                /* move up the prev ptr */
      block    = nextfree;             /* move block to the next free block ... could be NULL */

    /**********************************************************************************/
    }else if (currsize <= alsize+24 ) { /* case2: block is exactly the right size ... */
                                        /*        or too small for another header */
      block[0]           |= 0x1;        /* set block as used */
      block[currsize/4+2] = block[0];   /* set bnd tag */

      /* pull block out of the free list */
      if (block == prevfree) {          /* head == tail */
        head    = NULL;
        tail    = NULL;
        currpos = NULL;
      } else {
        /* note: don't need to worry about block==last */
        if (block == head) { 
          nextsize               = nextfree[0] & (~0x7);
          head                   = nextfree; 
          currpos                = prevfree;
          nextfree[nextsize/4+1] = (int) NULL;
        } else if (block == tail) { 
          tail                   = prevfree; 
          currpos                = prevfree;
          prevfree[-1]           = (int) NULL;
        } else {
          nextsize               = nextfree[0] & (~0x7);
          currpos                = prevfree;
          prevfree[-1]           = block[-1];
          nextfree[nextsize/4+1] = block[currsize/4+1];
        }
      }

      block[-1]           = (int) NULL;
      block[currsize/4+1] = (int) NULL;

      return &block[1];              /* return free block */

    /*************************************************************************************/
    } else {                           /* case3: block is bigger than needed */
      newheadpos = alsize/4+4;

      /* ptrs of block being set as used do not need to be changed */
      block[0]            = alsize | 0x1;         /* set head of used block */
      block[newheadpos-2] = block[0];             /* set bnd tag of used block */

      /* update the list to exclude the block being set as used */
      if (block == prevfree) {   
        head    = NULL;
        tail    = NULL;
        currpos = NULL;
      } else {
        /* note: don't need to worry about block==last */
        if (block == tail) {
          tail                   = prevfree;
          currpos                = prevfree;
          prevfree[-1]           = (int) NULL;
        } else if (block == head) { 
          nextsize  = nextfree[0] & (~0x7);
          head                   = nextfree; 
          currpos                = prevfree;
          nextfree[nextsize/4+1] = (int) NULL;
        } else {
          nextsize  = nextfree[0] & (~0x7);
          currpos                = prevfree;
          prevfree[-1]           = block[-1];
          nextfree[nextsize/4+1] = block[currsize/4+1];
        }
      }

      block[-1]           = (int) NULL;
      block[newheadpos-3] = (int) NULL;

      block[newheadpos]   = currsize-alsize-16;   /* set new free block size */
      block[newheadpos-1] = (int) NULL;           /* set for ptr of new free block */

      block[newheadpos+block[newheadpos]/4+2] = block[newheadpos]; /* set bnd tag of new free block */
      block[newheadpos+block[newheadpos]/4+1] = (int) tail;        /* set back ptr of new free block */
                                                                   /* works if tail is NULL */
      if (&block[0] == last) { last = &block[newheadpos]; }
     
      if (head == NULL) {
        head = &block[newheadpos];
        tail = head;
        currpos = head;
      } else {
        tail[-1] = (int) &block[newheadpos];        /* put block at the end of the free list */
        tail     = &block[newheadpos];
      }

      return &block[1];                            /* return free block */
    } /**************************************************************************************/
  
    if (block == NULL)     { block = head; }
    if (block == startpos) { gottenbacktostart = 1; }

  } /* end while */

  /* if we saw all the blocks, update max_block_size */
  if (gottenbacktostart) { max_block_size = maxsize; }

  /* if we get here, there isn't enough room for the new block */
  old_heap_size = heap_size; 

  /* enough space for block and at least 32 bytes more */ 
  newsize       = ((alsize+16 + 16+16)/PAGE_SIZE+1) * PAGE_SIZE;   
  islastused    = last[0] & 0x1;

  /* get enough new memory for the heap */
  newheap   = (int *)(mem_sbrk(newsize));   
  heap_size = (int)(dseg_hi) - heap_bottom;  /* update size of heap */ 
  if (!newheap) { return NULL; }             /* if you couldn't get any more memory, return NULL */

  /* if the last block in the heap is used */
  if (islastused) { 
    newheap               = &newheap[1];
    newheadpos            = alsize/4+4;    

    /* no need to set ptrs of used block */
    newheap[-1]           = (int) NULL;
    newheap[newheadpos-3] = (int) NULL;
    newheap[0]            = alsize | 0x1;                  /* new block size header set */
    newheap[newheadpos-2] = newheap[0];                    /* set bnd tag of used block */

    /* don't have to pull block out of list ... it was never in it */

    newheap[newheadpos]   = (newsize-alsize-32) & (~0x7);  /* set header of left over space */
    newheap[newheadpos-1] = (int) NULL;                    /* set for ptr of left over space */

    if (newheap[newheadpos]>max_block_size) { max_block_size = newheap[newheadpos]; }

    newheap[newheadpos+newheap[newheadpos]/4+2] = newheap[newheadpos]; /* set bnd tag of new free block */
    newheap[newheadpos+newheap[newheadpos]/4+1] = (int) tail;          /* set back ptr of new free block */
                                                                       /* if tail is NULL this still works */
    last = &newheap[newheadpos];  /* update last */

    /* add new free block to the list */
    if (head  == NULL) {
      head     = last;
      tail     = last;
      currpos  = last;
    } else {
      tail[-1] = (int) last;     /* update ptr in old tail */
      tail     = last;           /* update tail itself */
      currpos  = last;
    }   

    return &newheap[1];

  } else {                       /* the last block in the heap is free */
    /* pull the last block out of the free list */
    block    = last;
    oldsize  = block[0];

    /* these ptrs could be NULL */
    prevfree = (int *)last[oldsize/4 + 1];
    nextfree = (int *)last[-1];  

    /* update the list to exclude the block being set as used */
    if (head == tail) {
      head    = NULL;
      tail    = NULL;
      currpos = NULL;
    } else {
      /* note: don't need to worry about block==last */
      if (block == tail) {
        tail                   = prevfree;
        currpos                = prevfree;
        prevfree[-1]           = (int) NULL;
      } else if (block == head) { 
        nextsize  = nextfree[0] & (~0x7);
        head                   = nextfree; 
        currpos                = prevfree;
        nextfree[nextsize/4+1] = (int) NULL;
      } else {
        nextsize  = nextfree[0] & (~0x7);
        currpos                = prevfree;
        prevfree[-1]           = (int) nextfree;
        nextfree[nextsize/4+1] = (int) prevfree;
      }
    }

    /* block is out of free list, set allocated header, footer */
    newheadpos          = alsize/4 + 4; 
    block[0]            = alsize | 0x1;   /* header of used block */
    block[newheadpos-2] = block[0];       /* footer of used block */
    block[-1]           = (int) NULL;     /* for ptr of used block */
    block[newheadpos-3] = (int) NULL;     /* back ptr of used block */

    /* set header and footer of new free block */
    block               = &block[newheadpos];
    currsize            = newsize+oldsize+8 - alsize - 24;
    block[0]            = currsize;       /* header of free block */
    block[currsize/4+2] = currsize;       /* footer of free block */

    /* set ptrs of new free block */
    block[-1]           = (int) NULL;     /* for  ptr */
    block[currsize/4+1] = (int) tail;     /* back ptr */

    /* update last */
    last = block;

    /* put block at the tail of the free list */
    if (head  == NULL) {
      head     = last;
      tail     = last;
      currpos  = last;
    } else {
      tail[-1] = (int) last;     /* update ptr in old tail */
      tail     = last;           /* update tail itself */
      currpos  = last;
    }   

    /* update max_block_size if necessary */
    if (currsize > max_block_size) { max_block_size = currsize; }

    return &block[1-newheadpos];
  }
} /* end of mm_malloc */





void mm_free (void *ptr)
{
  int  nextsize, prevsize, prev;
  int *nextforptr, *nextbackptr, *prevbackptr, *prevforptr;

  int  cleanuplist = 1;
  int  islast      = 0;
  int  isfirst     = 0;
  int *block       = ptr-4;
  int  currsize    = block[0] & (~0x7); 
  int  next        = currsize/4 + 4;                
  int  isnextused  = block[next] & 0x1; 
  int  isprevused  = block[-2] & 0x1;

  if (&block[0]   ==  last)  { islast  = 1; }
  if (&block[0]   ==  first) { isfirst = 1; }

  /* forward coalescing */
  if (!isnextused && !islast) {     
    nextsize            = block[next] & (~0x7);              
    block[0]            = currsize + nextsize + 16;     
    currsize            = block[0] & (~0x7);           
    block[currsize/4+2] = block[0];                    

    /* update pointers to &block[next] so that they point to block, and then update blocks ptrs */
    nextforptr  = (int *) block[next - 1];   
    nextbackptr = (int *) block[currsize/4+1];    

    if (&block[next] == last)    { last    = block; }   
    if (&block[next] == currpos) { currpos = block; }   

    if (head == tail) {   
      head                = block;
      tail                = block;
      currpos             = block;
      block[-1]           = (int) NULL;
      block[currsize/4+1] = (int) NULL;
    } else {
      if (&block[next] == tail) {
        tail                     = block;
        currpos                  = block;
        nextbackptr[-1]          = (int) block;
        block[-1]                = (int) NULL;
        block[currsize/4+1]      = (int) nextbackptr;
      } else if (&block[next] == head) { 
        nextsize  = nextforptr[0] & (~0x7);
        head                     = block; 
        currpos                  = block;
        nextforptr[nextsize/4+1] = (int) block;
        block[-1]                = (int) nextforptr;
        block[currsize/4+1]      = (int) nextbackptr;
      } else {
        nextsize  = nextforptr[0] & (~0x7);
        currpos                  = block;
        nextbackptr[-1]          = (int) block;
        nextforptr[nextsize/4+1] = (int) block;
        block[-1]                = (int) nextforptr;
        block[currsize/4+1]      = (int) nextbackptr;
      }
    }

    /* update changed variables if necessary */
    next        = currsize/4+4;    
    isnextused  = block[next] & 0x1;  
    cleanuplist = 0;  
    if (currsize > max_block_size) { max_block_size = currsize; }
  }  /* end of forward coalescing */

  /* backward coalescing */
  if (!isprevused && !isfirst) {   
    prevsize            = block[-2] & (~0x7);  
    prev                = prevsize/4 + 4;         
    block               = &block[-prev];                
    currsize            = currsize + prevsize + 16;  
     
    /* if we have already done coalescing, pull 2nd block out of the list */
    if (!cleanuplist) {
      prevforptr  = (int *) block[prev - 1];   
      prevbackptr = (int *) block[currsize/4 + 1];   

      if (head == tail) {
      } else if (&block[prev] == head)    {  
        head = prevforptr;
        head[(head[0]&(~0x7))/4+1] = (int) NULL; 
      } else if (&block[prev] == tail)    {
        tail = prevbackptr;
        tail[-1] = (int) NULL;
      } else {  
        prevbackptr[-1] = (int) prevforptr; 
        prevforptr[(prevforptr[0]&(~0x7))/4 + 1] = (int) prevbackptr; 
      }   
    } 

    /* update combined blocks size and ptrs */    
    block[0]            = currsize;                     
    block[currsize/4+2] = block[0];   

    if (&block[prev] == last)    { last    = block; }    
    if (&block[prev] == currpos) { currpos = block; } 
                                                      
    block[currsize/4+1] = block[prev-3];  

    /* update max_block_size if necessary */
    if (currsize > max_block_size) { max_block_size = currsize; }
    cleanuplist         = 0; 
  }  

  /* if there is no coalescing to do... */
  if (cleanuplist) {
    /* note: isprevused and size are already set for the block  */
    block[0]       &= (~0x1);                  /* set the block free */
    block[next-2]   = block[0];                /* set the bnd tag    */
    block[-1]       = (int) NULL;              /* set for ptr for block  */

    /* update max_block_size if necessary */
    if (block[0]>max_block_size) { max_block_size = block[0]; }

    /* add block to the tail of the list */
    if (head == NULL) {     
      tail          = &block[0];          
      head          = &block[0];  
      currpos       = &block[0]; 
      block[next-3] = (int) NULL; 
    } else {                
      tail[-1]      = (int) &block[0];     
      block[next-3] = (int) tail;          
      tail          = &block[0];          
      currpos       = tail;               
    }
  }
} /* end of mm_free */




