/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "greeberx",
    /* First member full name */
    "Attila Bergou",
    /* First member email address */
    "abergou",
    /* Second member full name (leave blank if none) */
    "Robert Rost",
    /* Second member email address (blank if none) */
    "rrost"
};
/*********************************************************/
#define INT_SIZE     sizeof(int)
#define POINTER_SIZE sizeof(int *)
#define ALIGNMENT    8
#define NORM(x)      (x&(~3))
/*********************************************************/
int align_num(int num)
{
  int k = num%ALIGNMENT;

  if(k<=INT_SIZE)
    return num-k+INT_SIZE;

  return num-k+INT_SIZE+ALIGNMENT;
}
/*********************************************************/
void *align_ptr(void *ptr)
{
  long k = ((long)ptr)%ALIGNMENT;

  if (k <= INT_SIZE)
    return (void *)((long)ptr-k+INT_SIZE);

  return (void *)((long)ptr-k+INT_SIZE)+ALIGNMENT;
}
/*********************************************************/
void mark_free(int *ptr)
{
  int size;

  size = *ptr = *ptr|1;
  ptr = (int *)((char *)ptr+NORM(size));
  *ptr = size; ptr++;
  *ptr = *ptr|2;

  return;
}
/*********************************************************/
void mark_used(int *ptr)
{
  int size;

  size = *ptr = *ptr&(~1);
  ptr++; ptr = (int *)((char *)ptr+NORM(size));
  *ptr = *ptr&(~2);

  return;
}
/*********************************************************/
int cal_index (int x)
{
  int answer, temp;

  if(x>=65536)
    return 23;
  if(x<=16)
    return 0;
  if(x<128)
    return (x>>3)-2;

  /*take the logarithm of a number < 16 bits*/
  answer= temp = (!!(x>>8))<<3;
  x = x>>temp;
  temp = (!!(x>>4))<<2;
  answer+=temp;
  x=x>>temp;
  temp = (!!(x>>2))<<1;
  answer+=temp;
  x=x>>temp;
  temp = !!(x>>1);
  answer+=temp+(!!(x)>>1);
  
  return answer+7;
}
/*********************************************************/
void insert (int *ptr)
{
  int **array, **next, **prev, index, size;

  size = NORM(*ptr);
  mark_free(ptr);
  array = (int **)dseg_lo;
  index = cal_index(size);
  next = (int **)(ptr+1);

  if(array[index]){
    prev = (int **)((int **)(array[index]+1)+1);
    *prev = ptr;
  }
  
  prev = (int **)(next+1);
  *prev = NULL;
  *next = array[index];
  array[index] = ptr;

  return;
}
/*********************************************************/
void remove_link (int *ptr)
{
  int *prev, *next, **prev_next, **next_prev, index, **array;

  next = *((int **)(ptr+1));
  prev = *((int **)(ptr+2));

  if(prev){
    prev_next = (int **)(prev+1);
    *prev_next = next;
  }
  else{
    array = (int **)dseg_lo;
    index = cal_index(NORM(*ptr));
    array[index] = next;
  }
  if(next){
    next_prev = (int**)((int **)(next+1)+1);
    *next_prev = prev;
  }

  return;
}
/*********************************************************/
void split (int *ptr, int size)
{
  int *ptr_temp, calc_size;
  
  calc_size = NORM(*ptr);
  
  if(calc_size - size > 2*POINTER_SIZE+2*INT_SIZE){
    *ptr = size|(*ptr&2);
    ptr_temp = ptr;
    ptr++;
    ptr = (int *)(((char *)ptr)+size);
    *ptr = calc_size-size-INT_SIZE;
    insert(ptr);
    mark_used(ptr_temp);
  }
  else mark_used(ptr);

  return;
}
/*********************************************************/
void *coalesc_up(int *ptr)
{
  int *next, size, next_size;
  char *tracker;

  size = NORM(*ptr);
  tracker = (char *)(ptr+1)+size;
  
  next = (int *)tracker;
  next_size = *next;
  
  if(next_size&1){
    next_size = NORM(next_size);
    tracker = tracker+next_size;
    remove_link(next);
    *ptr = size = size+next_size;
    *((int *)tracker) = size;
  }

  return ptr;
}
/*********************************************************/
void *coalesc_down(int *ptr)
{
  int *prev, size, prev_size, prev_free;
  char *tracker;

  size = *ptr;
  prev_free = size&2;
  size = NORM(size);
  
  if(prev_free){
    tracker = (char *)(ptr-1);
    prev_size = NORM(*((int *)tracker));
    tracker = tracker-prev_size;
    prev = (int *)tracker;
    remove_link(prev);
    ptr = (int *)tracker;
    *ptr=size=size+prev_size;
    tracker=tracker+size;
    *((int *)tracker)=size;
  }

  return ptr;
}
/*********************************************************/
void *coalesc(int *ptr)
{
  int size;
  size = NORM(*ptr);

  if(((char *)ptr+size)<(dseg_hi-INT_SIZE*2))
    ptr = coalesc_up(ptr);
  if(((char *)ptr)>(dseg_lo+POINTER_SIZE*24+INT_SIZE))
    ptr = coalesc_down(ptr);

  return ptr;
}
/*********************************************************/
int mm_init (void)
{
  int **ptr, *remain, req, i;
  
  req = mem_pagesize();
  ptr = mem_sbrk(req);
  
  for(i=0; i<24; i++){
    *ptr = NULL;
    ptr++;
  }
  
  remain = (int *)((dseg_hi+1)-INT_SIZE);
  *remain = 0;
  
  ptr = align_ptr(ptr);
  remain = (int *)ptr;
  *remain = dseg_hi-(char *)ptr+1-INT_SIZE*2;

  insert(remain);

  return 0;
}
/*********************************************************/
void *mm_malloc (size_t size)
{
  int **array = (int **)dseg_lo, index, *ptr, req;
  void *answer;

  if(size<20) size = 20;
  else size=align_num(size);
  
  index=cal_index(size);

  while(index<24){
    ptr=array[index];
    while(ptr){
      if((*ptr)>size){
	remove_link(ptr);
	split(ptr, size);
	answer=ptr+1;
	return answer;
      }
      else ptr=*((int **)(ptr+1));
    }
    index++;
  }

  /* This means that whatever memory we had was not enough
     and that we have to request a new block */
  req = mem_pagesize();
  req = req*((size+INT_SIZE)/req+1);

  ptr = mem_sbrk(req);

  if(!ptr) return NULL; /*Out of memory*/

  ptr--; *ptr=(dseg_hi-(char*)(ptr+1)+1-INT_SIZE)|(*ptr&2);
  /*ptr = coalesc(ptr);*/
  split(ptr, size);

  answer=ptr+1; /*return the right thing*/
  return answer;
}
/*********************************************************/
void mm_free (void *ptr)
{
  int *ptr_calc = (int *)ptr-1; /* access size*/
  *ptr_calc = *ptr_calc; /*right size*/
  /*ptr_calc = coalesc(ptr_calc);*/
  insert(ptr_calc);
}
/*********************************************************/
