#!/usr/local/bin/perl5 -w
#!/usr/bin/perl

# Kip Walker <kwalker@cs.cmu.edu> / Spring 1998
# Spiros Papadimitirou <spapadim@cs.cmu.edu> / Fall 1999
# CS213 - Lab assignment 3

use FileHandle;

# NOTES:
# programs should flush() output often if they want to produce useful
# output if they've been killed for running too long.

# here are some things that might have to be modified
#$rootdir="/home/spapadim/CS213/L3/web";
$rootdir="/afs/cs/academic/class/15213-s99/private/L3/web";

$submitdir = "$rootdir/submit";
$builddir = "$rootdir/build";

$maxtime = 150;
$domain = "ece.cmu.edu";
#$pagsh = "/usr/andy/bin/pagsh";
$progname = "$builddir/malloc";

$host = `hostname`; chop $host;
$logdir = "$rootdir/log";
$logfile = "$logdir/ourlog.$host";
$weblog = "$logdir/weblog.$host";

$webpage = "$rootdir/html/mallocstat.html";

sub build_meth {
    my $ofile = shift;
    return "./dobuild $submitdir $builddir $ofile";
}

format compileerror =
Hi,

We tried compiling your malloc and found that 
it generated some errors.  Sorry!

Here's the output (first 250 lines):
@*
$output
--end of output--

Have a good day!
.

format timeerror =
Hi,

We've run our malloc tester for:
@##.### seconds
$time
and it wasn't finished, so we killed it.  Sorry!

The output of the program (up to then) follows:
@*
$output
--end of output--

Have a good day!
.

format timegood =
Hi,

We've finished running your malloc, and we'll be updating
the web page shortly.  The program exited with code
(0 is normal):
@*
$retval

The output of the program test run follows:
@*
$output
--end of output--

Have a good day!
.

# probably don't have to modify stuff below here
# but of course your mileage may vary

sub mail_cmd {
    my $subj = shift;
    my $ret;

    # put $domain on it, unless we already know
    if ((index $name, "@") == -1) {
        $ret = "| mailx -s \"$subj\" $name\@$domain";
    } else {
        $ret = "| mailx -s \"$subj\" $name";
    }
    return $ret;
}

sub do_build {
    my $file = shift;
    my $buildcmd = build_meth($file);
    my $pid;

    print "Compiling $file...";
    if (!($pid = fork)) {
        # i'm the child and should do the compile
        
        open(STDOUT, ">$builddir/$file.compile")
            || die "can't redirect stdout";
        open(STDERR, ">&STDOUT")
            || die "can't redirect stdout";

        exec $buildcmd;
    }
    waitpid $pid, 0;
    print "done\n";
    if ($? != 0) {
        print "error in compilation\n";

        $output = `cat $builddir/$file.compile`;
        open MAIL, mail_cmd("Compilation problem with $file\n");
        MAIL->format_name("compileerror");
        write MAIL;
        close MAIL;

        unlink "$builddir/$file"; 
        unlink "$builddir/$file.compile";

        return 1;
    }

    unlink "$builddir/$file.compile";
    return 0;
}

sub afs_lookup {
    my $uid = shift;
    my $foo = `pts examine $uid -noauth`;
    $foo =~ /Name: (.*), id:/;
    return $1;
}

sub update_web {
    my $ofile = shift;
    my $correct = "no";
    my $avg_time = 1000.0;
    my $avg_throughput = 0.0;
    my $avg_util = 0.0;
    my $perf_index = 0.0;
    my $teamname = "NO_TEAMNAME";
    my $email1 = $name;
    my $email2= $name;

    open(STATUS, $ofile);
    while (<STATUS>) {
        if (/Teamname: (.*)/) {
            $teamname = $1;     # random word
        }
        if (/Email 1: (.*)/) {
            $email1 = $1;        # email address
            $name = $email1;
        }
        if (/Email 2: (.*)/) {
            $email2 = $1;        # email address
            $name = $name." ".$email2;
        }
        if (/All correctness tests passed/) {
            $correct = "yes";      # "yes" or "no"
        }
        if (/Average overall utilization: (.*)/) {
            $avg_util = $1;
        }
        if (/Average time: (.*) sec/) {
            $avg_time = $1;
        }
        if (/Average throughput: (.*) ops\/sec/) {
            $avg_throughput = $1;
        }
        if (/Performance index: (.*)/) {
            $perf_index = $1;
        }
    }
    close STATUS;

    my $time = time;
    
    if ($teamname ne "NO_CODENAME") {
        open(LOG, ">>$logfile");
        print LOG "$time $teamname $email1 $email2 $correct $avg_time $avg_throughput $avg_util $perf_index\n";
        close(LOG);
        open(WEB, ">>$weblog");
        printf WEB "<tr> <td bgcolor=#eeeeee> %30.30s </td> ", $teamname;
        print  WEB "<td bgcolor=#eeeeee> $correct </td> ";
        print  WEB "<td bgcolor=#eeeeee> $avg_throughput </td> ";
        print  WEB "<td bgcolor=#eeeeee> $avg_util </td> ";
        print  WEB "<td bgcolor=#eeeeee> $perf_index </td> </tr>\n";
        close(WEB);
        system("cat www-header > $webpage.$host.NEW");
        system("sort -k 4 $logdir/weblog.* | uniq -3 -w30 | sort -k 20n -k 4 >> $webpage.$host.NEW");
#       system("cat $weblog >> $webpage.$host.NEW");
        system("cat www-footer >> $webpage.$host.NEW");
        system("mv $webpage.$host.NEW $webpage");
    } else {
        print "Not updating webpage.\n";
    }
}

# start of main program

$| = 1;

opendir SUBMIT, $submitdir;

for (;;) {
    rewinddir SUBMIT;

    while (defined($file = readdir SUBMIT)) {
        # for each file in the directory
        if (($file eq ".") || ($file eq "..")) { next; }

        print "Found $file...\n";

        $uid = (stat "$submitdir/$file")[4];
        $name = afs_lookup($uid);
        print "found name = $name\n";

#       system "mv -f $submitdir/$file $builddir/$file";
#       if ($?) {
#           print "Snatched away from me!\n";
#           next;
#       }

        # build $file in $builddir
        if (do_build($file)) {
            next;
        }

        print "Running $file...";
        alarm $maxtime;
        $killed = 0;
        @start = times;
        if (!($pid = fork)) {
            # i'm the child; i should execute the process

            open(STDOUT, ">$builddir/$file.output") 
                || die "can't redirect stdout";
            open(STDERR, ">&STDOUT") 
                || die "can't redirect stderr to stdout";
            exec "$progname";
        }
        $SIG{ALRM} = sub { kill 9, $pid; $killed = 1; };
        waitpid $pid, 0;
        $retval = $?;
        alarm 0;
        @end = times;
        print "done\n";

        $time = $end[3] - $start[3] + $end[2] - $start[2];
        if ($killed) { 
            print "KILLED "; 
            $time = $maxtime;
            wait;
        }
        print "$file took $time seconds\n";

        $output = `head -250 $builddir/$file.output`;
        open MAIL, mail_cmd("Timing information for $file");
        if ($killed) {
            MAIL->format_name("timeerror");
        } else {
            MAIL->format_name("timegood");
        }
        write(MAIL);
        close MAIL;

        update_web("$builddir/$file.output");

        unlink "$builddir/$file.output";
        unlink "$builddir/$file";
        unlink "$logdir/$weblog";
    }

    sleep 10;                    # wait 30 seconds between checks
}

closedir SUBMIT;
