/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

/* NOTE:  This is a slightly modified implementation of a memory
 *   manager I had implemented and (somewhat) tested some time ago;
 *   the code is strange because it was supposed to be assembly-like
 *   C, but it should work for testing the rest of the code... - Spiros
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "varda",
    /* First member full name */
    "Spiros Papadimitriou",
    /* First member email address */
    "spapadim+@cs.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


#define IS_ALIGNED(p)  ((((ulong)(p))%8) == 0)
#define ALIGN_UP(p)  (((ulong)(p) + 0x7L) & ~0x7L)
#define ALIGN_DN(p)  (((ulong)(p)) & ~0x7L)

#define ULONGP(p,off)   ((ulong *)((ulong)(p) + 8L*(off)))

#define HEAP_END    ULONGP(dseg_lo,0)
#define HEAP_START  ULONGP(dseg_lo,1)
#define FREE_PTR    ULONGP(dseg_lo,2)

#define HEAP_INIT_SIZE   3*8

int mm_init (void)
{
    if (mem_sbrk(HEAP_INIT_SIZE) == NULL)
        return 0;

    *FREE_PTR   = 0;
    *HEAP_START = *HEAP_END = (ulong)ULONGP(dseg_lo,3);

    return 1;
}

void *mm_malloc (size_t size)
{
        ulong p, prevp;
        ulong retval;

        size = size / 8;
        
        p = *FREE_PTR;
        prevp = (ulong)FREE_PTR;
        
whiledo:
        if (p == 0) goto expand_heap;
        if (*ULONGP(p,1) >= size) goto reuse_block;
        prevp = p;
        p     = *ULONGP(p,0);
        goto whiledo;

expand_heap:
        retval = *HEAP_END + 8;
        *HEAP_END = retval + 8*size + 8;
        if (mem_sbrk(8*size + 16) == NULL) {
            return NULL;
        }
        *ULONGP(*HEAP_END,-(size+1)) = size;
        goto end;
        
reuse_block:
        if (*ULONGP(p,1) > size + 1) {  /* Free-list block has at least 2 words */
            *ULONGP(p,size)   = *ULONGP(p,1) - size - 1;
            *ULONGP(prevp,0)  = p + 8*size + 8;
            *ULONGP(p,size+1) = *ULONGP(p,0);
        } else {
            *ULONGP(prevp,0) = *ULONGP(p,0);
        }
        retval = p;

end:
        return (void *)retval;
}

void mm_free (void *addr)
{
        ulong p, prevp;
        ulong ptr = (ulong)addr;

        p = *FREE_PTR;
        prevp = (ulong)FREE_PTR;

whiledo:
        if (p == 0) goto append_node;
        if (p + *ULONGP(p,-1) == ptr - 1) goto merge_left;
        if (ptr + *ULONGP(ptr,-1) == p - 1) goto merge_right;
        prevp = p;
        p = *ULONGP(p,0);
        goto whiledo;

append_node:             /* no free-list block adjacent to freed block */
        *ULONGP(ptr,0) = *FREE_PTR;
        *FREE_PTR = ptr;
        goto end;

merge_left:              /* free-list block to the left of freed block */
        *ULONGP(p,-1) = *ULONGP(p,-1) + *ULONGP(ptr,-1) + 1;
        goto end;

merge_right:             /* free-list block to the right of freed block */
        *ULONGP(ptr,-1)  = *ULONGP(ptr,-1) + *ULONGP(p,-1) + 1;
        *ULONGP(prevp,0) = ptr;

end:
}

