/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "android - tweaking",
    /* First member full name */
    "ross cohen",
    /* First member email address */
    "rcohen",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* so here's how it works:
 * there are 2 free lists, with ptrs to their heads at dseg_lo and
 * dseg_lo + sizeof(long). one list is for coalesced free blocks, the
 * other is for non-coalesced blocks.
 * free always just dumps blocks onto the uncoalesced list.
 * malloc searches the un-coed, coed lists, in that order, then
 * starts merging the un-coed list into the coed list. if that fails
 * to get a large enough block, then it resorts to sbrk.
 * used blocks have nothing pointing to them. if you call free on
 * something that is not allocated, you will lose badly. used blocks
 * have a header that consists of a single long, which is the size
 * of the allocated area.
 * free blocks have the linked list which keeps track of them stored
 * in the unused space. the struct is aligned at the lowest addess
 * of the region.
 * this method works pretty effeciently for both time and memory usage
 * for real workloads. it truly sucks at the binary synthetic trace,
 * and only does so-so for the random case. the coalescing trace would
 * be amazing, except that it's not being graded properly, so other
 * people are getting false results of close to 100% utilization. i
 * refuse to put effort into modifying it just so it looks like it's
 * doing better under the lame grading scheme.
 */

typedef struct list_struct {
  long size;
  struct list_struct *next, *prev;
} list_t, *list_ptr;

int mm_init (void)
{
  list_t *list;

  mem_sbrk(mem_pagesize());

  /* init freelist ptr */
  list = (list_t *)(dseg_lo+(sizeof(long)<<1));
  *(list_t **)dseg_lo = list;
  list->next = list->prev = list;
  list->size = mem_pagesize() - (sizeof(void *)<<1) - sizeof(long);

  /* init other list ptr */
  *(list_t **)(dseg_lo+sizeof(long)) = NULL;

  return 0;
}

inline void mm_remove_free(char *addr, list_t *list) {
  if (list == list->next) {
    *(list_t **)addr = NULL;
    return;
  }

  if (*(list_t **)addr == list) {
    *(list_t **)addr = list->next;
    if (!list->next->size)
      assert(0);
  }
  list->next->prev = list->prev;
  list->prev->next = list->next;
}

inline void mm_add_free(char *addr, list_t *list) {
  list_t *freelist;

  freelist = *(list_t **)addr;

  if (freelist == NULL) {
    list->next = list->prev = list;
    *(list_t **)addr = list;
    return;
  }
  list->next = freelist;
  list->prev = freelist->prev;
  freelist->prev->next = list;
  freelist->prev = list;

  /* make this the first thing on the list */
  *(list_t **)addr = list;
}

inline list_t *mm_coalesce(list_t *bud) {
  list_t *list;
  int notdone = 2;

  list = *(list_t **)dseg_lo;
  assert (list != NULL);
  do {
    if ((void *)list == ((void *)bud) + bud->size + sizeof(long)) {
      mm_remove_free(dseg_lo, list);
      bud->size += list->size + sizeof(long);
      list = bud;
      notdone--;
    } else if (((void *)list) + list->size + sizeof(long) == (void *)bud) {
      mm_remove_free(dseg_lo, bud);
      list->size += bud->size + sizeof(long);
      bud = list;
      notdone--;
    }
    list = list->next;
  } while (notdone && list != *(list_t **)dseg_lo);
  return bud;
}

void *mm_malloc (size_t size)
{
  list_t *list, *newlist;
  char *test, *addr;
  long foo, mask;

  /* round up size to a power of 8 */
  size = ((size>>3) + !!(size & 7)) << 3;

  if (size < sizeof(list_t)-sizeof(long)) {
    size = sizeof(list_t)-sizeof(long);
  }

  addr = dseg_lo+sizeof(long);
  list = *(list_t **)addr;
  if (list != NULL) {
    do {
      if (list->size >= size) {
	break;
      }
      list = list->next;
      if (list == *(list_t **)addr) {
	list = NULL;
      }
    } while (list);
  }
  if (list == NULL) {
    addr = dseg_lo;
    list = *(list_t **)addr;
    if (list != NULL) {
      do {
	if (list->size >= size) {
	  break;
	}
	list = list->next;
	if (list == *(list_t **)addr) {
	  list = NULL;
	}
      } while (list);
    }
  }
  if (list == NULL) {
    addr = dseg_lo + sizeof(long);
    while ((list = *(list_t **)addr)) {
      mm_remove_free(addr, list);
      mm_add_free(dseg_lo, list);
      list = mm_coalesce(list);
      if (list->size >= size) {
	break;
      }
    }
    addr = dseg_lo;
  }
  /* if we couldn't find a fit then try sbrk */
  if (list == NULL) {
    mask = mem_pagesize()-1;
    size += sizeof(long);
    foo = (size & ~mask) + ((!!(size & mask))*mem_pagesize());
    size -= sizeof(long);
    list = (list_t *)(dseg_hi+1);
    test = mem_sbrk(foo);
    if (!test) return NULL;
    list->size = foo - sizeof(long);
    mm_add_free(dseg_lo, list);
    list = mm_coalesce(list);
  }

  /* found a fit */
  if (list->size < size + sizeof(list_t)) {
    /* give 'em the whole chunk */
    mm_remove_free(addr, list);
    return (((void *)list) + sizeof(long));
  }
  /* give them the beginning of the block */
  newlist = (list_t *)(((void *)list) + size + sizeof(long));
  newlist->size = list->size - size - sizeof(long);
  list->size = size;

  if (list->next == list) {
    newlist->next = newlist->prev = newlist;
  } else {
    newlist->prev = list->prev;
    newlist->next = list->next;
    newlist->prev->next = newlist->next->prev = newlist;
  }
  if (*(list_t **)addr == list) {
    *(list_t **)addr = newlist;
  }

  return ((void *)list + sizeof(long));
}

void mm_free (void *ptr)
{
  list_t *bud;

  bud = (list_t *)(ptr - sizeof(long));
  mm_add_free(dseg_lo+sizeof(long), bud);
}
