/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Lurch",
    /* First member full name */
    "Mike Ferdman",
    /* First member email address */
    "mferdman",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

#define PAGE_SIZE 4096

struct header
{
	struct header *next;
	long size;
};

int mm_init (void)
{
	struct header *head=(struct header*)dseg_lo;
	mem_sbrk(PAGE_SIZE);
	head->size=0;
	head->next=++head;
	head->next=NULL;
	head->size=PAGE_SIZE-sizeof(struct header);
	return -1;
}

void *mm_malloc (size_t size)
{
	struct header *tmp,*prev,*pprev;
	size=((size+3+sizeof(struct header))/4)*4;
	pprev=prev=tmp=(struct header*)dseg_lo;
	while (tmp && tmp->size<size) { pprev=prev; prev=tmp; tmp=tmp->next; }
	if (!tmp)
	{
		/* I realize that mem_sbrk() allocates in chunks of PAGE_SIZE, however
		   the test driver uses mem_usage() and essentially dseg_hi to
		   determine space usage - which means the performance index is
		   greatly benefited by always calling mem_sbrk() with the minimum
		   amount of memeory necessary */
		//long pages=(size+(PAGE_SIZE-1)-prev->size)/PAGE_SIZE;
		if ((tmp=mem_sbrk(size))==NULL) return NULL;
		if ((char*)prev+prev->size==(char*)tmp)
		{
			/* Last free block is immediately before the new page */
			prev->size+=size;
			tmp=prev;
			prev=pprev;
		} else {
			tmp->size=size;
			return tmp+1;
		}
	}
	if (tmp->size>size+sizeof(struct header))
	{
		/* Block is larger than requested size, so it needs to be split */
		prev->next=(struct header*)((char*)tmp+size);
		prev->next->size=tmp->size-size;
		prev->next->next=tmp->next;
		tmp->size=size;
	} else {
		/* Block is a perfect fit, just take it out of the free list */
		prev->next=tmp->next;
	}
	return tmp+1;
}

void mm_free (void *ptr)
{
	struct header *tmp,*nptr,*prev;
	nptr=(struct header*)ptr-1;
	prev=tmp=(struct header*)dseg_lo;
	while (tmp>nptr || (tmp && (void*)(tmp->next)<ptr)) { prev=tmp; tmp=tmp->next; }
	if (!tmp)
	{
		/* Block being freed is after last free block, just needs to be chained on */
		nptr->next=prev->next;
		prev->next=nptr;
	} else {
		/* Block is between tmp and tmp->next */
		if ((char*)nptr+nptr->size==(char*)tmp->next)
		{
			/* Link with following block */
			nptr->size+=tmp->next->size;
			nptr->next=tmp->next->next;
		} else {
			/* Link to next block */
			nptr->next=tmp->next;
		}
		if ((char*)tmp+tmp->size==(char*)nptr)
		{
			/* Link with previous block */
			tmp->size+=nptr->size;
			tmp->next=nptr->next;
		} else {
			/* Connect block being freed into chain */
			tmp->next=nptr;
		}
	}
}
