/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Bunnicula",
    /* First member full name */
    "Mark Firth",
    /* First member email address */
    "mfirth",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* internal functions */
void mm_remove(void* ptr);

int mm_init (void)
{
  /* need to check if heap size is okay. */
  if((mem_usage() == -1 || (mem_usage()+1) %mem_pagesize() != 0))
    mem_sbrk(2*(mem_pagesize() -( (mem_usage()+1) %mem_pagesize() )));

  /* set up the first (and allocated) element of the dll */
  *(long*)dseg_lo = 1;
  *((long**)dseg_lo +1) = NULL;
  *((long*)dseg_lo +2) = (long)dseg_lo +64;
  *((long*)dseg_lo +3) = 1;
  /* set up the last (and allocated) element of the dll */
  *((long*)dseg_lo +4) = 1;
  *((long*)dseg_lo +5) = (long)dseg_lo +64;
  *((long**)dseg_lo +6) = NULL;
  *((long*)dseg_lo +7) = 1;

  /* set up the unallocated element of the dll */
  *((long*)dseg_lo +8) = mem_usage() -79;
  *((long*)dseg_lo +9) = (long)dseg_lo;
  *((long*)dseg_lo +10) = (long)dseg_lo +32;
  *((long*)dseg_lo + (mem_usage()+1)/8 -1) = mem_usage() -79;
  return -1;
}

void *mm_malloc (size_t size)
{
  long int Nsize;
  long* newMem;
  long* ptr = *((long**)dseg_lo +2);
  long* best;
  /* confoming the size to requirements */
  /* ERROR */
  if(size <= 0) {fprintf(stderr, "Emall\n"); return NULL;}
  if(size < 16) size = 16; 
  if(size%16 != 0) size += 16 - size%16;
/*******/


  while(*ptr < size && *ptr != 1)
  {
    ptr = *((long**)ptr +2);
  }
  best = ptr;
  while(*ptr != 1)
  {
    if(*ptr < *best) best = ptr;
    do
    {
      ptr = *((long**)ptr +2);
    }
    while(*ptr < size && *ptr != 1);
  }

  ptr = best;
  /* ^-- this while loop will be modified to do "best fit" */
  /* if we have not run out of memory */
  if(*ptr != 1)
  {
    /* if there is < 32 left, then allocate all. */
    if(*ptr <= (size +32))
    {
      mm_remove(ptr);
      *(ptr + (*ptr)/8 + 1) += 1;
      *ptr += 1;
      return ptr +1;
    }
    else
    {
      Nsize = *ptr -size -16;
      *(ptr + *ptr/8 +1) = size +1;
      *(ptr +Nsize/8 +2) = size +1;
      *(ptr +Nsize/8 +1) = Nsize;
      *ptr = Nsize;
      return ptr +Nsize/8 +3;
    }
  }
  /* if we have run out of memory */
  else
  {
      Nsize = 2*size + 16;
      newMem = mem_sbrk(Nsize +16);
    if(newMem != NULL)
    {
      /* mark as allocated, then free it ;) */
      *newMem = Nsize +1;
      *((long*)((char*)dseg_hi+1) -1) = Nsize +1;
      mm_free(newMem +1);
      return mm_malloc(size);
    }
    else { fprintf(stderr, "E-OOM"); return NULL; }
  }
}

void mm_free (void *ptr)
{
  long* B;
  long* F;
  long* Bs_F;
  long* Fs_B;
  long* temp = (long*)ptr -1;
  long int size = *temp -1;
  long int Nsize = size;
  long int Bsize = *(temp -1);
  /* We should never physically find ourselves next to */
  /* dseg_lo.  But we could be next to dseg_hi, so...  */
  long int Fsize = ((temp +size/8 +2) == (long*)((char*)dseg_hi+1) 
                                        ? 1L : *(temp +size/8 +2));

  /* ERROR */
  if(Bsize %16 > 1 || Fsize %16 > 1) {fprintf(stderr, "Efree"); return;}
  /* ERROR */
  if(Bsize == 0 || Fsize == 0) 
     fprintf(stderr, "%p or %p =0", &Bsize, &Fsize);

  if(Bsize %2 == 0 && Fsize %2 == 0)  /* Optimizer: %16 = %2 */
  {
    Nsize += Bsize +Fsize +32;
    *(temp +size/8 +Fsize/8 +3) = Nsize;
    *(temp -Bsize/8 -2) = Nsize;
    mm_remove(temp + size/8 +2);
  }
  else if(Fsize %2 == 0)
  {
    /* the next few lines do this: (line per line) */
    /* adjust Nsize       */
    /* move FptrB to ptrB */
    /* move FptrF to ptrF */
    /* fix BptrF          */
    /* fix FptrB          */
    /* set front size     */
    /* set back size      */


    Nsize += Fsize + 16;
    B = temp +1;
    F = temp +2;
    *B    = *(temp +size/8 +3);
    *F    = *(temp + size/8 +4);
    Bs_F  = (long*)(*B +16);
    Fs_B  = (long*)(*F +8);
    *Bs_F = (long)temp;
    *Fs_B = (long)temp;
    *(temp +Nsize/8 +1) = Nsize;
    *temp = Nsize;
  }
  else if(Bsize %2 == 0)
  {
    Nsize += Bsize + 16;
    *(temp + size/8 +1) = Nsize;
    *(temp -Bsize/8 -2) = Nsize;
  }
  else
  {
    B = temp +1;
    F = temp +2;
    *temp = Nsize;                     /* fix front size     */
    *(temp +size/8 +1) = Nsize;        /* fix back size      */
    *B = (long)dseg_lo;                /* set B to dseg_lo   */
    *F = *((long*)dseg_lo +2);         /* set F to *dseg_lo  */
    Fs_B = (long*)(*F +8);
    *Fs_B = (long)temp;                      /* set FptrB to ptr   */
    *((long*)dseg_lo +2) = (long)temp;       /* set dseg_lo to ptr */
  }
}

/* mm_Remove: given a pointer to a free element, */
/* removes from free dll.  Doesn't even look at  */
/* the size of the element ;)                    */
void mm_remove(void* ptr)
{
  long* ptrF = (long*)ptr +2;
  long* ptrB = (long*)ptr +1;
  long* BptrF = (*(long**)ptrB) + 2;
  long* FptrB = (*(long**)ptrF) + 1;
  *BptrF = *ptrF;
  *FptrB = *ptrB;
}
