/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Resnik and MMP 111",
    /* First member full name */
    "Shirwah Tam",
    /* First member email address */
    "stam@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Jay Huang",
    /* Second member email address (blank if none) */
    "jay@andrew.cmu.edu"
};

/*******************************algorithm**********************/
/* we used explicit listing - a header at the begining of each block which stores the
   size and a pointer to the next free block*/

/**************************code starts here*******************/

struct header{
  struct header *next;
  int block_size;
};

struct header *freelist = NULL;  // begining of free list
struct header base; // empty list to get started

int mm_init (void)
{
  struct header temp;

  freelist = mem_sbrk(sizeof(temp)); // freelist starts at dseg_lo -get memory for something to start on
  if (freelist == NULL) //no memory
     return -1;
   else { // make a base node with size 0
     freelist->block_size = 0; // set size to 0
     freelist->next = freelist; //set next to itself
     return 0;
   }
}

void *mm_malloc (size_t size)
{
    struct header *prevfree = freelist; // pointer to the previous freelist 
    int block_size;
    struct header *p; // used to figure size of header
    int space;
    struct header temp;
    
    size = (int)size;
    block_size  = sizeof(temp) + size;
     
    if((block_size% 8) != 0){ // make block_size a multiple of 8
      block_size =  block_size + 8 - (block_size % 8);
    }
   
    for(p=prevfree->next;;prevfree = p, p = p->next){ // loop from begining of list
      //size of block is less equal than the free space pointed to  
	if(block_size <= p->block_size){
	  if(block_size == p->block_size) { // space wanted is exactly what's there
	    prevfree->next = p->next;  // take the prevfree pointer, and point it to the next free space 
          }
	  else { // space is greater than what you need
	    p->block_size = p->block_size - block_size; // block size is extra space
	    space = block_size/16;
            p = p + space; // move pointer to future allocated block header
	    p->block_size = block_size;
          }
         
	  //freelist = prevfree;

	  return (void *)(p+1);
	}
    
	//hit the begining - get new space.
	if(p == freelist){
	  if ((p = mem_sbrk(block_size)) == NULL) // get more memory for number of page_sizes
	    return NULL; 
	  prevfree->next = p; // make the previous free block's next point to new space
	  p->next = freelist; // make the new block's next point to the begining of list
          
	  p->block_size = block_size; // set the size of the block
	  p = prevfree; // set p to prev so that it doesn't go to the begining of list
	}
    }
}

// puts block ptr in free list
void mm_free (void *ptr)
{
  struct header *current, *freeptr; // freeptr points to free block
  int size;

 
   current = (struct header *)ptr; //block_head points to the header of the block to be freed
   
   // start from begining of freelist and find the previous freelock to allocated space
    
   for(freeptr = freelist; current > freeptr; freeptr = freeptr->next){
     if(freeptr >= freeptr->next && (current > freeptr || current < freeptr->next))
       break;
   }
   
   size = (current->block_size)/16;
   if(current + size == freeptr->next){ //join after current
     current->block_size = current->block_size + freeptr->next->block_size;
     current->next = freeptr->next->next;
   }else
     current->next = freeptr->next;

   size = (freeptr->block_size)/16;
   if(freeptr + size == current){ // join before current
     freeptr->block_size = freeptr->block_size + current->block_size;
     freeptr->next = current->next;
   }
   else
     freeptr->next = current;
}
