/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define FREESPACE_P ((long *) (dseg_lo)) 
#define BEGIN_P ((long *) (dseg_lo + 8))
#define END_P ((long *) (dseg_hi + 1))
#define PAGESIZE (long) 8192
#define SIZE_MASK (long) (0xfffffffffffffffe)
#define FREE_FLAG_MASK (long) (0x0000000000000001)

team_t team = {
    /* Team name to be displayed on webpage */
    "blech",
    /* First member full name */
    "Betty Shea",
    /* First member email address */
    "shea",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* general implementation: best-fit, singly-linked implicit free-list 
   with forward and backward coalescing
   header contains size( with last bit as freeflag) and  address of next free. 
   footer contains size and freeflag bit 
   */
  

int mm_init (void)
{
  long * writer = FREESPACE_P;

  if( mem_sbrk( PAGESIZE ) == NULL )
    return -1;

  *writer = (long) ( dseg_lo + 8);
  
  writer++;
  *writer = (long) (PAGESIZE - 32);

  /* write in address of nextfree - 0x00 indicates no more free blocks
     after current */
  writer++;
  *writer = (long) 0x0;

  writer++; 
  writer += ( (PAGESIZE-32) / 8);
  *writer = (long) (PAGESIZE-32); 

  return 0;
}

void *mm_malloc (size_t size)
{

  long* writer =  (long) (*FREESPACE_P);
  long min_amount = (dseg_hi - dseg_lo), temp, temp2;
  long* best = NULL, *last = FREESPACE_P;
  long r_size = (long) ( (size%8==0) ? size : ((size - (size%8)) + 8));

  do
  {
    if( writer != 0x0 )  /* haven't searched through whole freelist */
    { 
    }  
    else  /* either accept imperfect fit or everything too small */
    {
      if( best != NULL )    /* case: imperfect fit */
      {
	temp = (*best);  
	writer = best;
	(*writer) = (r_size | FREE_FLAG_MASK);
	writer +=2;
	best = writer;   
	writer += (r_size/8);
	(*writer) = (r_size | FREE_FLAG_MASK);  

	/* remove from freelist */
	if( last == (*FREESPACE_P) )   /* was first on free list */
	{
	  /* write address of the next into  FREESPACE_P - could be 0x0 */
	  writer -= (r_size/8);
	  writer--;
	  (*FREESPACE_P) = (*writer);
	  writer++;
	  writer += (r_size/8);
	}
	else
	{
	  last++;
	  writer-= (r_size/8);
	  writer--;  
	  (*last) = (*writer); 
	  last--;  
	  writer++;
	  writer+= (r_size/8);
	}

	/* take care of remaining space */
	writer++; 
	(*writer) = (long) (temp - r_size - 24);
	writer += 2;
	writer = writer + ((temp - r_size - 24)/8);
	*writer = (long) (temp - r_size - 24);
	writer -= ((temp - r_size - 24)/8);
	writer -- ;
	*writer = (*FREESPACE_P); 
	writer--;
	(*FREESPACE_P) = writer;
	
	/* return correct pointer */
	writer = best;
	writer++;
	return best;
      }
      else  /* case: no size big enough */
      {
	writer = END_P;
	writer--;   /* points at beginning of last footer */

	/* store amount of free space left at end of heap in temp */
	if( (*writer) & FREE_FLAG_MASK )  /* allocated */
	  temp = 0x0;
	else
	  temp = ((*writer) | SIZE_MASK );

	temp2 = temp;
	if( temp == 0x0 )
	  writer++;  /* dseg_hi */
	else
	{
	  writer -= (temp/8);
	  writer -= 2;
	}
	
	/* calculate how much space needed to be requested */
	if( r_size - temp <= PAGESIZE )
	  temp = PAGESIZE;
	else  /* round up */
	  temp = ( (((r_size - temp)%PAGESIZE) == 0) ? (r_size - temp) : 
		  ( (r_size - temp) - ( (r_size-temp) % PAGESIZE ) + PAGESIZE) ); 

	if( mem_sbrk( temp ) == NULL )
	  return NULL;

	/* if not enough space left for extra header, footer, and 8-byte data
	   - just over allocate */
	if( (temp + temp2 - r_size) < 32 )
	  r_size = temp;

	(*writer) = (r_size | FREE_FLAG_MASK);
	writer += 2;
	best = writer;
	writer += (r_size/8);
	(*writer) = (r_size | FREE_FLAG_MASK);  

	/* remove from freelist */
	/* need to search - reuse last pointer */
	writer -= (r_size/8);
	writer -=2;
	for( last = (*FREESPACE_P); (!last) && ((*(++last)) != writer) ; last = (*last) )
	{
	}
	writer++;
	(*last) = (*writer); 

	writer++;
	writer += (r_size/8);

	/* take care of possible free space left */
	if( temp == 0 )
	{
	  writer++;  

	  temp = (long) ( (long) (END_P) - (long) best);
	  temp -= (long) (r_size - 32);
	  (*writer) = temp;  
	  writer+=2;
	  writer += (temp/8);
	  (*writer) = temp;

	  /* insert block to free list */
	  writer -= (temp/8);
	  writer--;
	  (*writer) = (*FREESPACE_P);  /* writer hold's old firstfree addr */
	  writer--;
	  (*FREESPACE_P) = (writer);   /* freespace hold's current addr */
	}
	return best;
      }
    }

    /* close enough fit such that there is not enough space left for writing
       a new header size, header next, 8 bytes of data, and footer anyway */
    if( (((*writer)& SIZE_MASK) - r_size) < 32  && (((*writer) & SIZE_MASK) - r_size) >=0 )
    {
      *writer = (*writer) | FREE_FLAG_MASK;
      writer += 2;
      writer +=( ((*writer) & SIZE_MASK)/8 );
      *writer = (*writer) | FREE_FLAG_MASK;   

      /* remove it from freelist */
      if( last == FREESPACE_P )   /* no previous - first on list */
      {
	writer = writer - ( ((*writer) & SIZE_MASK)/8 );
	writer++; 
	*FREESPACE_P = *writer;
	writer++;
	return writer;
      }
      else  
      {
	last++; 
	writer++;
	*last = (*writer); 
	writer++;
	return writer;
      }
    }
    else if( ((*writer) & SIZE_MASK) < r_size )  /* too small */
    {
    }
    else if( ((*writer) & SIZE_MASK) > r_size )  /* imperfect fit */
    {
      /* calculate current fit */
      temp = ((*writer));
      temp = temp & SIZE_MASK;
      temp = temp - r_size;

      if( temp < min_amount )
      {
	min_amount = temp;
	best = writer;
      }
    }
    
    last = writer;
    writer++; 
    writer = (*writer);
  } 
  while( 1 );
}

void mm_free (void *ptr)
{
  long * writer = ptr, *head = NULL, *tail = NULL;
  long temp;

  writer-=2;
  writer--;

  /* backward coalescing */
  if( ((*writer) & FREE_FLAG_MASK) == 0x0 )
  {
    temp = ((*writer) & SIZE_MASK);
    writer = writer - (temp/8);
    writer-=2;
    head = writer;

    tail = ptr;
    tail-=2;
    (*writer) = (long) (temp + 24 + ((*tail) & SIZE_MASK)); 
    tail = NULL;

    /* automatically added to the freelist */
  }
  else  
  {
    writer = ptr;
    writer -= 2;
    head = writer;
    (*writer) = ((*writer) & SIZE_MASK);
    
    /* need to add to freelist */
    writer++;
    (* writer) = (* FREESPACE_P);
    writer--;
    (* FREESPACE_P) = (writer);  
  }

  writer = ptr;
  writer = writer - 2;
  writer = writer + ((*writer) & SIZE_MASK) + 2;

  writer++;
  if( ((*writer) & FREE_FLAG_MASK) == 0x0 )  /* forward coalesce */
  {
    (*head) = (long) (((*head) & SIZE_MASK) + ((*writer) & SIZE_MASK) + 24); 

    tail = (long *) (*FREESPACE_P);  
    tail++; 

    while( (*tail) != (long) (writer) )
    {
      tail = (long *) (*tail);
      tail++;
    }
    writer++;
    (*tail) = (*writer);
    
    writer--; 
    writer = ((*writer) & SIZE_MASK) + 2;
    tail = writer; 
    (*tail) = (*head);
  }
  else
  { 
    writer--; 
    (*writer) = (*head);
    tail = writer;
    /* no need to change pointers because already added to list and nothing
       was killed */ 
  }
}

