/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Monkey Love",
    /* First member full name */
    "Roman Stanchak",
    /* First member email address */
    "roman@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Marcus Louie",
    /* Second member email address (blank if none) */
    "mlouie@andrew.cmu.edu"
};

#define NEWPAGE mem_pagesize()
#define NUM_LISTS 17  /* Number of free lists */
#define BLOCKSIZE 8   /* 8-byte aligned */
#define HEADERSIZE 1   /* Header Size */

void * new_block(size_t num_blocks);

int mm_init (void)
{
  int i;

  /* Make room for the number of separate free lists */
  mem_sbrk(BLOCKSIZE * NUM_LISTS );

  /* Initialize heads of free space to point to NULL */
  for (i = 0; i <= NUM_LISTS; i++) {
     ((int **)dseg_lo)[i]= (int *)NULL;
     // printf("Index %d: %p\n", i, dseg_lo +i * BLOCKSIZE);
  }

  //printf("%d\n", ((int **)dseg_lo)[NUM_LISTS]);

  ((int *)dseg_lo)[NUM_LISTS] = 0;

  return -1;
}

/* void *mm_malloc (size_t size)
   Description: Private implementation of malloc()
   Method: Uses linked lists of different class sizes. Linked lists are 
   held in an array w/ other free lists. If block of size t is to be allocated,
   it first checks  the appropriate linked list of the class size. If free
   list is empty, it checks the next size free list. If no free blocks are
   available, it increases the heap and tacks on an extra block to the
   appropriate list.

   When block is found, allocate block, 8-byte aligned, and add remaining
   free space to appropriate free list.

   Returns NULL if not able to allocate block
   Returns starting address of block allocated(of size requested or more).
   Header is not the starting address.
*/

void *mm_malloc (size_t size)
{
  
    long *result;  /* Holds address returned */
    //int ** d_lo = dseg_lo;
    int index, i;
    int numBlocks, freeBlocks;
    int tmp;

    //printf("Malloc Called:\n ");

    if (size == 0)
      return NULL;

    /* Size in blocks */
    numBlocks = ((size - 1) / 8) + 1;
   
    //printf("size : %d\n", size);
    
    /* Find index of free list that block belongs to */
    tmp = numBlocks;
    if (size < 8)
      index = 0;
    else
      for (index = 1; (tmp >>= 1) != 0; index++)
	;

    for (i = index; i < NUM_LISTS; i++) {
       if ( ((int**)dseg_lo)[i] != 0) {
	 /* There are free blocks in this class size. Pop off head of list.
	    Find smallest number of 8-bytes to give to block. Redistribute
	    the remaining fragment to free lists of appropriate size
	 */

	 /* Pop off head of list and assign to result. Repoint head of 
	    free list. */

	 result = ((int **)dseg_lo)[i];

	 freeBlocks = result[0] & ~(1L << 31L);

	 /* Check the free list for an appropriate size block */
	
	
	 if (freeBlocks >= numBlocks) {
	   /* Pop off free block from free list */
	   result = ((int **)dseg_lo)[i];

	   ((int **)dseg_lo)[i] = result[1]; /* Assign d_lo[index] to the next freeB. */

	   return result;
	 }
       } 
    } 
    /*It couldn't find a block on any lists, so we'll just make some space.*/ 
    result = new_block(numBlocks);

    if (result != NULL)
      return result;
    
    return NULL;
}

void * new_block(size_t num_blocks)
{

   /* Where result is stored */
   int *result;
   int ** d_lo = dseg_lo;
   
   /* Make room for the number of blocks to be allocated plus one 8-byte
      header */
   result = mem_sbrk((num_blocks + 1) * BLOCKSIZE);

   if (result == NULL)
     return NULL;

   //printf("Making new block\n");

   /* Checks to see if anything has been allocated on the heap yet. */
   /* If so, then set size of previous block in header */
   if ( ((int **)dseg_lo)[NUM_LISTS] != NULL )
     result[1] = *((int **)dseg_lo)[NUM_LISTS];
   else
     result[1] = 0;  /* If not, this must be the first block
				   allocated */

   /* Set first 4bytes of header to hold the number of 8-byte blocks this
      current allocation requires. */
   result[0] = num_blocks | (1L << 31L);
   //   printf("%d\n", result[0] & ~(1L << 31L));
   //getchar();

   /* Set a pointer to the end of the heap*/
   ((int **)dseg_lo)[NUM_LISTS] = result;

   //printf("%p\n", result);
   /* Return the block allocated moved up 8 bytes to avoid header */

   //   printf("%p\n", ((int **)dseg_lo)[NUM_LISTS]);
   //printf("%p\n", result);72
  
   return (result + 2);
    
   

}

/* void mm_free (void *ptr)
   Attempts to check the next and previous blocks and coalesce with them if free. The checks to see
   if the blocks are already allocated don't work here. If it did, there'd also be code to go
   down the appropriate free lists and remove all blocks that were coalesced. 

void mm_free (void *ptr)
{
   int size, index, tmp;
   long *blockToFree = ptr;
   int toPrevBlock, toNextBlock, nextBlockSize;
   long *prevBlock, *nextBlock, *newBlock;
   long *nextNextBlock;

   int i1;

   
   if (!(blockToFree[-1] & (1L << 31L)))
     return;

   size = blockToFree[-1] & ~(1L << 31L);   

  
     if (blockToFree - 1 != dseg_lo + NUM_LISTS * BLOCKSIZE && ((int *)blockToFree)[-1] != 0) {
     
     /* Calculate the #  of 8-byte blocks the previous allocation is */
       toPrevBlock = ((int *)blockToFree)[-1] & ~(1L << 31L);

     /* Can't find bug, so hack it. */
     if (toPrevBlock < 8192) {

       /* Calculate address of new block. Include 8-byte header before current block
	  and the two 8-byte headers in the previous block. */
       prevBlock = blockToFree - (toPrevBlock + 2*HEADERSIZE);
       
      
       /* If previous block is not allocated, coalesce */
       if (!(prevBlock[0] & (1L << 31L))) {

	 //printf("%d   %d\n", toPrevBlock, prevBlock[0]);
	 /* Adjust size of the new block. Include current block's headers */
	 size = size + toPrevBlock + 2*HEADERSIZE;
	 
	 /* Set the new block address. Take into account  previous block's headers */
	 blockToFree = blockToFree - toPrevBlock - HEADERSIZE;
       }
     }
   }
   

   ((int *)blockToFree)[0] = size;


  tmp = size;
   if (tmp < 1)
     index = 0;
   else
     for (index = 1; (tmp >>= 1) != 0; index++)
       ;


   if (((int**)dseg_lo)[index]) {
     /* Point the new block to the head of the free list */
     blockToFree[1] = ((long **)dseg_lo)[index];
     /* Repoint the head to the new free block */
     ((long **)dseg_lo)[index] = blockToFree;
   } else {
     /* Point the new block to the head of the free list */
     blockToFree[1] = NULL;
     ((long **)dseg_lo)[index] = blockToFree;
   }

  
}


























































































































































































