/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"
typedef unsigned int sptr;  //small pointer
int log2(int size);

void * new_allocate(size_t num_blocks);
void print_list();
void create_free_test();
void remove_from_freelist(int * ptr);
void insert_in_freelist(int * ptr);
void set_allocated_header(int * ptr, int size_chunk, int size_prev_chunk);
void set_free_header(int * ptr, int size_chunk, int size_prev_chunk);

team_t team = {
    /* Team name to be displayed on webpage */
    "Monkey Love",
    /* First member full name */
    "Roman Stanchak",
    /* First member email address */
    "roman@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Marcus Louie",
    /* Second member email address (blank if none) */
    "mlouie@andrew.cmu.edu"
};

#define NUM_LISTS 32

int mm_init (void)
{
  int i;
   // int ** dlo=dseg_lo;
  /* allocate initial space for free list arrays + 64 bytes of storage */
  /* extra space is for pointer to last element */
  if(!mem_sbrk(8*(NUM_LISTS+9)))
    return -1;
 
  /* initialize each list to Null to start */
  for(i=0; i<NUM_LISTS; i++){
    ((int **)dseg_lo)[i]=0;
  
  }
  // mem_sbrk may allocate more than I need, so assign this space to a freelist
   if(dseg_hi> &(((int **)dseg_lo)[NUM_LISTS+1]))
    {
      i=((long int)dseg_hi-((long int)&((int**)dseg_lo)[NUM_LISTS+1])-1L)/8;
     
      //create the free block
      set_free_header(&((int **)dseg_lo)[NUM_LISTS+1],i,0);
	
      //insert in appropriate freelist
      insert_in_freelist(&((int **)dseg_lo)[NUM_LISTS+1]);
    }
   print_list();
  return 0;
}






void *mm_malloc (size_t size)
{
  int list_index;

  //find the right index #
  if (size<8)
    if(size>0)
      list_index=0;
    else
      return NULL;
  else
    list_index=log2(size-1)-2;

  //scroll through free lists, see if anything will fit
  for(; list_index<NUM_LISTS; list_index++){  	
    if(((int**)dseg_lo)[list_index]!=NULL)
      printf("m\n");
      //  return(list_allocate());
  }
  return (new_allocate(((size-1)/8)+1));
  
  //  printf("m\n");
  //  printf("size: %d, %d\n", size, ((size-1)/8) +1);
  /*Check arraylist[log2 size] for free space, 
    If not found go to next size and repeat
    if found remove from list, add remaining free space to appropriate list
    (remember to update pointers/sizes in all lists)

    if not found through all free lists, allocate more space on heap
    
    return pointer to the newly allocated space or null if failed 
 
  // printf("size: %d, ",size);
    if (i < 8)
    log=0;
  else
    for (log=0; (i>>=1) != 0; log++);
  //  printf("log: %d\n",log-2);
  for (i=log-2; i<NUM_LISTS; i++){
    // printf("%d, %p\n",i,((int**)dseg_lo)[i]);

    if (((int **)dseg_lo)[i]!=NULL){
      //   printf("i: %d\n",i);
      return list_alloc(((size-1)/8)+1, i);
    }
  }
  return new_allocate(((size-1)/8)+1);
  */ 
  return NULL;

}

void * new_allocate(size_t num_blocks){
  int size_prev=((int**)dseg_lo)[NUM_LISTS][0];
  int * new_chunk;

  /* Check if last block is free;
     Allocate the appropriate amount of memory on the end of heap 
     and hold onto the pointer*/

  if(size_prev>0){
    //chunk is allocated
    new_chunk=mem_sbrk((num_blocks +1)*8);
  }
  else
    //we add b/c the size of the prev block < 0 - indicating it is free
    if(mem_sbrk((num_blocks+size_prev)*8)==NULL)
      return NULL;
    else{
      new_chunk=((int**)dseg_lo)[NUM_LISTS];
      size_prev=abs(new_chunk[1]);
    }
  set_allocated_header(new_chunk, num_blocks, size_prev);
    
  //    print_list();
		  /*
  //the next if-else writes the size of the preceding data block in our header
  //if the heap already has data on it
  if(dlo[NUM_LISTS] != NULL){
    temp[1] = *dlo[NUM_LISTS];
  }
   //else this is the first allocation of actual data on the heap
  else
    temp[1] = 0;

  //set the data size in the header
  temp[0]=num_blocks;

  //set the last item on the heap to this newly allocated piece
  dlo[NUM_LISTS]=temp;
  printf("new allocated: %p\n",temp+2); */
  return new_chunk+2;
}





void * list_alloc(int num_blocks, int index){
  int *new_chunk;
  int *free_chunk;
  int **dlo = dseg_lo;
  int i;
  int size_freefrag;
  //hold onto the top of the list
  new_chunk=dlo[index];
  //  printf("num_block:%d, index:%d, new_chunk[2]=%d, new_chunk[0]=%d\n",num_blocks,index,new_chunk[2],new_chunk[0]);

  //Remove that chunk from free list
  if(new_chunk[2]!=0)
    dlo[index]=((long int)dseg_lo)+((long int)new_chunk[2])+8L;
  else
    dlo[index]=NULL;
    // printf("%p\n",dlo[index]);

  //calculate size of the free fragment
  size_freefrag=abs(new_chunk[0]) - num_blocks;
  // printf("%d\n",size_freefrag);

  if(size_freefrag>0){
    //set pointer to any remaining free space
    free_chunk=&(new_chunk[(num_blocks+1)*2]);
    //set header of free_chunk
    free_chunk[0]=-size_freefrag;
    free_chunk[1]=-num_blocks;

    //for chunks that have enough room for a pointer
    if(size_freefrag>1) 
      insert_in_freelist(free_chunk);
    
  }
  //set size of new chunk
  new_chunk[0] = num_blocks;  

  /*note: the previous chunk-data in new_chunk retains the value 
    it inherits from that previously free chunk, so we don't need to write
    a new prev_chunk_size header in our new chunk*/
  printf("list allocated: %p\n",new_chunk+2);
  return new_chunk+2;
}

void remove_from_freelist(int * ptr){

   int ** dlo = dseg_lo;
   sptr * next;
   sptr * prev;
   int log,size;
   //  printf("ptr=%p, ptr[2]=%ud, ptr[3]=%ud\n",ptr,ptr[2], ptr[3]);
   prev=dlo+(long int)ptr[3];
   next=dlo+(long int)ptr[2];
   //   printf("dseg_lo=%p,dseg_hi=%p, prev=%p,next=%p\n",dseg_lo,dseg_hi,prev, next);
   //check if ptr is the tail of freelist
   if(ptr[2]!=0){
     next[3]=ptr[3];
     //check if head of freelist
     if(ptr[3]!=0)
       prev[2]=ptr[2];
     else {
       size=abs(ptr[0]);
       for (log=0; (size>>=1) != 0; log++);
       dlo[log]=next;
     }
   }
   else {  //is the tail
     //check if head of freelist
     if(ptr[3]!=0)
       prev[2]=0;
     else { //is the sole thing on the list
       size=abs(ptr[0]);
       for (log=0; (size>>=1) != 0; log++);
       dlo[log]=NULL;
     }
   }
}

void insert_in_freelist(int * ptr){

  int i;
  int **dlo=dseg_lo;
  sptr * temp;
  int chunk_size=ptr[0];
  //  printf("ptr/free size/next free/prev free= %p,%d,%d,%d,\n",ptr,ptr[0],ptr[2],ptr[3]);
  //  int prev_size=(unsigned)ptr[1];
  if(chunk_size<0)
    chunk_size=-chunk_size;
  //  printf("size=%d\n",chunk_size);
  // get the proper index
  for (i=0; (chunk_size >>= 1) != 0; i++)
    ;
  //  printf("index=%d\n",i);
  if(dlo[i]!=NULL){
    //set next sptr to the current head of list
    ptr[2]=((long int)dlo[i])-((long int)dlo);
    temp=dlo[i];
    //   printf("dlo[i]:%p,i:%d,i:%d\n",dlo[i],i, i);
    //set current head of list prev pointer to our new block
    temp[3]=(((long int)ptr) -((long int)dlo));
  }
  else
    ptr[2]=0;

  //set prev sptr to NULL
  ptr[3]=0;
  //set head of list to new free chunk
  dlo[i]=ptr;
  //  printf("ptr/free size/next free/prev free/index = %p,%d,%d,%d,%d\n",ptr,ptr[0],ptr[2],ptr[3],i);
 }
void set_allocated_header(int * ptr, int size_chunk, int size_prev_chunk)
{
  //set size of free chunk
  ptr[0]=size_chunk;
  //set size of previous chunk
  ptr[1]=size_prev_chunk;
  /*  check to see if this is the last allocated chunk
      if so, set last chunk pointer in heap header to ptr
      if not, set the next chunk's size_prev_chunk header value to size_chunk*/
  if((size_chunk+(long int)dseg_lo)>dseg_hi)
    ((int **)dseg_lo)[NUM_LISTS]=ptr;
  else
    ptr[(size_chunk+2)*2]=size_chunk;
}


/*  Writes a free chunk header w/ following params to the chunk at ptr
    and sets the last chunk on the heap pointer on the heap header
    Also sets pointer values to 0
    Assumptions: all parameters are non-negative */
void set_free_header(int * ptr, int size_chunk, int size_prev_chunk)
{
  printf("%x\n%x\n",-size_chunk,size_prev_chunk);

  //set size of free chunk
  ptr[0]=-size_chunk;

  //set size of previous chunk
  ptr[1]=size_prev_chunk;

  /*  check to see if this is the last allocated chunk
      if so, set last chunk pointer in heap header to ptr
      if not, set the next chunk's size_prev_chunk header value to size_chunk*/
  if(ptr+(size_chunk*2)+2>dseg_hi)    
    ((int **)dseg_lo)[NUM_LISTS]=ptr;
  else
    ptr[(size_chunk+2)*2]=size_chunk;

  //initialize the list pointers if theres room
  if(size_chunk>0)
    {
      ptr[2]=0;
      ptr[3]=0;
    }
}

void print_list(){
  int j;
  int k=((long int)dseg_hi-(long int)dseg_lo)/8;
     printf("%x, %x\n ",dseg_lo, dseg_hi);
  for (j=0; j <= k; j++){
    printf("%x ",(((long int*)dseg_lo)[j]));
  
  }
  printf("\n");
}
  
int log2(int size){
  int log;
  for (log=0; (size>>=1) != 0; log++);
  return log;
}
void mm_free (void *ptr)
{
  
/*Check chunk before and chunk after block to be freed; 
  coalese if neccessary

  int * temp=ptr-8;
  int * prev_chunk;
  int * next_chunk;

  //  sptr prev=temp[3];
  //  sptr next=temp[2];
  
  long int size_me=temp[0];
  long int size_prev=temp[1];
  printf("size: %d freed: %p\n",temp[0],ptr);
  // printf("temp:%p, size_me:%d, size_prev: %d\n", temp,size_me,size_prev);
  prev_chunk=(long int)(temp)-(long int)size_prev*8-8L;
  next_chunk=(long int)(temp)+(long int)size_me*8+8L;
  // printf("prev chunk:%p, next chunk:%p\n", prev_chunk, next_chunk); 
  // printf("prev chunk:[0]%d, next chunk[0]:%d\n", prev_chunk[0], next_chunk[0]);  

  //4 cases
  //prev block free and after block free
  //prev block free and after block not free or off the end of heap
  //prev block not free or off beginning of heap and after block free
  //neither before or after is free

   //prev not free
  if(((long int)prev_chunk < (long int)&(((int **)dseg_lo)[NUM_LISTS])) || (prev_chunk[0]>0)){
    
    //next not free
      if(((long int)next_chunk > (long int)((int **)dseg_hi)) || (next_chunk[0]>0))
	insert_in_freelist(temp);

    //next is free
      else{
      remove_from_freelist(next_chunk);
      //set header
      temp[0]=-(temp[0]+abs(next_chunk[0])+1);
      next_chunk[next_chunk[0]+2]=abs(temp[0]);
      insert_in_freelist(temp);

      }
  }
  //prev is free
    else{

    //next not free
      if((next_chunk > (long int)((int **)dseg_hi))  ||  (next_chunk[0] > 0)){
	remove_from_freelist(prev_chunk);
	//set header
	prev_chunk[0]=-(temp[0]+temp[1]+1);
	next_chunk[1]=abs(prev_chunk[0]);
	
	insert_in_freelist(prev_chunk);
      }
      
      //next is free
      else{
	remove_from_freelist(next_chunk);
	remove_from_freelist(prev_chunk);
	//set headers
	prev_chunk[0]=-2-(abs(temp[0])+abs(next_chunk[0])+abs(temp[1]));
  	next_chunk[next_chunk[0]+2]=(unsigned)prev_chunk[0];
 	insert_in_freelist(prev_chunk);
      }
    }
*/
}
