/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "kodomo no omocha",
    /* First member full name */
    "Nathan Strom",
    /* First member email address */
    "nstrom@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Jeremy Praissman",
    /* Second member email address (blank if none) */
    "jeremyp@andrew.cmu.edu"
};


int mm_init (void)
{  
   long page_size = mem_pagesize();
   long header;

/* initially allocate one page (8192 bytes) */   
   if(mem_sbrk(page_size) != NULL) {
      header = ((page_size >> 3) << 1);
      * ((long *) dseg_lo) = header;
      return 0;
   }
   else
      return -1;
}


/* Description of algorithm and operation:

	This version of mm_malloc uses implicit lists with a header for each block.
	No footer is used. The technique used to find another region of memory
	of appropriate size is first fit. New pages are allocated only after malloc
	sees that all current pages are "full" as far as it can tell. */

void *mm_malloc (size_t size)
{
   char *curr = dseg_lo;
   long *next;
   long words_requested = (((size >> 3) << 3) == size) ? (size >> 3) + 1 : (size >> 3) + 2;

   long words_in_region = 0;
   long page_size = mem_pagesize();
   long pages_required = 0;
   long curr_header, next_header, allocated;

   words_in_region = (*((long *) curr)) >> 1;
   allocated = (*((long *) curr) & 1);

/* locate where to insert block */
   while(allocated  || ((words_in_region < words_requested) && (((curr + words_in_region*8)+7) < dseg_hi)))
   {

      ((long *) curr) = ((long *) curr) + words_in_region;
      words_in_region = (*((long *) curr)) >> 1; /* long * gets 8 bytes */
      allocated = (*((long *) curr) & 1);
   }

/* allocate additional space in increments of page size, if necessary */
   if((curr + (words_requested<<3) ) >= dseg_hi) {
      pages_required = (size / page_size) + 1;
      
      if(mem_sbrk(pages_required * page_size) == NULL) {
			 return NULL;
      }
		
      words_in_region += (pages_required * (page_size >> 3));
   }

/* set header of current block */
   curr_header = (words_requested << 1) + 1; /* +1 for flag */
   *((long *) curr) = curr_header; /* this will give us the number of words to the next header */

/* set header of next block, if necessary */	
   next_header = (words_in_region - words_requested) << 1;

	if (next_header != 0)
	{		 
		 next = ((long *) curr);
		 next += words_requested ;
		 *next = next_header;
	}

/* return pointer to start of allocated data space */
   return (void *) (curr + 8);
}

/* This version of mm_free only does coallescing in one direction since we use only a header
	for each block of memory. After each free, the block freed is coallesced if possible
	with the next block. In general this is relatively efficient. */

void mm_free (void *ptr)
{
	 long *ptr_manip = (long *) ptr; 
	 long old_words;
	 long *next_header; 
	 long next_words;
	 long new_header;

	 ptr_manip -= 1;   
	 old_words = (*ptr_manip) >> 1;  /* drop flag */
	 next_header = ptr_manip + old_words;
	 next_words = (*next_header) >> 1;
	 new_header = ((*next_header) & 1) ? (old_words << 1) : ((old_words + next_words) << 1);
	 *ptr_manip = new_header;	 
}
