/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *  Implementation: Using Free-Link List and first fit to implement.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "DaBomb",
    /* First member full name */
    "Nawaporn Wisitpongphan",
    /* First member email address */
    "nawaporn",
    /* Second member full name (leave blank if none) */
    "Thanyapong Ekvetchavit",
    /* Second member email address (blank if none) */
    "te"
};

typedef unsigned long* blk;
blk fhead;
const size_t HEADER = 2*sizeof(blk);

int mm_init (void)
{
  blk temp;
  if (!mem_sbrk(mem_pagesize()) ) return -1;
  fhead = (blk) dseg_lo; /*pointer to head of free list*/
  *fhead = mem_usage() - HEADER +1; /*size of block should be multiple of 8;flag = 0 for free block*/
  temp = fhead+1;
  *temp = NULL; /*There is no next free block;*/
  temp = temp+1;
  *temp = NULL; /*There is also no previous block;*/
  temp = (blk) (dseg_hi - 7);
  *temp = *fhead; /*keep size of free block at the end of the block */
  return 0;
  
}
/**********************************************************************************
             mm_malloc():
             Overview:  Traverse thru list of free block start from head (fhead)
             Use the first block that fit, Split the unused and add it back to the
             free list by insert to the front.
***********************************************************************************/

void *mm_malloc (size_t size)
{
  
  blk current, temp,temp1,temp2;
  
  size_t space;
  current = fhead;
  
  if (size%8) {
    size = size + 8 - size%8;  /* adjust size so that it is multiple of 8; */
    
  }
  if (size <=8) size = 16;     /* Minimum size is 16; otherwise it cannot be added to free list*/
  
  
  /* Loop through the alogrithm process, Expand the heap if necessary */
  do
  {
    while (current!=NULL && size > *current) /* Find the free block that is large enough*/
    {
      current = (blk)(*(current+1)); /* Go to next free block */
    }
  /************expand heap ****************/
    if(current == NULL)
    { 
      temp = (blk)(dseg_hi - 7L); /* keep address of the edge of old page */
      
      /*return NULL if necessary i.e. no more mem available*/
      if (!mem_sbrk(mem_pagesize()) ) return NULL;
      
      if ( !(*temp & 1L) ) /*check if the new expanded area can be coalescing w/ the old one*/
      {
        temp2 = temp - (*temp/8) - 1; /* ptr to last free block of previous page */
        *temp2 = *temp + mem_pagesize(); /* adjust size*/
        *temp = NULL;                    /* Clear the size of the old free block*/
        
        temp = (blk) (dseg_hi - 7L); /* ptr to last word of expanded block*/
        *temp = *temp2;              /* adjust size and update current ptr*/
        current = temp2;
      } else { /*expanded area cannot coalescing w/ the old one*/
        temp = temp+1; 
        *temp = mem_pagesize() - HEADER;
        
        temp2 = temp+1; /*insert new block in front of the free list */
        *temp2 = (unsigned long) fhead;
        temp2++;
        *temp2 = NULL;
        temp2 = (blk)(dseg_hi - 7L);
        *temp2 = *temp;
        current = fhead = temp;
        
        temp = (blk)*(temp+1); /*previous of old fhead point to the new block*/
        if (temp){
          temp = temp+2;
          *temp = (unsigned long) current;
        }
        
      }
      
    }
    
    else /* allocate */
    {
      space = *current - size;
      if (space >= 2*HEADER) /* there's free space left */
      {
        /* chop the first block and set the size and flag(1) in the header & footer*/
        *current = size + 1L;
        temp = current + (size/8) + 2; /*set the left over space w/ new information*/
        *temp = space - HEADER;
        
        temp2 = temp + (space/8) - 1; /* adjust pointer*/
        *temp2 = *temp;
        
        temp--;            
        *temp = *current;
        
        temp = temp+2; /* next of free block */
        *temp = *(current + 1);
        if (*temp) { /* adjust pointer that point to that block to point to the correct place*/
          temp2 = ((blk)*temp) + 2;
          *temp2 = (unsigned long) (temp - 1);
        } 
        temp = temp+1; /*prev of free block */
        *temp = *(current+2);
        if (*temp) {
          temp2 = ((blk)*temp) + 1;
          *temp2 = (unsigned long) (temp - 2);
        }
        else fhead = temp-2;
        
        temp = current+1; /* clear unused pointer */
        *temp = NULL;
        temp++;
        *temp = NULL;
        return current+1;
        
      }
      else { /* take the whole block and allocate*/ 
        *current = *current + 1L; /*Add flag to the last bit */
        temp = current + (*current/8)+1;
        *temp = *current; /* set size at the footer*/
        
        temp = (blk)(*(current + 2)); /* current->prev */
        if(temp){  /*if there is a previous block*/
          temp1 = temp+1; /*current->prev->next*/
          *temp1 = *(current + 1); /*current->prev->next = current->next*/
        }
        temp2 = (blk)(*(current + 1)); /*current->next*/
        if(temp2 ){/* if there is next block*/
          temp2 = temp2 + 2; /*current->next->prev*/
          *temp2 = *(current + 2); /*current->next->prev = current->prev*/
        }
        if (!temp && !temp2) fhead = NULL;
        else if(!temp){ /*If we allocated the block at the head of the list*/
          fhead = (blk)(*(current +1)); /*free_head = current->next;*/
        }
        temp = current+1; /* clear unused pointer */
        *temp = NULL;
        temp++;
        *temp = NULL;
        return current +1;
        
      }       
    }
    
  }while (1); /* loop while there is enough space to allocate */
  
}

/*****************************************************************************
      mm_free(): 
      Overview: free the block ; if the blocks nearby are not allocated
      coalescing with that block.
      Variable: temp1 -> pointer to header of block to be freed
                temp2 -> pointer to footer of block to be freed
               prev -> pointer to foo ter of previous block
	             next -> pointer to header of next block
	    memory : [H previous block F|H   block to be freed  F|H  next block  F|]
******************************************************************************/


void mm_free (void *ptr) 
{
  blk temp1,temp2,prev,next,first,last,tmp,tmp1,tmp2,temp;
  
  temp1 = ((unsigned long*) ptr) - 1; /*pointer to header of block to be freed */
  
  if ( (unsigned long) temp1<=(unsigned long) dseg_lo || (unsigned long) temp1> (unsigned long) dseg_hi || !(*temp1&1L) ) return; /* out of bound  or if that block is free*/
  
  temp2 = temp1 + ((*temp1-1L)/8) + 1; /* pointer footer of block to be freed */
  if ( *temp1 != *temp2) return; /* header(size) != footer(size) */
  
  prev = temp1-1; /* footer of previous block */
  
  /* can coalescing the previous block */
  if ((unsigned long) prev > (unsigned long) dseg_lo && !(*prev&1L) ) 
  {
    *temp2 = *temp2-1 + *prev + HEADER;
    first = prev - (*prev/8) - 1; 
    *first = *temp2;
  }
  
  next = temp2 + 1; /* pointer to header of next block */
/* can coalescing next block */
  if ((unsigned long) next < (unsigned long) dseg_hi && !(*next&1L) )  
  {
    last = next + (*next/8) + 1;
    *last = *last + (*temp2 & ~1L) + HEADER;
    /* adjust necessary pointer */
    tmp1 = (blk) (*(next+1)); /* tmp1 = nextb->next */
    tmp2 = (blk) (*(next+2)); /* tmp2 = nextb->prev */
/* Set the pointers in the header of next_block so that tehy still link to each other */
    if (tmp1) {
      tmp = tmp1 + 2;
      *tmp = (unsigned long) tmp2;    /* tmp1->prev = tmp2 */
      if (tmp2) {
        tmp = tmp2 + 1;
        *tmp = (unsigned long) tmp1; /* tmp2->next = tmp1 */
      }
      else {
        fhead = tmp1;
      }
    } else {
      if (tmp2) {
        tmp = tmp2 + 1;
        *tmp = (unsigned long) NULL;
      }
      
    } 
    /* If Did not coalescing  previous block */
    if (!((unsigned long) prev > (unsigned long) dseg_lo && !(*prev&1L))  ) 
      
    {
      tmp = temp1;
      if (!tmp1 && !tmp2){ /* if next block is the only free block in the free list*/
        tmp1 = tmp + 1;    /*Merge the new one to it*/
        *tmp1 = NULL;
      }
      
      else
      { 
        tmp1 = tmp + 1;  /* if next block is not the only free block in the free list*/
        *tmp1 = (unsigned long) fhead; /* insert the new block in the head of the list*/ 
      }
      tmp1++;
      *tmp1 = NULL;
      fhead = tmp;   
      
      temp = (blk) *(tmp+1);/* set previous pointer of old fhead*/
      if (temp ) {
        
        temp = temp + 2;
        *temp = (unsigned long)fhead;
      }
      
      
    }
    else {
      tmp = first;
      *prev = NULL;
      *temp1 = NULL; 
    } 
    *temp2 = NULL;/* clear all pointer that are not used */
    *next = NULL;
    
    *tmp = *last;
    next++;
    *next = NULL;
    next++;
    *next = NULL;
    
    
  }
  else if (! ((unsigned long)prev > (unsigned long) dseg_lo && !(*prev&1L) ) ) { /*if cannot coalescing */
    *temp1 = *temp1 - 1;  /* remove flag*/
    *temp2 = *temp1;      /*set size*/
    
    temp1++;  /*merge to front to the free list*/
    *temp1 = (unsigned long) fhead;
    fhead = temp1-1;
    temp1++;
    *temp1 = NULL;
    
    
    tmp = (blk) *(fhead+1); /*set previous pointer of old fhead*/
    if (tmp) {
      tmp = tmp + 2;
      *tmp = (unsigned long)fhead;
        }
    
  }
  
}
    
 
