/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include "memlib.h"
#include "malloc.h"
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

// this is the macro for trailers, ummm... word size is hardcoded
#define TRAILER(block) ((long)block + (long)((long)*block & (long)-2L) - 8)
// macro for blocksize
#define SIZE(block) (long)(*block & -2L)
#define BACK(block) (long *)*(long *)(block + 1L)
#define FORE(block) (long *)*(long *)(block + 2L)
#define BLOCKHEAD 2L

// OFFSET for pagesize          0L
#define TOTAL_LIST_NUM_OFFSET   1L
#define WILDERNESS_OFFSET       2L
#define INIT_LIST_NUM_OFFSET    3L
#define INIT_LIST_START_OFFSET  4L

#define INIT_MAX_CLASS         58L
// give an extra buffer, so list_start + max_class + 1
// would be good for TOTAL_OVERHEAD to be multiply of 8
// leave last word of header empty... (allocation mark for protection)
#define TOTAL_OVERHEAD         64L

long *get_list(long n);
long *get_block(long *list);
long *split_block(long *block, size_t req_size);
long *coalesce(long *pred, long *free, long *next);
long *remove_block(long *block);
//long *coalesce(long *old, long *new);

team_t team = {
    /* Team name to be displayed on webpage */
    "Why Me",
    /* First member full name */
    "Marcin O. Jeske",
    /* First member email address */
    "mjeske",
    /* Second member full name (leave blank if none) */
    "Andrew Kim",
    /* Second member email address (blank if none) */
    "andrew3"
};


int mm_init (void)
{
  long i;
  // create a storage variable for dseg_lo of type long *
  long *low;
  
     /* Run following if mm_init has not been called before */
    
    /* Allocate intial heap space */ 
    if (mem_sbrk(mem_pagesize()) == NULL) return -1;   
        
    /* Store the page size in dseg_lo */
    *(long*)dseg_lo = (long) mem_pagesize();
    // mem_pagesize returns in bytes
 
 
     /* Clean up previously used memory */
    // erase all the free list pointers
    for(i = 0; i < INIT_MAX_CLASS; i++)
      *(long *)((long *)dseg_lo + INIT_LIST_START_OFFSET + i) = NULL;
 
  /* Something is wrong */ 
  if (dseg_lo == NULL)
    return -1;  
  
  // Now we can grab dseg_lo... it won't change
  low = (long *)dseg_lo;

  // "allocate" the last word of header (protection)
  *(long *)(low + TOTAL_OVERHEAD - 1L) = 1L;

  /* Intialize word class structure */
  *(long *)(low + TOTAL_LIST_NUM_OFFSET) = INIT_MAX_CLASS;
  // set widerness pointer to end of overhead
  *(long *)(low + WILDERNESS_OFFSET) = (long *)(low + TOTAL_OVERHEAD);
  *(long *)(low + INIT_LIST_NUM_OFFSET) = INIT_MAX_CLASS;
  // set the first word of wilderness to the size of the wilderness
  *(long *)(low + TOTAL_OVERHEAD) = (mem_usage() - (TOTAL_OVERHEAD << 3L) + 1L) & -2L;
  // NOTE: add one above because mem_usage underreports the size...
  // initialize wilderness
   *(long *)(low + TOTAL_OVERHEAD + 1L) = low + WILDERNESS_OFFSET;
   *(long *)(low + TOTAL_OVERHEAD + 2L) = NULL;

  // success ???
  return 0;
}

void *mm_malloc (size_t size)
{
  // size is in bytes...
  long wild_size = 0; // size of wilderness
  long new_mem = 0; // how much new memory?
  long count = 1; // a counter
  // get desg_lo
  long *low = (long *)dseg_lo;
  // pointer to return
  long *alloc = NULL;
  // pointer for the extra
  long *scrap = NULL;
  // wilderness pointer
  long *wild = (long *)(low + WILDERNESS_OFFSET);
   
    // get the number of lists in the header
    int num_lists = *(low + TOTAL_LIST_NUM_OFFSET);
    // prepare list pointer
    long *cur_list = NULL;

    // Add the overhead for the block (BLOCKHEAD is in WORDS)
    size_t request = size + (BLOCKHEAD << 3);
    // Round up to next multiply of 8 words (64 bytes)
    size_t req_block = ((request + 63) >> 6) << 6;    
    // begin looking at right size class
    count = req_block;
    // count and req_block are both in bytes
    // Set cur_list to point to correct size class
    do
    {        
      // is potential list available
      if ( (count >> 6) < num_lists )
      {
        cur_list = get_list(count);
        // increment by 64 to find next list
        count += 64;//512;
      }
      else 
      {
	// check the big list

	// whoops, no more lists
	// grab from wilderness
	wild_size = *(long *)*wild;
	if ( wild_size > count )
	  {
	    // will fit
	    cur_list = wild;
	  } 
	else
	   { // ask for more memory for heap
	     // req_block - wilderness in multiply of page_size
             new_mem = wild_size;
	     // loop, adding pagesize each loop
	     while ( new_mem <= count ) new_mem += *low;
	     // call mem_sbrk with the requested mem in bytes
	     if (mem_sbrk(new_mem - wild_size) == NULL) return NULL;
	     // expand wilderness
             *(long *)*wild = new_mem & -2;
	     cur_list = wild;
	   }
         
      }
    } while (*cur_list == NULL);
    
    // Grab first available block...
    alloc = get_block(cur_list);
    // we now need to split the block, if necessary
    scrap = split_block(alloc, req_block);
      
    return alloc + 1L;
}

void mm_free (void *ptr)
{
  long *pred, *next;
  long *cur_list = NULL;
  // remember, they don't know they are a word behind
  long *freed = (long *)ptr - 1L;
  // set the block to unallocated - leading header
  *freed = *freed & -2L;
  // set the block to unallocated - trailing header
  *(long *)TRAILER(freed) = *freed;

  // COALESCE HERE
  pred = (long)freed - (long)(*(freed - 1L) & -2L);
  next = (long)freed + (long)(*freed & -2L);
  freed = coalesce( pred, freed, next);

  // which list do we add it to?
  if (!freed) return;
  else if ( TRAILER(freed) > *((long *)dseg_lo + WILDERNESS_OFFSET))
    {
      // we have coalesced wilderness
      *((long *)dseg_lo + WILDERNESS_OFFSET) = freed;
    }
  else if ( (*freed & -2L) < ((*((long *)dseg_lo + TOTAL_LIST_NUM_OFFSET)) << 6L) )
    {
      // one of our normal lists
      // ask for the list
       cur_list = get_list(*freed & -2L);
       // add freed to freed_list
      *(freed + 1L) = cur_list;
      *(freed + 2L) = *cur_list;
      if (*(freed + 2L) != NULL)
	{   // update the next block, if it exists
	  *((long *)*cur_list + 1L) = freed;
	}
      *cur_list = freed;
      // now added to list
    }
  else
    {
      // add to big list
      // IMPLEMENT THIS
      // mark block as allocated
      // set block to allocated - leading header
      *freed = *freed | 0x1;
      // set block to allocated - trailing header
      *(long *)TRAILER(freed) = *freed;
    }
  return;
}

long *get_list(long n)
{
  // get_list at this time receives n in bytes (but a multiply of 64) 
  long *low = (long *)dseg_lo;
  // divide n by 64 to get the class number
  n = n >> 6;
  //divide n by 512 to get class number
    //n = n >> 9;
  assert (n < INIT_MAX_CLASS );

  // this function returns the nth list address
  return (long *)(low + INIT_LIST_START_OFFSET + n);
}

long *get_block(long *list)
{
    long *low = (long *)dseg_lo;
    long *new_alloc = *list;
    
    // remove from list
    // move list pointer to next block
    *list = *((long *)*list + 2L);
    if (*list != NULL)
    {  // Set the back pointer of the next block, if it exists
       *((long *)*list + 1L) = list;
    }
    
    return new_alloc;
}

long *split_block(long *block, size_t req_size)
{
    // req_size <= size(block)
  // req_size is in bytes
    long *scrap = NULL;
    long *scrap_list = NULL;
    long scrap_size = 0;
    if ( req_size == (*block & -2L) )
    {
      // just right... but need to do some bookkeeping
    }
    else
    {  // must split...
      scrap_size = (*block & -2L) - req_size;
      // set new size for the allocated block
      *block = req_size | 1L;
      // set new pointer for scrap
      scrap = (long)block + (long)(*block & -2L);
      // set scrap to unallocated - leading header
      *scrap = scrap_size & -2L;
      // set scrap to unallocated - trailing header
      *(long *)TRAILER(scrap) = *scrap;

      // need to give back wilderness, iff we took it
      if ( *(block + 1L) == (long *)dseg_lo + WILDERNESS_OFFSET )
	{ // this was wild
          scrap_list = (long *)*(block + 1L);
	}
      else
	{
	  scrap_list = get_list(scrap_size);
	}
      // add scrap to scrap_list
      *(scrap + 1L) = scrap_list;
      *(scrap + 2L) = *scrap_list;
      if (*(scrap + 2L) != NULL)
	{   // update the next block, if it exists
	  *(long *)(*scrap_list + 1L) = scrap;
	}
      *scrap_list = scrap;
      // now added to list
    } 
      // mark block as allocated
      // set block to allocated - leading header
      *block = *block | 0x1;
      // set block to allocated - trailing header
      *(long *)TRAILER(block) = *block;
      
    return scrap;
}

long *coalesce(long *pred, long *free, long *next)
{
  long total_size;

  if ((((long)pred & (long)next) & 1L) != 0)
    { // no coalescing
    }
  else if (pred != free)
    {  
    if ((long)pred & 1L == 0)
      { // pred is free
	remove_block(pred);
	
	if ((long)next & 1L == 0)
	  { // pred and next are free
	    remove_block(next);
	    total_size = (*pred & -2L) + (*free & -2L) + (*next & -2L);
	    *pred = total_size;
	    *(long *)TRAILER(next) = total_size;
	    free = pred;
	}
	else
	  {
	    // only pred is free
	  total_size = SIZE(pred) + SIZE(free);
	  *pred = total_size;
	  *(long *)TRAILER(free) = total_size;
	  free = pred;
	  }
      }
    }
  else
    {
      // only next is free
      remove_block(next);
      total_size = SIZE(free) + SIZE(next);
      *free = total_size;
      *(long *)TRAILER(next) = total_size;
      // pred is already set
    }

return free;
}

long *remove_block(long *block)
{
  if ( BACK(block) >= (long *)dseg_lo + TOTAL_OVERHEAD )
    {
      // we are behind a block
      *(BACK(block) + 2L) = FORE(block);
      if (FORE(block)) *(FORE(block) + 1L) = BACK(block);
    }
   else if ( BACK(block) == NULL )
    {
      // we are in trouble
      return NULL;
    }
  else
    {
      // we are at top of list
      *BACK(block) = FORE(block);
      if (FORE(block)) *(FORE(block) + 1L) = BACK(block);
    }
  return block;
}

/*
long *coalesce(long *old, long *new)
{
  long total_size; // size of the two
  // check if old is free
  if ( 0 == (*old & 1L) )
   {
     // old is free
     // check if new is free
     if ( 0 == (*new & 1L) )
       {
	 //coalesce them...
	 
	 // remove old from its list
	 if ( *(old + 1L) < ((long)dseg_lo + (long)(TOTAL_OVERHEAD << 3)) )
	   {
	     // we are right after the head
	     if ( *(old + 1L) )
	       {
	       if (*(old + 1L) == *((long *)dseg_lo + WILDERNESS_OFFSET ))
 //	       if ( (long *)dseg_hi <= ((long)old + (long)(*old & -2L)) )
		 {
		   // this is wilderness
		   // set wilderness pointer to new
		   *((long *)dseg_lo + WILDERNESS_OFFSET ) = new;
		   // set back pointer to wilderness
		   *(long *)(new + 1L) = (long *)dseg_lo + WILDERNESS_OFFSET;
		    total_size = (*old & -2L) + (*new & -2L);
		   // set combined to unallocated - leading header
		   *new = total_size & -2L;
		   // set combined to unallocated - trailing header
		   *(long *)TRAILER(new) = total_size & -2L;
		   return NULL;
		 }
	       *(long *)*(old + 1L) = *(old + 2L);
	       
	     }
	     else return new;
	   }
	 else
	   { // we are after a normal block...
	     // move list pointer to next block
	     *((long *)*(old + 1L) + 2L) = *(old + 2L);
	   }	
	 if (*(old + 2L) != NULL)
	   {  // Set the back pointer of the next block, if it exists
	     *(long *)((long *)*(old + 2L) + 1L) = (long *)*(old + 1L);
	   }
	 // old has been removed from its list...
	 total_size = (*old & -2L) + (*new & -2L);
	 // now figure out which one is first
	 if (old < new)
	   {
	     // old is first, then new
	     // set combined to unallocated - leading header
	     *old = total_size & -2L;
	     // set combined to allocated - trailing header
	     *(long *)TRAILER(old) = total_size & -2L;
	     return old;
	   }
	 else
	   {
	     // new is first, then old
	     // set combined to unallocated - leading header
	     *new = total_size & -2L;
	     // set combined to unallocated - trailing header
	     *(long *)TRAILER(new) = total_size & -2L;
	     return new;
	   }
       }
     else return new;
   }
  else return new;
}
*/
