/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "vietnamese whores",
    /* First member full name */
    "Kittipitch Kuptavanich",
    /* First member email address */
    "kk",
    /* Second member full name (leave blank if none) */
    "Sooksan Panichpapiboon",
    /* Second member email address (blank if none) */
    "sooksan"
};


typedef unsigned long block;
block* freelist_head;
block *block_head;

int mm_init (void)
{
  block *next,*prev,*foot;
  
  /* get the first page */
  char *temp = mem_sbrk(mem_pagesize());
  
  /* if there is no memory left, return -1 */
  if(temp == NULL)
    return -1;

  /* the first 8 bytes keep track of free memory of the heap */
  *((block*)dseg_lo) = 1L + (block)mem_usage() - 8L;

  /* insert the page into the free list  w/ the size at header
     and footer */
  freelist_head = (block *) ((block) dseg_lo + 8L);
  *freelist_head = 1L + (block) mem_usage() - 8L;

  foot = ((block*)(dseg_hi -7));
 *foot = *freelist_head;

 /* initialize the next and pre pointer to NULL */
  next = freelist_head+1;
  prev = freelist_head+2;
  
  *next = NULL;
  *prev = NULL;
  
  return 0;
}

void *mm_malloc (size_t size)
{
  char *temp, *col_head, *new_page;
  unsigned long the_size, pagesize;
  block *next, *prev, *users_foot, *users_block, *foot;
  unsigned long diff, col_head_size;
  
  
  if((size & 7L) != 0)
    size = (((size >> 3L) + 1L) << 3L);
  
  size += 16;
  
  if (size < 32)
    size = 32;
  
  for(temp = (char*) freelist_head; temp != NULL;
      temp = (char*)(*((block*)(temp+8L)))){
    
    if (size <= *((block*) temp))
      break;
  }
  
  if(temp == NULL) { /* no space */
    do{

      /* allocate new page */
      new_page = mem_sbrk(mem_pagesize());
      
      if(new_page == NULL) /* not enough space in heap */
        return NULL;
      
      pagesize = mem_pagesize();
      *((block*)dseg_lo) += pagesize;
      
      /* link new page with the old free list */
      /* left block is free, need to coalesc */

      if((*((block*)(new_page-8L)) & 1L) == 0L) {
        
        col_head_size = *((block*)(new_page - 8L));
        col_head = (char *) (new_page - col_head_size);
        
        /* header of new coalesced block */
        *((block *) col_head) += pagesize;
        /* footer of new coalesced block */
        *((block *) (new_page +  pagesize - 8L)) = *((block*) col_head);
      }
      else{
        /* left block is not free,*/
        col_head = new_page;
        
        /* head of new page */
        *((block*) col_head) = pagesize;
        
        /* foot of new page */
        *((block*) (col_head + pagesize -8L)) = pagesize;

        /* next points to free list head */
        *((block*) (col_head + 8L)) = (block) freelist_head;

        /* prev points to NULL */
        *((block*) (col_head + 16L)) = NULL;
        
        /* prev of freelist_head points to new page */
        if(freelist_head)
          *((block*)(freelist_head +2L)) = (block) col_head;
        /* move free list head to new page */
        freelist_head = (block*) col_head;
        
        *((block*)(dseg_lo)) += pagesize;
      } 
        
    } while (*((block*) col_head) < size);

    temp = col_head;
    
  }

  the_size = *((block*) temp);

  /* if there is enough space */
  /* check if the free_head is the last mem block */

  next = (block *) *((block *)(temp + 8L));
  prev = (block *) *((block *)(temp + 16L));
  foot = (block *)(temp + the_size - 8L);
  
  diff = the_size - size;
  
  if(diff < 32) { /* no block splitting */
    
    /* the block to be allocated is freelist_head */
    
    if(prev)
      *(prev + 1) = (block) next;
    else
      freelist_head = next;  
    
    if (next)
      *(next + 2L) = (block) prev; /* set previous to NULL */
    
    
    /**((block *)(temp + 8L)) = NULL;
    *((block *)(temp + 16L)) = NULL;
    */
    *((block*) dseg_lo) -= the_size;
    *((block*) temp) = (the_size | 1L);
    *foot = (the_size | 1L);
    
    return (temp + 8L);
    
  }

  else { /* have to split the block */

    /* the memory that will be returned to the user */
    
    users_block = (block*) temp;
    users_foot = (block*) (temp + size - 8L);
        
    /* mark the flag */
    *users_block = (size | 1L);
    *users_foot = (size | 1L);
    
    /* new header and footer of what's left */
    *((block*) (temp + size)) = diff;
    *foot = diff;

    if(prev) 
      *(prev + 1L) = ((block)temp) + size;
    else 
      freelist_head = (block*)(temp+size);
    
    /* if the current block is not the last block */
    if(next)
      *(next + 2L) = ((block) temp) + size;

    *((block*)(temp + size + 8L))  = (block) next;
    *((block*)(temp + size + 16L)) = (block) prev;

    /* splice the user's block off the list */

    *(users_block + 1L) = NULL;
    *(users_block + 2L) = NULL;

    *((block*)(dseg_lo)) -= size;
  
    return (users_block + 1);
    
  }
  
}

void mm_free (void *ptr)
{
  
  char *temp = ((char*) ptr - 8L);

  unsigned long left_size = 0L;
  unsigned long curr_size = *((block*) temp);

  block *left_block, *right_block, *right_next, *right_prev;

  left_block = right_block = NULL;
  
  
  /* curr_size = ((curr_size >> 1L) << 1L);*/
  curr_size = (curr_size & ~1L); /* change the last bit to 0 */
  
  /*check left boundary */
  if (temp > (dseg_lo + 8L)){

    left_size = ((*((block*)(temp - 8L))) & ~7L);
    left_block = (block*) (temp - left_size);

  }
  
  /* check right boundary */
  if((temp + curr_size) < dseg_hi)
    right_block = (block*)(temp + curr_size);
  
  *((block*) temp) = curr_size;
  *((block*) (temp + curr_size - 8L)) = curr_size;
  
  /*check if the left block is free */
  if(left_block && ((*left_block & 1L) == 0L)){
    
    /*see if the right block is also free */
    if(right_block && ((*right_block & 1L) == 0L)){

      /* left and right blocks are free */
      /* get the right block out of the list */
      
      right_next = (block*)(*(right_block + 1L));
      right_prev = (block*)(*(right_block + 2L));
      
      if(right_prev)
        *(right_prev + 1L) = (block) right_next;
      else
        freelist_head = right_next;
      
      if(right_next)
        *(right_next + 2L) = (block) right_prev;
      
      /* coalescing all the three parts */
      *left_block += (curr_size + *right_block);
      *((block*)(((char*)right_block) + *right_block - 8L)) = *left_block;
      
      /* clean up the mess */
      *((block*)(temp - 8L)) = 0; /* clear footer of the left block */
      *((block*)(temp)) = 0; /* clear the current header */

      *((block*)(temp + curr_size - 8L)) = 0; /*clear the current footer */
      *((block*)(temp + curr_size)) = 0; /* clear header of the right block */
      
      *(right_block + 1L) = NULL; /* set next of right block to NULL */
      *(right_block + 2L) = NULL; /* set prev of right block to NULL */
      
    }
    
    else {  /* coalesce w/ left block only */
      
      *left_block += curr_size;
      *((block*)((char*) temp + curr_size - 8L)) = *left_block;

      /* clean up the mess */
      *((block*)(temp)) = 0; /* clear the current header */
      *((block*)(temp - 8L)) = 0; /* clear footer of the left block */
    }
  }
  else if ((right_block) && (((*right_block) & 1L) == 0L)){
    /* coalesce with the right block only */

    right_next = (block*) (*(right_block + 1L));
    right_prev = (block*) (*(right_block + 2L));

    /* if the right block is not the free list head */
    if(right_prev)
      *(right_prev  + 1L) = (block) right_next;
    else
      freelist_head = right_next;

    /* if the right block is not the end of the list */
    if(right_next)
      *(right_next + 2L) = (block) right_prev;

    /* clean up the pointer mess */
    *(right_block + 1L) = NULL; /* set next of right block to NULL */
    *(right_block + 2L) = NULL; /* set prev of right block to NULL */
    
    /* then coalesce the block */
    *((block*) temp) += *right_block;
    *((block*) (((char*) right_block) + *right_block - 8L)) = *((block*) temp);

    /* clean up size mess */
    *(right_block) = 0; /* clear header of the right block */
    *(right_block - 1L) = 0; /* clear footer of the left block */
    
    /* insert the thing into the list */
    *((block*) (temp + 8L)) = (block) freelist_head;
    *((block*)(temp +  16L)) = NULL;

    if(freelist_head)
      *(freelist_head + 2L) = (block) temp;
    
    freelist_head = (block*) temp;

  }
  else{
    
    *((block*) (temp + 8L)) = (block) freelist_head; /* next = head */
    *((block*) (temp + 16L)) = NULL; /* prev = NULL */

    if(freelist_head)
      *(freelist_head + 2L) = (block) temp;

    freelist_head = (block*) temp;
  }
  
  *((block*)dseg_lo) += *((block*) temp);
  
   
}
