/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "puh",
    /* First member full name */
    "Gabriel Schneider",
    /* First member email address */
    "gss",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};




int mm_init (void)
{

  //for starters, if seg_lo>seg_hi, 
  //make seg_hi 16 higher than seg_lo
  long int* p=(long int*)dseg_lo;
  if (dseg_lo>=dseg_hi)
    {
      mem_sbrk(16);
    }
  *p=2;
  return -1;
}

void *mm_malloc (size_t size)
{

  //first-fit
  //**note-  this code fails in the coelescing trace
  //and is remarkably slow** 

  //rounds size up to multiple of 8
  size_t my_size=((size+7)&-8);

  //my_size/8 rounded up, make sure it's a factor of 2
  size_t pointer_size=((((my_size)>>3)+2)&-2);
  size_t newsize;
  size_t oldsize;
  long int* temp;
  long int* p=(long int*)dseg_lo;

  //search for 1st valid address
  while (p<(long int*)dseg_hi)
    {
      if ((*p&1) || (*p>pointer_size))
	p=p+(*p&-2);
      else break;
    }

  //if there's not enough memory free, free some more
  if (!(*p&1) || (*p<pointer_size))
    {
      //num of bytes plus extra for info
      temp=mem_sbrk(my_size+16);
      if (temp==NULL)
	{	
	  printf("returning NULL - sbrk=NULL\n");
	  return NULL;
	}

      //set value of p to distance betweed seg_hi & p
      //rounded to 2
      *p=((long int*)dseg_hi-p)&-2;

    }
 
  //if we're good to go
  if (*p>=pointer_size)
    {
      newsize=pointer_size;
 
     //needed for coelescing
      oldsize=*p&-2;

      //set p to newsize, make low bit 1 to signify the chunk is taken
      *p=newsize|1;

      //if there's free memory left over, we need to mark it as free
      if ((newsize&-2)<oldsize)
	{
	  //this one line makes me go puh
	  *(p+newsize)=(oldsize-newsize+1)&-2;

	  //this shouldn't be needed, but the above line doesn't work
	   *(p+newsize)=0;
	}

 
      //return a pointer to the first free allocated memory space
      return p+1;

    }

  //this should never happen (hopefully)
  printf("returning NULL - not big enough\n");
  return NULL;
}

void mm_free (void *ptr)
{
  
    long int* p=(void *)ptr;
    long int* next;

    //mark p as free
    *p=*p-1;

    //if (p+*p) is free, need to merge the blocks into one
    next=p+*p;
    if ((*next&1)==0)
      *p=*p+*next;
}

