/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
  "Colition for the ethical treatment of undergrads ",
    /* First member full name */
  "Tim Howe",
    /* First member email address */
  "th3i",
    /* Second member full name (leave blank if none) */
  "Dan Rodriguez",
    /* Second member email address (blank if none) */
  "drr2"
};

/*this is teh list head stored in the beginning of the heap
  Each block of data has an 8-byte header the contains it's size
*/
typedef struct control_list {
  struct control_list * next;
} control_list;   /* to be stored in the beginning of the heap */

/* init checks to see if there is enough space avaliable and 
   if not creates it .  It then 0's out all the avaliable space
*/
int mm_init (void) {
  if ((long)dseg_hi - (long)dseg_lo < 8192){
  	mem_sbrk(8192);
  }
  bzero((void *)dseg_lo, dseg_hi - dseg_lo); 
  return 0;
}

void *mm_malloc (size_t size) {
 
  control_list ** start = (control_list **)dseg_lo;
  long ret_val;
  long real_size = size + 8L ;
  int x,y;

  /* find teh correct power of 2 to determine which 
     array index to use */ 
  for (x = 0 ; ((1L << x) * 8) < real_size ; x++);
  
  /* if ther isn't already a free block of the right size,
     make suer one can be created, then create one */ 
  if(!start[x]) {
    /* to avoid using more memory, if there is a block one
       larger, use it */
    if (start[x+1]){
	 x++;
    } else {
	if (((long)dseg_hi - (long)dseg_lo) + (8L << x) > (1L << 24)){
		return NULL;
	}
    	start[x] = mem_sbrk(8L << x);
    	start[x]->next = NULL;
    }
  }
  /* return teh address to the block after taking care of
    bookkeeping */
  ret_val = (long)(start[x]);  
  start[x] = start[x]->next;
  ((long *)ret_val)[0] = x;
  return (char *)ret_val + 8L;
}

/* free first makes sure the block is valid (i.e. it lies within our
   region ) and then frees it and takes care of bookkeeping */
void mm_free (void *ptr) {
  if (((long)ptr < (long)dseg_lo) || ((long)ptr > (long)dseg_hi)){
    return;
  } else {
    long size = ((long *)((long)ptr - 8L))[0];
    control_list * start = (control_list *)dseg_lo; 
    ((control_list *)((long)ptr - 8L))->next = start[size].next;
    start[size].next = (control_list *)((long)ptr - 8L);
  }
}
