/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    " /(^o^)/  buchu! \\(^o^)\\ ",
    /* First member full name */
    "Taiseke Hirako",
    /* First member email address */
    "hirako",
    /* Second member full name (leave blank if none) */
    "Asako Toda",
    /* Second member email address (blank if none) */
    "atoda"
};


const long WORD=8 ;
long* p;


//call first  WORD as flag-WORD

//block contain WORDs for data and 1 flag-WORD
//Assume that mem_pagenum is allined by WORD


//alligned size to WORD size and return equivalent number of WORD to include 
//the size
long numWords(long size)
{
  long up = ((size%WORD) ? 1:0);
   return size/WORD + up;
}

//check whether this is allocate
int isAllocated(long* ptr)
{
  if((int)(*ptr & 1)==1) return 1;
  else return 0;
}

//allocate word_num WORD-blocks from p, if there is some blocks left
//put flag 
void setAllocate(long* ptr, long word_num)
{
  long freewords=0;// empty WORDs
 
  //if this block is already allocated, error.
  if(*ptr & 1)
  {
    printf("already allocated!\n");
  }

 //if there is fragmentaion, free unused WORDs. 
  if((*ptr>>1)>word_num)
    {
      freewords = (*ptr>>1)- word_num;    
      *(ptr + word_num)=freewords<<1;// free rest of WORDsprintf()
      //printf("freewords = %lx\n",freewords);    
    }

  *ptr =  ((word_num)<<1) | 1L;//allocate word_num WORDs

}


//get pagesize area and mark as free. 
//if can not get the area, return 0
//Otherwise -1
int mm_init (void)
{
 p=(long*)dseg_lo;//set p as dseg_lo 
 //printf("lo = %lx\n",(long)dseg_lo);
 //printf("hi = %lx\n",(long)dseg_hi);
 if( mem_sbrk(mem_pagesize()) == NULL)return -1;

 
 *p=(mem_pagesize()/WORD)<<1;
 
 
 //printf("hi-after = %lx\n",(long)dseg_hi);
return 0; 
}

//jump to next block.
//return pointer to next block
//if current block is the last block in heap, return 0;

void *mm_malloc (size_t size)
{
  long word_block_num;

  //printf("#### mallocing %lx\n", (long)size);
  p = (long*)dseg_lo;

  //get block number we need for 'size' data + 1 for flag-block.
  word_block_num = numWords(size)+1;//+1 for flag

  if(size==0) printf("malloc size 0?\n"); 
  
  //look for free space which is larger than word_block_num
  //if the current block is the last block in heap, we need get new
  //heap area. 
  while( ( p< (long*)dseg_hi) && //not passed end
	 ( (*p&1) || //already allocated
	 ( (*p>>1)<word_block_num) ) )//too small

	 {
	   p = p + (*p>>1);
	 }


  //if there is no space till the end of heap, get new heap are and allocate word_block_num.
  //if heap can not get area any more, error.
  //return the pointer which point the biginning of data block not flag-block.
    if(p >= (long*)dseg_hi )
    {
      long page_block;
      int pages;
      long up;
      
      //printf("  growing heap\n");
      page_block = mem_pagesize()/WORD;
      up = ((word_block_num% page_block) ? 1:0);
      pages = (int)(word_block_num/page_block + up);
      
      //get area of page_block*mem_pagesize()
      mem_sbrk(pages*mem_pagesize());
      *p=((long)pages*page_block)<<1;
    }  
    
    //find the free area to put the data, so let's allocate.
    //return the pointer which point the biginning of data block not flag-block.
    setAllocate(p,word_block_num);

    //printf("--- finished malloc\n");
    return (p+1);    
}

//set flag as free.
//if next block is also free, coalscene them
void mm_free (void *ptr)
{
  //printf("### freeing\n");
 p =(long*) ptr-1;
  //free the flag of ptr
 *p = *p &-2;

 //if next area is free, coalscene them
 if( (*(p+(*p>>1))&1L) ==0)
    {
      long nextsize = *(p+(*p>>1))>>1;

 //set the flag-WORD of the next block as NULL; 
      *(p + (*p>>1))=NULL;
      *p= ((*p>>1)+ nextsize)<<1;
    }

}
