/* zaidi */

/*
 *  Asad Ali Zaidi
 *  zaidi@andrew.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "P=NP",
    /* First member full name */
    "Asad Ali Zaidi",
    /* First member email address */
    "zaidi@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* General comments: 
 */

#define PAGESIZE mem_pagesize()  /* just a shortcut                  */
#define wdsz 8L                  /* word size                        */
#define MIN  16L                 /* minimum allocable block size     */

long *curr;                      /* ptr to first free block (if any) */

int mm_init (void) {
  /* If there is already a heap, clear current memory by resetting curr.
     Otherwise, allocate the minimum sized block to hold curr. 
     Assuming dseg_lo is 8 byte aligned. */
  if(dseg_hi > dseg_lo)
    curr = (long *)mem_sbrk(MIN);
  else
    curr = (long *)dseg_lo;

  /* Set curr to indicate all current memory is empty. */
  *curr = (long)dseg_hi+1L;

  return 0;
}

void *mm_malloc (size_t size) {
  long *i = NULL;
  long *ptr = NULL;
  long sizef = 0L;
  long tmp, tmp2;

  /* size must be a power of 2 >= MIN */
  if(size <= MIN) size = MIN;
  else {
    tmp = 4L;
    while(tmp) {
      tmp2 = 1L<<tmp;
      if( tmp2 >= size) {
	size = tmp2;
	tmp = 0L;
      } else tmp++;
    }
  }
  
  for(i = curr; 
      !ptr && i < (long *)dseg_hi; 
      i = (long *) (*i&~1L)) { /* Find the first fit. */
    if(!(*i&0x1L)) { /* this block is unused */
      sizef = *i - (long)i - wdsz;
      if(sizef >= size) ptr = i; /* but is it >= size? */
    }
  }

  if(!ptr) { /* No free block>=size found, so must allocate one. */
    ptr = (long *)((long)dseg_hi + 1L);
    if(!mem_sbrk(wdsz+size)) return NULL;
    *ptr = ((long)dseg_hi + 1L);
     sizef = *ptr-(long)ptr-wdsz;
  }
  
  if(sizef > size) { /* split block */
    tmp   = *ptr;
    *ptr  = (long)ptr+wdsz+size;
    i     = (long *)(*ptr&~1L);
    *i    = tmp;
  }
  
  if(curr == ptr) { /* Must find next free block. */
    curr = (long *)*ptr;
    while( (curr<(long *)dseg_hi) && (*curr&0x1L)) 
      curr = (long *)(*curr&~1L);
  }
  
  *ptr |= 0x1L; /* mark it as alloc'ed */
  
  /* Add wdsz to ptr to return the beginning to data area.
     The first word in the block is a pointer to the next block. */
  return (void *) ((long)ptr + wdsz);
}

void mm_free (void *ptr2) {
  long *tmp, *i;
  long *ptr = (long *) ((long)ptr2-wdsz);   /* Location of meta-data    */

  if(ptr < (long *)dseg_lo || ptr > (long *)dseg_hi)
    return;                                 /* Is ptr within bounds?     */
  
  *ptr &= ~1L;                              /* Mark the block as free.   */
  tmp = (long *) *ptr;                      /* Find the next block.      */
  if(tmp < (long *)dseg_hi && !(*tmp&0x1L)) /* If next is free ...       */
    *ptr = *tmp;                            /* ...coalesce with next     */

                                            /* Find the previous block.  */
  if(ptr<curr) i = (long *)dseg_lo;         /* Choose the start pos'n    */
  else         i = curr;                    /* to minimize time.         */
  for(; i < ptr; i = (long *)(*i&~1L)) 
    tmp = i;
  if(!(*tmp&0x1L))                          /* If prev is free...        */
    *tmp = *ptr;                            /* ...coalesce with prev     */
  
  
  if(ptr < curr) curr = ptr;                /* Reset curr if we need to. */
}
