/* zaidi */

/*
 *  Asad Ali Zaidi
 *  zaidi@andrew.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "P=NP",
    /* First member full name */
    "Asad Ali Zaidi",
    /* First member email address */
    "zaidi@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

#define PAGESIZE mem_pagesize()
#define ULI unsigned long int
#define wdsz 8L
#define MIN 16L

long *curr;

int mm_init (void) {
  if( dseg_hi > dseg_lo)
    curr = (long *)mem_sbrk(2*wdsz);
  else
    curr = (long *)dseg_lo;

  *curr = (long)dseg_hi+1L;

  return 0;
}

void *mm_malloc (size_t size) {
  long *i = NULL;
  long *ptr = NULL;
  long sizef = 0L;
  long tmp, tmp2;

  /* size must be a multiple of eight. */
  size = ((size + 7L)>>3L)<<3L;
  if(size < MIN) size = MIN;

  tmp = 1L;
  while(tmp) {
    tmp += 1L;
    tmp2 = 1L<<tmp;;
    if( tmp2 >= size) {
      size = tmp2;
      tmp = 0L;
    }
  }
  
   for(i = ptr = curr; 
       !sizef && i < (long *)dseg_hi; 
       i = (long *) (*i&~1L)) {
     if(!(*i&0x1L)) {
       sizef = *i - (long)i - wdsz;
       if(sizef < size) sizef = 0L;
     }
     ptr = i;
   }
   
   if(!sizef) {
     if(*ptr & 0x1L)
       ptr = (long *)((long)dseg_hi+1L);
     
     i = mem_sbrk(wdsz+size);
     if(!i) return NULL;
     *ptr = (long)dseg_hi + 1L;
     sizef = *ptr-(long)ptr-wdsz;
   }
   
   if(sizef > size) { /* split block */
     tmp   = *ptr;
     *ptr  = (long)ptr+wdsz+size;
     i     = (long *)(*ptr&~1L);
     *i    = tmp;
   }
   
   if(curr == ptr) {
     curr = (long *)*ptr;
     while( (curr<(long *)dseg_hi) && (*curr&0x1L)) 
       curr = (long *)(*curr&~1L);
   }
   
   *ptr |= 0x1L; /* mark it as alloc'ed */
   
   return (void *) ((long)ptr + wdsz);
}

void mm_free (void *ptr2) {
  long *i;
  long *tmp;
  long *ptr = (long *) ((long)ptr2-wdsz);

  if(ptr < (long *)dseg_lo || ptr > (long *)dseg_hi)
    return;

  *ptr &= ~1L;
  tmp = (long *) *ptr;
  if(tmp < (long *)dseg_hi && !(*tmp&0x1L))
    *ptr = *tmp;

  for(i=(long *)dseg_lo; i < ptr; i = (long *)(*i&~1L))
    tmp = i;
  if(!(*tmp&0x1L))
    *tmp = *ptr;

  if(ptr < curr) curr = ptr;
}
