/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define INPTR(x) (*((long *)dseg_lo + x))
#define INPTOLD(x) *((long *) (dseg_lo + 8*x))   //shortcut for heap access
#define NUMLISTS 62

team_t team = {
    /* Team name to be displayed on webpage */
    "Yeah, baby!!!",
    /* First member full name */
    "Yevgeny M. Bokk",
    /* First member email address */
    "ymb",
    /* Second member full name (leave blank if none) */
    "Elaine Y. Kwong",
    /* Second member email address (blank if none) */
    "eyk"
};




void rearrangefree (unsigned long block,unsigned long len)
{
    unsigned long tlen,parent,child,tblock,listhd;  

    /* TEMP */
    long i;
    unsigned long crap;
    /* t */
    

    /*first we use coalescing to assemble given block with neighboring blocks*/
    //coalesce down:
    //printf("Entered rearrangefree, the arguments are: len=%d, block=%d\n",len,block);
     if (len==0)
	return;
    
    
    while (block>NUMLISTS+2)
    {
	//  printf("Coalescing down...\n");
	
	tlen=INPTR(block-1);
	if (tlen & 1)        //odd
	    break;           //allocated
	len+=tlen;
	block-=tlen;
	if (tlen<4)
	    continue;
	
	//delete the block from the list:
	parent=INPTR(block+1);
	child=INPTR(block+2);
	INPTR(parent+2)=child;
	if (INPTR(child))
	    INPTR(child+1)=parent;
    }
    
    //coalesce up:
    tblock=block+len;    
    while (tblock<(mem_usage()+1)/8)
    {
	//printf("Coalescing up...\n");
       
	tlen=INPTR(tblock);
	if (tlen & 1)        //odd
	    break;           //allocated
	len+=tlen;

        //delete the block from the list:
	
	if (tlen>=4)	
	{	   
	    parent=INPTR(tblock+1);
	    child=INPTR(tblock+2);
	    INPTR(parent+2)=child;
	    if (INPTR(child))
		INPTR(child+1)=parent;
	}	
	tblock+=tlen;
    }   
    //printf("Done coalescing, len is: %d\n",len);
    //printf("About to start breaking apart, the block is %d\n",block);
    
    //now block contains beginning of the block and len contains its length
    //we will now break block up into pieces where each piece is a power of 2
    while (len>=4)
    {
	// printf("Breaking apart...\n");
	
	tlen=4;   
	listhd=2;
	//printf ("Entering loop:  Tlen is %d len is %d\n",tlen,len);
	
	while (tlen<len) //calculate the appropriate list
	{
            //printf("Find the list\n");
	    
	    tlen = tlen * 2;
	    listhd++;
	}
	if (tlen!=len)
	{
	    tlen  = tlen >> 1;
	    listhd--;
	}
	
	if (block<64)
	{
	    //  printf("Fuck! Fuck! Fuck!\n");
	    exit(0);
	}
	
	//format the block and insert it into the list
	INPTR(block)=tlen;
	//printf("First attempt to access memory\n");
	//printf("Warning:  this is the source of your troubles:\n");
	//printf("Listhd is %d ",listhd);
	
	INPTR(block+1)=listhd-2;
	INPTR(block+2)=INPTR(listhd);
	INPTR(block+tlen-1)=tlen;
	child=INPTR(listhd);
	if (child)
	    INPTR(child+1)=block;
	INPTR(listhd)=block;

	//printf("child is : %d ",child);
	//printf("block+1 contains: %d ",INPTR(block+1));
	//printf("block+2 contains: %d ",INPTR(block+2));

	/* temp stuff */
	//printf("the list are as follows:\n");
	/* for (i=2;i<22;i++)
	{
	    crap=INPTR(i);
	    printf("%d:%d ",i,crap);
	}
	printf("\n");
	printf("block size is %d\n",block); */
    
	
	//move on to the next block
	block+=tlen;
	//printf("Something's, going on:  tlen is %d, len is %d\n",tlen,len);
	
	len-=tlen;
    }

    //special case: a free block of two words
    if (len==2)
    {
	//printf("oh, no\n");
	
	INPTR(block)=2;
	INPTR(block+1)=2;
    }
    //printf("I think i'm done here\n");
    /* temp stuff */
    //printf("the list are as follows:\n*********** ");
    /* for (i=2;i<22;i++)
    {
	crap=INPTR(i);
	//printf("%d:%d ",i,INPTR(crap));
    }
    printf("\n");
      end temp */

    return;
}



int mm_init (void)
{
    long i;
    unsigned long block,psize,len;
    psize=mem_pagesize()/8;   

    //printf("Starting up\n");
    
    if (mem_usage()!=-1)
	return -1;             //what the fuck?
    if (!mem_sbrk(psize*8))
	return -1;             //could not allocate a single page
    for (i=0;i<NUMLISTS+2;i++) //reset all the lists to NOTALLOCATED 
	INPTR(i)=0;
    block=NUMLISTS+2;          //the beginning of the actual memory space
    len=psize-NUMLISTS-2;
    rearrangefree(block,len);    
    
    //printf("Done with mm_init\n");
    //exit(0);    

    return 0;      
}


void *mm_malloc (size_t size)
{ 
    unsigned long listhd,initlisthd,block,nextblock;
    unsigned long len,actsize,psize,tempsize;     
    void *retval;    

    //printf("Entering malloc\n");
    
    actsize=((unsigned long) size)/8;       //convert to a word
    if (actsize*8 != (unsigned long) size)  //roundup
	actsize++;
    actsize+=2;   //add space for header and footer                    
    if (actsize<4) //minimum allocated space must be 4 words
	actsize=4;    
    if (actsize & 1) //allocated space must have even number of words
	actsize++;  
  
    //printf("Actsize is %d\n",actsize);
    
    tempsize=4;    
    initlisthd=2;
    while (tempsize<actsize) //calculate the appropriate list
    {
	tempsize = tempsize << 1;
	initlisthd++;
    }
    /* initlisthd -= 2;*/
    listhd=initlisthd;    
    while (INPTR(listhd)==0 && listhd<(NUMLISTS+2))
	listhd++;
    if (listhd==NUMLISTS+2)
    {
	//allocate another page
	//printf("Need more memory\n");
	
	block=(mem_usage()+1)/8; //beginning of the page to be allocated
	psize=mem_pagesize()/8;	
	len=actsize/psize*psize;      //space to be allocated
	if (len != actsize) //if not a multiple of number of pages
	    len+=psize;     //add another page
	if (!mem_sbrk(len*8))
	    return NULL;      //coulnd't allocate enough memory	
    }
    
    else
    { 
	//delete the first free block from the current free list	
	//printf("Done't need more memory\n");
	
	block=INPTR(listhd);      //the block to be removed
	len=INPTR(block);	  //the length of the block   
	//printf("Length is currently: %d\n",len);
	//printf("List head is: %d\n",listhd);
	
	nextblock=INPTR(block+2); //the next block on the list
	if (nextblock)            //if exists
	    INPTR(nextblock+1)=listhd-2; //set parent to NULL	    
	INPTR(listhd)=nextblock;  //update the list     
    }
    
	//allocate the block
	INPTR(block)=actsize | 1; // | 1 is needed to set low bit to 1
	INPTR(block+actsize-1)=actsize |1;	
	retval=dseg_lo+8*(block+1); //the pointer to be returned
	block+=actsize;
	len-=actsize;
	
	//printf("About to call rearrange free, len is %d\n",len);
	
	//now we must coalesce this block with its neighbors
	//and then split it into pieces
	rearrangefree(block,len);
	//printf("Exiting malloc\n");
	return retval;	
}

void mm_free (void *ptr)
{
    unsigned long block,len;
    //printf("Entering free\n");
     
    block=(unsigned long) ptr-(unsigned long) dseg_lo;
    block=block/8-1;
    len=INPTR(block)-1; //-1 due to accomodate for the rigthmost bit
    rearrangefree(block,len); 
    return;    
}

