/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define RECORD_SIZE ((int)(sizeof(struct record)))
#define FREE_SIZE ((int)(sizeof(struct freeblock)))
#define CHUNK_SIZE ((int)(sizeof(struct chunk)))


#define ptr2int(ptr) ((unsigned long)ptr)
#define align(i) (((i+7)/8)*8)
#define firstblock ((struct freeblock *)((char*)dseg_lo-2*sizeof(void*)))
#define endptr ((struct freeblock *)((char *)dseg_hi+1))
#define firstfree (firstblock->nextfree)
#define prevptr(x) ((struct freeblock*)((struct freeblock*)((char*)(x)-sizeof(void*)))->nextrec)
#define FREE ((struct freeblock *)1L)
struct record {
  struct record *prev;
  //struct freeblock *free;
  struct record *next;
  //s;
};

struct freeblock {
  struct freeblock *prevrec;
  struct record *nextrec;
  struct freeblock *nextfree;
  struct freeblock *prevfree;
};

/*struct freeblock {
  struct record *nextrec;
  struct freeblock *nextfree;
  struct freeblock *prevfree;
  //struct record *nextrec;
  struct freeblock *ptr2me;
  };*/
  
//int req=0, alo=0;

team_t team = {
    /* Team name to be displayed on webpage */
    "^C",
    /* First member full name */
    "Lenza H. McElrath",
    /* First member email address */
    "lenza",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

int mm_init (void) {
  //struct freeblock *first = (struct freeblock *)dseg_lo;
  
  //printf("This is some output %d  %d\n",req,alo);
  //bzero(dseg_lo,10000000);
  mem_sbrk(FREE_SIZE);
  firstblock->nextfree=(struct freeblock*)((char *)firstblock + 3*sizeof(void*));
  //firstblock->prevfree=NULL;
  firstblock->nextfree->nextfree = NULL; //(struct freeblock*)((char *)dseg_hi+1);
  //firstblock->nextfree->prevfree = firstblock;
  firstblock->nextfree->nextrec = endptr;
  //firstblock->nextfree->ptr2me = firstblock->nextfree;
  //first->nextfree = 1;
  return 0;
}

//change a freeblock into an allocated block
inline void removefree(struct freeblock *foo) {
  foo->nextfree->prevfree = foo->prevfree;
  foo->prevfree->nextfree = foo->nextfree;

  foo->nextrec->prev = NULL;
  //foo->nextrec= ptr2int(foo->nextrec)|1L;
  
  //prevptr(foo->nextrec) = NULL;
  //((struct record *)foo)->next = foo->nextrec;
}


inline void *allocate (struct freeblock *begin, struct record *end, size_t size) {
  struct freeblock *newfree = (struct freeblock *)((char *)begin + size), *foo;
  int tmp;
  //fprintf(stderr,"Allocating %d bytes from 0x%p to 0x%p %p\n\n",size,begin,end,begin->prevfree);
  //begin->nextrec = (struct record *)newfree;
  
  end->prev = newfree;
  newfree->prevrec = NULL;

  newfree->nextrec = end;
  newfree->prevfree = begin->prevfree;
  newfree->prevfree->nextfree = newfree;

  newfree->nextfree = begin->nextfree;
  newfree->nextfree->prevfree = newfree;

  ((struct record *)begin)->next = ptr2int(newfree);//|1L;
  return (void *)((char *)begin+RECORD_SIZE);
}

void *mm_malloc (size_t size) {
  struct record *nextrec;
  struct freeblock *nextfree, *curptr, *prev=firstblock,*foo;
  int freespace, realsize = align(size)+RECORD_SIZE;

  if(realsize==464) realsize=528; else
  if(realsize<FREE_SIZE) realsize=FREE_SIZE;
  //fprintf(stderr, "Malloc of %d bytes requested max 0x%p...\n", size, dseg_hi);
  //if(firstfree==NULL) 
  for(curptr=firstfree; (nextfree=curptr->nextfree); curptr=nextfree) {    
    nextrec = curptr->nextrec;
 
    //calculate free space here
    freespace = (ptr2int(nextrec)-ptr2int(curptr))-realsize;
  
    //either just stick the item here, or add a free block after
    //the data if there is enough space
    if(freespace >= 0) { 
      if(freespace >= FREE_SIZE) return allocate(curptr, nextrec, realsize);  
      //fprintf(stderr,"Placing at 0x%p\n\n",curptr);
      removefree(curptr);
      return ((char *)curptr + RECORD_SIZE);
    }
    prev = curptr;
  }  //End for loop
 
  
  //go to the footer record, and find the freespace there
  //nextrec = curptr->nextrec;
  freespace = realsize-((char*)endptr-(char*)curptr)+FREE_SIZE;
    
  //if we have enough or can allocate enough memory, add it here
  if(freespace<=0 || mem_sbrk(freespace)) {
     nextfree = (char*)curptr+realsize;

    nextfree->prevrec = NULL;
    nextfree->nextrec = endptr;

    nextfree->nextfree = NULL;
    //nextfree->prevfree = curptr->prevfree;


    //curptr->prevfree;
    prev->nextfree = nextfree;
    //fprintf("first %p  next: %p  %p",fi
    ((struct record *)curptr)->next = ptr2int(nextfree);//|1L;
    //fprintf(stderr,"Allocating more at 0x%p\n\n", curptr);
    return (char*)curptr+RECORD_SIZE;
  } 
  
  //otherwise it is all over
  return NULL;
}

void mm_free (void *ptr) {
  struct freeblock *free , *foo = (struct freeblock *)((char *)ptr-RECORD_SIZE);

  //struct chunk* foo = (char*)ptr-RECORD_SIZE;
  //fprintf(stderr,"Free requested at at 0x%p\n", foo);
  //if((ptr2int(foo->nextrec)&1L)) fprintf(stderr, "Something is wrong.\n");
  //foo->nextrec=ptr2int(foo->nextrec)-1;
  //fprintf(stderr,"nextrec: %p\n",foo->nextrec);

  if((free=(foo->prevrec))) {
    free->nextrec = foo->nextrec;
    if(foo=free->nextrec->next->prev) {
      free->nextrec=foo->nextrec;
      foo->nextfree->prevfree = foo->prevfree;
      foo->prevfree->nextfree = foo->nextfree;
      //removefree(foo);
    } 
    foo = free;
  } else if((free=foo->nextrec->next->prev)) {
    foo->nextrec=free->nextrec;
    foo->nextfree=free->nextfree;
    foo->prevfree=free->prevfree;

    foo->nextfree->prevfree = foo;
    foo->prevfree->nextfree = foo;
  } else  {
    foo->nextfree = firstblock->nextfree;
    foo->prevfree = firstblock;
    firstblock->nextfree = foo;
    foo->nextfree->prevfree=foo;
  }

  foo->nextrec->prev = foo; // = foo; else foo->nextrec=NULL;
}
