/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Goo",
    /* First member full name */
    "Timothy Alper",
    /* First member email address */
    "taa@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Dave Fry",
    /* Second member email address (blank if none) */
    "fry@andrew.cmu.edu"
};

#define PAGE_SIZE 8192L
/* points to beginning of allocatable memory */
#define MY_HEAP ((long int)(dseg_lo + PAGE_SIZE))
/* Returns Total depth of tree */
#define TREE_DEPTH (*((long int *)(dseg_lo + 12*8))) 
/* Returns Number of pages of allocatable memory */
#define NUM_PAGES (*((long int *)(dseg_lo + 13*8)))
/* Returns Position in tree of first item in freelist at height */
#define FREE_LIST(height) ((long int)(*((int *)(dseg_lo + 4*(height)))))
/* Returns Reference bytes. */
#define REF_BYTES(depth) (*((int *)(MY_HEAP + (FREE_LIST(depth) * 8L) + 4L)))
/* Returns Pointer to Allocatable memory in a block */
#define MEM_POINTER(levels) (MY_HEAP + (FREE_LIST(levels) * 8L) + 8L)

int mm_init (void)
{
  long int mem_used = mem_usage();
  int i;

  for (i = 0; i < 12; i++)
    {
      /* set all of our freelist pointers to NULL (-1) */
      *((long int *)(dseg_lo + 8*i)) = -1; 
    }


  /* first time through, nothing's been allocated before, set up heap stuff */
  if (mem_used == -1)
    {
      if (!mem_sbrk(3L * PAGE_SIZE))  /* 3 pages, 1 for our use, 1 for 4 byte overflow */
	return -1;
      TREE_DEPTH = 10;
      NUM_PAGES = 1;
    }

  /* we've been here before, already have heap stuff set up */
  else
    {
      int num_pages_used = (mem_used + 1) / PAGE_SIZE - 2;
      int num_divides = 0;
      NUM_PAGES = (long int)num_pages_used;

      while (num_pages_used > 1)
	{
	  num_pages_used /= 2;
	  num_divides++;
	}
      
      TREE_DEPTH = num_divides + 10;    
     
    }

  /* set up block with position 0 and proper height */
  *((int *)(MY_HEAP + 4)) = TREE_DEPTH;
  *((int *)(MY_HEAP + 8)) = -1;  /* set pointer to NULL */
  FREE_LIST(TREE_DEPTH) = 0;  /* set freelist to point to block */
  


  /*  printf("mem_used %i\n", mem_used);
      
      printf("dseg_lo %i \ndseg_hi %i\n",dseg_lo,dseg_hi);
      mem_sbrk(mem_pagesize());
      printf("dseg_lo %i \ndseg_hi %i\n",dseg_lo,dseg_hi);
      printf("pagesize %i\n",mem_pagesize());
      printf("dmem_used again %i\n", mem_usage());
  */

     return 0;
}

void *mm_malloc (size_t size)
{

  long int factor = 8;  /* smallest chunk size available, + 4 */
  int chunk_depth = 0;
  int i;
  int insert_into = -1;
  int buddy_info;
  int next_item;
  int temp_item;

  while (size > (factor - 4))
    {
      factor *= 2;
      chunk_depth++;
    }

  for ( i = chunk_depth; i <= TREE_DEPTH; i++ )
    {
      if ((int) FREE_LIST(i) != -1 )
	{
	  insert_into = i;
	  i = TREE_DEPTH;
	}
    }

  if ( insert_into == -1 )
    /* WE NEED MORE SPACE */
    {
      do
	{ /* ask for more memory, update reference variables */
	  if (!mem_sbrk(NUM_PAGES * PAGE_SIZE))
	    return NULL;   /* no memory left */
	
	  /* Add new buddy to freelist */
	  FREE_LIST(TREE_DEPTH) = (int)(1 << TREE_DEPTH);
	  /* set header of new buddy */
	  REF_BYTES(TREE_DEPTH) = (int)((1 << (TREE_DEPTH + 8)) + TREE_DEPTH);
	  /* set pointer in buddy to NULL */
	  *((int *)(MEM_POINTER(TREE_DEPTH))) = -1;

	  NUM_PAGES *= 2;
	  TREE_DEPTH++;
	  
	}
      while ( TREE_DEPTH <= chunk_depth );

      insert_into = TREE_DEPTH-1;
    }

  /* Now we cut the node in the freelist down to the right size */
  while (insert_into > chunk_depth)
    {

      /* decrease the depth, since we're cutting it in half. */
      REF_BYTES(insert_into)--;

      /* set the header information for our new buddy */
      buddy_info = REF_BYTES(insert_into);
      buddy_info = buddy_info ^ ((int)(1 << (insert_into - 1 + 8)));
      *((int *)(MY_HEAP + ((long int)(buddy_info >> 8L) * 8L) + 4L)) = buddy_info;

      /* save the pointer to the next item in the current free list */
      next_item = *((int *)(MEM_POINTER(insert_into)));

      /* set the first buddy to point to the second buddy */
      *((int *)(MEM_POINTER(insert_into))) = (buddy_info >> 8);
 
      /* set the second buddy to point to whatever the freelist being added to is pointed at */
      *((int *)(MY_HEAP + ((long int)(buddy_info >> 8) * 8L) + 8L)) = (int)FREE_LIST(insert_into - 1);

      /* set the freelist being added to to point to first buddy */
      FREE_LIST(insert_into - 1) = FREE_LIST(insert_into);

      /* set the old freelist to point to the next item */
      FREE_LIST(insert_into) = next_item;

      insert_into--;  /* decrement current block size */

    }


  /* Now we allocate the memory we need */

  /* Set the Allocated Bit in the Block being Allocated */
  REF_BYTES(chunk_depth) = REF_BYTES(chunk_depth) | 128;

  next_item = *((int *)(MEM_POINTER(chunk_depth)));
  temp_item = FREE_LIST(chunk_depth);
  FREE_LIST(chunk_depth) = next_item;
  
  return (void *)( MY_HEAP + ((long int)temp_item * 8L) + 8L);
  
}

void mm_free (void *ptr)
{
  char depth;
  int logsize;
  int size = 4;
  int i;
  int j;
  int buddy_pos;
  int is_used;
  int same_size;

  /* Remove the "Allocated Bit" */
  (*((int *)(ptr - 4L))) = (*((int *)(ptr - 4L))) & (~((int)128));

  /* Get the depth of this pointer */
  depth = (*((char *)(ptr - 1L)));
  
  /* Calculate the size of this (in log of 2) 2^size = num bytes */
  logsize = (1 << depth);

  /* Calculate the actual size of this buddy */
  for( i = 0; i < logsize; i++ )
    size *= 2;
  size /= 8;   /* modify, size = multiple of 8 */

  /* Calculate the Buddy's position in the tree */
  buddy_pos = ((*((int *)(ptr - 4L))) >> 8) ^ size;

  /* Is the buddy already allocated? */
  same_size = ((*((char *)(8L * (long int)buddy_pos + MY_HEAP + 7L))) == depth);
  is_used = ((*((int*)((long int)buddy_pos * 8L + MY_HEAP + 4L)))) & 128;

printf ("your_mom %i\n", *((int *)(((long int)buddy_pos) * 8 + MY_HEAP + 4L)));
  
  if((!is_used) && same_size)
    {
      while((!is_used) && same_size && (depth <= TREE_DEPTH))
	{
	  /* Find parent of buddy that must be coalesced */
	  buddy_pos = buddy_pos & (~size);
	  
	  i = FREE_LIST(depth);
	  j = -1;
	  while(i != buddy_pos)
	    {
	      j = i;
	      i = *((int*)((long int)i * 8L + MY_HEAP + 8L)); 
	    }
	  
	  if(j != -1)
	    {
	      /* the parent is not the FREE_LIST */
	      (*((int*)((long int)j * 8L + MY_HEAP + 8L))) = (*((int*)((long int)buddy_pos * 8L + MY_HEAP + 8L))); 
	      
	    }
	  else
	    {
	      /* the parent is the FREE_LIST */
	      FREE_LIST(depth) = *((int*)((long int)buddy_pos * 8L + MY_HEAP + 8L));
	      
	    }
         /* Time to place the buddy back on the FREE_LIST with the new depth */
	  
	  (*((int*)((long int)buddy_pos * 8L + MY_HEAP + 4L))) ++;  /* update depth */
	  depth++;
	  (*((int*)((long int)buddy_pos * 8L + MY_HEAP + 8L))) = FREE_LIST(depth);
	  FREE_LIST(depth) = (buddy_pos >> 8);
	  
	  size *= 2;
	  
	  buddy_pos = ((*((int *)((long int)buddy_pos * 8L + MY_HEAP + 4L))) >> 8) ^ size;
	   
	  same_size = ((*((char *)(8L * (long int)buddy_pos + MY_HEAP + 7L))) == depth);
	  
	  is_used = ((*((int*)((long int)buddy_pos * 8L + MY_HEAP + 4L)))) & 128;
	}
    }
  else
    {
      /* No need to coalesce */
      
      (*((int*)(ptr))) = FREE_LIST(depth);
      FREE_LIST(depth) = ((*((int *)(ptr - 4L))) >> 8);

    }




}

