/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* round up to nearest BLOCKSIZE boundary. */
#define ALIGN(a) ((((a)+BLOCKSIZE-1)/BLOCKSIZE)*BLOCKSIZE)

#define BLOCKSIZE 8     /* align things to 8 bytes */

typedef struct freeblk_t {
    size_t size;
    struct freeblk_t *next;
    struct freeblk_t *back;
} freeblk_t;


/* Memory structure is like this:

The first block of the heap points to the next free block to
be checked for allocation.  Each chunk of memory (allocated or
unallocated) has a block which is the size of the chunk in the
begining.  At the end of each chunk, is a pointer to the begining.
Unallocated chunks also have a next and back pointer which links
free chunks into a cyclic list.
*/

team_t team = {
    /* Team name to be displayed on webpage */
    "slithy toves",
    /* First member full name */
    "Nigel Stepp",
    /* First member email address */
    "stepp@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Christopher Hauser",
    /* Second member email address (blank if none) */
    "hauser@andrew.cmu.edu"
};

int mm_init (void)
{
    size_t pagesize=mem_pagesize();
    freeblk_t *blk=(freeblk_t *)((size_t)dseg_lo+BLOCKSIZE);

    /* set initial heap to one page */
    if(mem_sbrk(pagesize)) {
        /* let's try a cyclic list, and do "next fit" method.
           First block of heap points to current free block */
        *(freeblk_t **)dseg_lo=blk;

        /* make first free block */     
        blk->size=(pagesize-BLOCKSIZE)|1;
        blk->next=blk;
        blk->back=blk;
        /* make footer */
        *(freeblk_t **)((size_t)blk+(blk->size & -2)-BLOCKSIZE)=blk;

        return 0;
    }

    return -1;
}

/* complete with way too many comments (temporarily) */
void *mm_malloc (size_t size)
{
    /* allocsize is number of bytes in the free block we need */
    size_t freesize,allocsize=ALIGN(size+(2*BLOCKSIZE));
    size_t pagesize=mem_pagesize();
    freeblk_t *blk=*(freeblk_t **)dseg_lo,*start=blk,*newblk,*ret;

    /* go through list, stop when we find something good */
    while((blk->size & -2) < allocsize) {
        if(blk->next==start) {
            /* increase heap by 1 page */
            if(!mem_sbrk(pagesize))
                return NULL;
            /* add new free block to free block list */
            newblk=(freeblk_t *)((size_t)dseg_hi+1-pagesize);
            newblk->size=pagesize;
            *(freeblk_t **)((size_t)newblk+(newblk->size & -2)-BLOCKSIZE)=newblk;
            mm_free((void *)newblk+BLOCKSIZE);
            /* get the updated pointer */
            blk=*(freeblk_t **)dseg_lo;
        } else
            blk=blk->next;
    }

    /* found a free block that fits */
    /* If there is more than 4 blocks left, split it
       otherwise allocate the whole thing */
    freesize=blk->size & -2;
    if((freesize-allocsize) > (4*BLOCKSIZE)) {
        newblk=(freeblk_t *)((size_t)blk+allocsize);
        /* look to see if only one free block */
        if(blk->next==blk) {
            newblk->next=newblk;
            newblk->back=newblk;
        } else {
            newblk->next=blk->next;
            newblk->back=blk->back;
            newblk->next->back=newblk;
            newblk->back->next=newblk;
        }
        newblk->size=(freesize-allocsize)|1;
        *(freeblk_t **)((size_t)newblk+(newblk->size & -2)-BLOCKSIZE)=newblk;
        blk->size=allocsize;
        *(freeblk_t **)((size_t)blk+(blk->size & -2)-BLOCKSIZE)=blk;
        *(freeblk_t **)dseg_lo=newblk;
    } else {
        /* just take the whole block out of list (size stays same) */
        blk->next->back=blk->back;
        blk->back->next=blk->next;
        /* unset free bit */
        blk->size=blk->size & -2;
        if(blk->next==blk) {
            if(!mem_sbrk(pagesize))
                return NULL;
            newblk=(freeblk_t *)((size_t)dseg_hi+1-pagesize);
            newblk->size=pagesize|1;
            *(freeblk_t **)((size_t)newblk+(newblk->size & -2)-BLOCKSIZE)=newblk;
            newblk->next=newblk->back=newblk;
            *(freeblk_t **)dseg_lo=newblk;
        } else
            *(freeblk_t **)dseg_lo=blk->next;
    }
    ret=(freeblk_t *)((size_t)blk+BLOCKSIZE);    /* point past header */
    blk->next=blk->back=NULL; /*so this can't act as a free block somewhere*/

    return (void *)ret;
}

void mm_free(void *ptr)
{
    freeblk_t *blk=(freeblk_t *)(ptr-BLOCKSIZE);
    freeblk_t *free=*(freeblk_t **)dseg_lo;
    freeblk_t *before=*(freeblk_t **)(ptr-2*BLOCKSIZE);
    freeblk_t *after=(freeblk_t *)((size_t)blk+(blk->size & -2));

    /* must be in the heap */
    assert((blk > (freeblk_t *)(dseg_lo)) && (blk < (freeblk_t *)dseg_hi));

    if(before && (before->size & 1) && ((ptr-2*BLOCKSIZE)!=(void *)dseg_lo)\
            && after && (after<(freeblk_t *)dseg_hi) && (after->size & 1)) {
		/* take out after and increase size of before to include all 3 */
        after->next->back=after->back;
        after->back->next=after->next;
        before->size+=((blk->size & -2) + (after->size & -2));
        *(freeblk_t **)((size_t)before+(before->size & -2)-BLOCKSIZE)=before;
        *(freeblk_t **)dseg_lo=before;
        after->next=after->back=NULL;after->size=0;
        blk->next=blk->back=NULL;blk->size=0;
    } else if(before && (before->size & 1) &&\
            ((ptr-2*BLOCKSIZE)!=(void *)dseg_lo)) {
		/* increase size of block before */
        *(freeblk_t **)((size_t)before+(before->size & -2)-BLOCKSIZE)=NULL;
        before->size+=(blk->size & -2);
        *(freeblk_t **)((size_t)before+(before->size & -2)-BLOCKSIZE)=before;
        blk->size=0;blk->next=blk->back=NULL;
    } else if(after && (after < (freeblk_t *)dseg_hi) && (after->size & 1)) {
        if(after->next==after) {
            blk->next=blk;
            blk->back=blk;
        } else {
            after->back->next=blk;
            after->next->back=blk;
            blk->next=after->next;
            blk->back=after->back;
        }
        after->next=after->back=NULL;
        blk->size=((blk->size & -2)+(after->size & -2))|1;
        if(after==free)
            *(freeblk_t **)dseg_lo=blk;
        *(freeblk_t **)((size_t)blk+(blk->size & -2)-BLOCKSIZE)=blk;
    } else {
		/* no free blocks adjacent */
        free->next->back=blk;
        blk->next=free->next;
        free->next=blk;
        blk->back=free;
        blk->size|=1;
    }
}

