/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"


#define  HEAD_PTR     *((long**)dseg_lo)  /* pointer to first block on free list */
#define  F_LINK       *((long**)CURR + 1) /* Forward link of current block */
#define  B_LINK       *((long**)CURR + 2) /* Backward link of current block */
#define  PAGE_SIZE    8192L               /* Page size */
#define  BYTE_OFFSET  8L                  /* Initial byte offset */
#define  BYTES_NEEDED 8192L                /* argument passed to mem_sbrk */


team_t team = {
    /* Team name to be displayed on webpage */
    "The Memory Leaks",
    /* First member full name */
    "Sonesh Surana",
    /* First member email address */
    "ssurana",
    /* Second member full name (leave blank if none) */
    "Abhyudaya Agrawal",
    /* Second member email address (blank if none) */
    "aagrawal"
};


/* GENRAL METHOD - EXPLICIT LISTS, FIRST FIT, AND COALESCING WHILE FREEING */
/*                


int mm_init (void)
{

  

  if ( mem_sbrk(PAGE_SIZE ) ){
    
    /* Initialize pointer to head of free list */
    HEAD_PTR = ((long*)dseg_lo + 1);     
    
    /* Initialize Header */
    *HEAD_PTR = PAGE_SIZE - BYTE_OFFSET; 

    /* Initialize Footer */
    *(HEAD_PTR + (*HEAD_PTR>>3) - 1) = PAGE_SIZE - BYTE_OFFSET; 

    
    /* Forward link of curent block in free list */ 
    *((long**)HEAD_PTR + 1) = NULL;   
         
    /*Backward link of current block in free list*/
    *((long**)HEAD_PTR + 2) = NULL;   

    
  } else {

    return -1;                 /* mem_sbrk failed  :-o ! */

  }

  return 0;                    /* ( everything is OK :-) */
 
} /* end of int mm_init() */



void *mm_malloc (size_t size)
{

  int usr_size;          /* size we are going to return to the user */
  int bytes_needed;
  
  long* CURR = HEAD_PTR; /* start looking at the beginning of the free list */

  long* PREV = NULL;     /* initially the previous block does not exist */

  char* EXTEND = NULL;   /* used to get a handle on the block when we extend */
                         /* using mem_sbrk */

  char* old_dseg_hi;

  
  if (size < 16)
    usr_size = 16;                /* make sure it's minimum */
  else 
                                  /* otherwise round it up to multiple of 8 */
    usr_size = (size & 0x7) ? (size & ~0x7) + 8 : size; 
      


  while ( CURR  ) {
    
    if ( *CURR - 16 >= usr_size ) {
      
    /* RETURN BLOCK */

      /* STAGE ONE - Splice block -- maybe can put in function later */

      if (B_LINK == NULL && F_LINK == NULL)
	
	/* the current block is the only block so once we splice it from
	   the list our list should be empty */

	HEAD_PTR = NULL;               
      
      else if (B_LINK == NULL) {

	/* The current block is the first in the list
	   So when we splice it out from the list, the start of the list
	   is the forward link of current. since this is now the start of the
           list, it's backward pointer becomes NULL */
	
	HEAD_PTR = F_LINK;
	
	*((long**)HEAD_PTR + 2) = NULL;
	
      }
      
      else if (F_LINK == NULL){

	/* the current block is the last in the list.
	   so when we splice it out from the free list then the previous
	   block becomes the last and so it's forward link is now NULL */
      	*((long**)(B_LINK + 1)) = NULL; 
	
      }

      else {

	/* the current block is neither last nor first.
	   so when we splice it
	   then the previous block's forward link should be current's forward
	   link and the next block's backward link should be the current's
           backward link */
	
	*((long**)B_LINK + 1) = F_LINK;

	*((long**)F_LINK + 2) = B_LINK;
	
      }  /* END OF SPLICING CODE */
      
     

      if ( *CURR - usr_size -16 >= 32) {

	/* SPLIT BLOCK */

	/* update header of fragment */
	*(CURR + (usr_size>>3) + 2) = *CURR - usr_size - 16;

	/* update footer of fragment */
	*(CURR + (*CURR>>3) - 1) = *CURR - usr_size - 16;

	/* update header */
	*CURR = (usr_size + 16) | 0x1;
        
	/* update footer */
	*(CURR + (usr_size>>3) + 1) =  (usr_size+16) | 0x1;


	/* ADD FRAGMENT TO THE FRONT OF THE LIST */

	/* make backward link of current start block equal to the pointer
	   to the fragment */
	

	if (HEAD_PTR == NULL) {
	  /* there is no  list */
	  HEAD_PTR =  CURR + (usr_size>>3) + 2;
	   *((long**)HEAD_PTR+1) = NULL;
	   *((long**)HEAD_PTR+2) = NULL; 
	} else {
	
	 /* make forward link of fragment to current free list head  pointer */
	*((long**)CURR + (usr_size>>3) + 3) = HEAD_PTR;

	/* make backward link of first block to the fragment which is now
	   the first block in the list */
	*((long**)HEAD_PTR + 2) = CURR + (usr_size>>3) + 2;	  
	  
	  /* so now the fragment is at the head of our free list */
 	  HEAD_PTR = CURR + (usr_size>>3) + 2;

	  /* set the backward link of fragment block to null since it's the first in list now */
	  *((long**)HEAD_PTR + 2) = NULL;
	  
	}


	/* return the area we just split from the block*/
	return CURR + 1;

      } else {
	
	/* RETURN ENTIRE BLOCK */

	/* update tag bit of header */
	*CURR = *CURR | 0x1;

	/* update tag bit of footer */
	*(CURR + (*CURR>>3) - 1) =  *CURR | 0x1;

	return CURR + 1;

      } // end of if-else statement that splits block or returns entire block


    } // end of if ( *CURR - 16 >= size )



    /* keep a handle on current block */
    PREV = CURR;

    /* move ahead in the list */
    CURR = F_LINK;


  } // end of while (CURR )


  /* could not find any block, so have to invoke mem_sbrk */


 old_dseg_hi = dseg_hi;

  if ( *((long*)(dseg_hi - 7)) & 0x1 ) {

    /* CANNOT CONCATENATE */

    /* EXTEND = (long*)mem_sbrk(bytes_needed); */

    if ( mem_sbrk( BYTES_NEEDED ) ){

      /* have increased heap size my number of bytes we are going to give usr
       plus those required for header and footer */

    

      

      /* Create Links */
      if (PREV == NULL){        /* get last block */
      
	HEAD_PTR = (long*)(dseg_hi - BYTES_NEEDED + 1);
	*HEAD_PTR = BYTES_NEEDED;
	*(HEAD_PTR + (*HEAD_PTR>>3) - 1) = BYTES_NEEDED;
	*((long**)(HEAD_PTR+1)) = NULL;
	*((long**)(HEAD_PTR+2)) = NULL;
	  
      }

      else{

	CURR = PREV;
	
	F_LINK = (long*)(dseg_hi - BYTES_NEEDED + 1);    /* make it's forward link the new block we have 
			                            created after using mem_sbrk */
      
	CURR = F_LINK;      /* go to last block */
	
	F_LINK = NULL;      /* make it's forward link NULL */
	
	B_LINK = PREV;      /* make it's previous link to the second last block*/

	*CURR = BYTES_NEEDED;

	*(CURR + (*CURR>>3 ) - 1) = BYTES_NEEDED;
	
      } // links have been created

      /* return EXTEND + 1; */
      
      return mm_malloc(size); 
      
    } else
      return NULL;

  } else {

    /* CAN CONCATENATE */

   
    EXTEND = mem_sbrk (BYTES_NEEDED);
    
    if ( EXTEND ) {

      EXTEND = EXTEND - 1; /* get old dseg_hi */

      assert( old_dseg_hi == EXTEND);

      if (PREV == NULL){

	/* *EXTEND = (usr_size + 16) | 0x1; */
	/* *(EXTEND + (*EXTEND>>3) - 1) = (usr_size + 16) | 0x1; */
	
	HEAD_PTR = (long*)(dseg_hi - BYTES_NEEDED + 1);
	*HEAD_PTR =  BYTES_NEEDED;
	*(HEAD_PTR + (*HEAD_PTR>>3) - 1) =  BYTES_NEEDED;
	*((long**)HEAD_PTR + 1) = NULL;
	*((long**)HEAD_PTR + 2) = NULL;
			 


      } else {

	

	CURR = (long*)(EXTEND-7) -  (*((long*)(EXTEND - 7)) >>3 ) + 1 ;
	
	*CURR = *CURR + BYTES_NEEDED;
	
	*(CURR + (*CURR>>3) - 1) = *CURR;


	  
      }

       return mm_malloc(size); 
	 
    }
    else
      return NULL;
    
  }
  
} // end of mm_malloc

void mm_free (void *ptr)
{


  long* CURR; /* get a handle on the block to be free including it's header and footer */
  
  long* CURR_HEADER; /* handle on header of current block to be freed */

  long* CURR_FOOTER; /* handle on footer of current block to be freed */

  long* PREV_FOOTER; /* handle on footer of previous block in contiguous memory */

  long* NEXT_HEADER; /* handle on header of next block in contiguous memory */

  long* PTR = (long*) ptr; /* handle on area to be freed (given by user) */

  /* get a handle on prev word which is the header of block we want to free */
  CURR = PTR - 1;

  /* get a handle on the footer of the block we want to free */
  CURR_FOOTER = CURR + (*CURR>>3) - 1;

  /* free TAG bit for header*/
  *CURR = *CURR & ~0x1;
  
  /* free TAG bit for footer */
  *CURR_FOOTER = *CURR_FOOTER & ~0x1;

  /* get handle on footer of previous block in contiguous mem */
  PREV_FOOTER = CURR - 1;

  /* get handle on header of next block in contiguoug mem */
  NEXT_HEADER = CURR_FOOTER + 1;

  

  if ( *PREV_FOOTER & ~ 0x1 ) 
    {
      
      /* the previous block is not free */
      
      if ( *NEXT_HEADER & ~0x1 ) {
	
	/* the next block is not free either */
	
	/* so we do a NAIVE FREE */
	
	/* ************ NAIVE FREE ******************/
	if (HEAD_PTR == NULL) {
	  
	  HEAD_PTR = CURR;
	  
	  F_LINK = NULL;
	  
	  B_LINK = NULL;
	  
	} else {
	  
	  B_LINK = NULL;
	  
	  F_LINK = HEAD_PTR;
	  
	  CURR = F_LINK;
	  
	  B_LINK = PTR - 1;
	  
	  CURR = B_LINK;
	  
	  HEAD_PTR = CURR;
	}
	/* ************ end of NAIVE FREE ***************/
	
	

      } /* end of if  ( *NEXT_HEADER & ~0x1 ) */
      
      else 
	{
	  
	  /* the next block is free ! - so we might be able to forward coalesce */
	  
	  /* check if the block we are supposed to return is at the end of contiguous mem */
	  /* if it is then we can't forward coalesce. */
	  
	  if ( CURR_FOOTER == (long*)(dseg_hi - 7) ) {
	    /* cannot forward coalesce , so just add it to front of free list */
	    /*** NAIVE FREE ***/
	    if (HEAD_PTR == NULL) {
	      
	      HEAD_PTR = CURR;
	      
	      F_LINK = NULL;
	      
	      B_LINK = NULL;
	      
	    } else {
	      
	      B_LINK = NULL;
	      
	      F_LINK = HEAD_PTR;
	      
	      CURR = F_LINK;
	      
	      B_LINK = PTR - 1;
	      
	      CURR = B_LINK;
	      
	      HEAD_PTR = CURR;
	    }
	    /* ************ end of NAIVE FREE ***************/
	  }
	  else
	  {
	    /* can forward coalesce !!! */

	    /* SPLICE next block out of list */

	    CURR = NEXT_HEADER;

	    if (B_LINK == NULL && F_LINK == NULL)
	     
	      HEAD_PTR = NULL;               
	    
	    else if (B_LINK == NULL) {
	    
	      HEAD_PTR = F_LINK;
	      
	      *((long**)HEAD_PTR + 2) = NULL;
	      
	    }
	    
	    else if (F_LINK == NULL){
	   
	      *((long**)(B_LINK + 1)) = NULL; 
	      
	    }
	    
	    else {
	      
	     
	      *((long**)B_LINK + 1) = F_LINK;
	      
	      *((long**)F_LINK + 2) = B_LINK;
	      
	    }  /* END OF SPLICING CODE */
	    
	    /* concatenate with the block we want to return  */

	    CURR = PTR - 1;

	    /* update header and footer tags of enlarged block */
	    *CURR = (*CURR>>3) + (*NEXT_HEADER>>3);

	    *(CURR + (*CURR>>3) - 1) = *CURR;

	    
	    /* now add it to the start of the list */

	    /* NAIVE FREE */
	    if (HEAD_PTR == NULL) {
	      
	      HEAD_PTR = CURR;
	      
	      F_LINK = NULL;
	      
	      B_LINK = NULL;
	      
	    } else {
	      
	      B_LINK = NULL;
	      
	      F_LINK = HEAD_PTR;
	      
	      CURR = F_LINK;
	      
	      B_LINK = PTR - 1;
	      
	      CURR = B_LINK;
	      
	      HEAD_PTR = CURR;
	    }
	    /* NAIVE FREE */
	    
	    
	  } /* end of if  ( CURR_FOOTER == (long*)(dseg_hi - 7) ) */
	  
	  
	} /* end of else corresponding to if  ( *NEXT_HEADER & ~0x1 ) */
      
      
    } /* end of if ( *PREV_FOOTER & ~ 0x1 ) */
  else 
    {
       
	 /* prev block is free */
      
     
    
      if ( *NEXT_HEADER & 0x1 ) 
	{

	/* next block is not free */
	  
	  if ( PREV_FOOTER == (long*)(dseg_lo) ) 
	    {
	       
	      /* NAIVE FREE */
	      if (HEAD_PTR == NULL) {
		
		HEAD_PTR = CURR;
		
		F_LINK = NULL;
		
		B_LINK = NULL;
		
	      } else {
		
		B_LINK = NULL;
		
		F_LINK = HEAD_PTR;
		
		CURR = F_LINK;
		
		B_LINK = PTR - 1;
		
		CURR = B_LINK;
		
		HEAD_PTR = CURR;
	      }
	      /* NAIVE FREE */
	      
	      /* naive version */
	      
	    }
	  else 
	    {
	      
	      /*backward coalescing */
	      *(PREV_FOOTER - (*PREV_FOOTER>>3) + 1) = (*PREV_FOOTER>>3) + (*CURR>>3);

	      *(CURR + (*CURR>>3) - 1) = *(PREV_FOOTER - (*PREV_FOOTER>>3) + 1);
	      
	      
	  }
	  
	}
      else  /* next block is free */
	{ 
	  if ( PREV_FOOTER == (long*)dseg_lo ) 
	    {
	      /* only forward coalescing */

	       /* can forward coalesce !!! */

	    /* SPLICE next block out of list */

	    CURR = NEXT_HEADER;

	    if (B_LINK == NULL && F_LINK == NULL)
	     
	      HEAD_PTR = NULL;               
	    
	    else if (B_LINK == NULL) {
	    
	      HEAD_PTR = F_LINK;
	      
	      *((long**)HEAD_PTR + 2) = NULL;
	      
	    }
	    
	    else if (F_LINK == NULL){
	   
	      *((long**)(B_LINK + 1)) = NULL; 
	      
	    }
	    
	    else {
	      
	     
	      *((long**)B_LINK + 1) = F_LINK;
	      
	      *((long**)F_LINK + 2) = B_LINK;
	      
	    }  /* END OF SPLICING CODE */
	    
	    /* concatenate with the block we want to return  */

	    CURR = PTR - 1;

	    /* update header and footer tags of enlarged block */
	    *CURR = (*CURR>>3) + (*NEXT_HEADER>>3);

	    *(CURR + (*CURR>>3) - 1) = *CURR;

	    
	    /* now add it to the start of the list */

	    /* NAIVE FREE */
	    if (HEAD_PTR == NULL) {
	      
	      HEAD_PTR = CURR;
	      
	      F_LINK = NULL;
	      
	      B_LINK = NULL;
	      
	    } else {
	      
	      B_LINK = NULL;
	      
	      F_LINK = HEAD_PTR;
	      
	      CURR = F_LINK;
	      
	      B_LINK = PTR - 1;
	      
	      CURR = B_LINK;
	      
	      HEAD_PTR = CURR;
	    }
	    /* NAIVE FREE */

	    }
	  else
	    {
	      /* both forward and backward */

	      /* splice next */

	      CURR = NEXT_HEADER;
	      
	      if (B_LINK == NULL && F_LINK == NULL)
		
		HEAD_PTR = NULL;               
	      
	      else if (B_LINK == NULL) {
		
		HEAD_PTR = F_LINK;
		
		*((long**)HEAD_PTR + 2) = NULL;
		
	      }
	      
	      else if (F_LINK == NULL){
		
		*((long**)(B_LINK + 1)) = NULL; 
		
	      }
	      
	      else {
		
		
		*((long**)B_LINK + 1) = F_LINK;
		
		*((long**)F_LINK + 2) = B_LINK;
		
	      }  /* END OF SPLICING CODE */
	      
	      /* concatenate with the block we want to return  */
	      
	      CURR = PREV_FOOTER - (*PREV_FOOTER>>3) + 1;
	      
	      /* update header and footer tags of enlarged block */
	      *CURR = (*PREV_FOOTER>>3) + (*(PTR - 1)>>3) + (*NEXT_HEADER>>3);
	      
	      *(CURR + (*CURR>>3) - 1) = *CURR;
	      
	      
	      
	      
	      
	    }

	}
    
    
     


  } // end of the outermost if statement

  
}

