/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "THE MEMORY LEAKS !!!!",
    /* First member full name */
    "Sonesh Surana",
    /* First member email address */
    "ssurana",
    /* Second member full name (leave blank if none) */
    "Abhyudaya Agrawal",
    /* Second member email address (blank if none) */
    "aagrawal"
};

/* threshold is the minimum size block which should be allowed to exist
when we do a split. if we find that after splitting, the remaining block
size is < threshold then we sacrifice that space for speed purposes.
threshold must be atleast 2 because no blocks of size < 2 can ever be 
allocated! 
*/
#define INITIAL_SIZE 1022
#define THRESHOLD 2 
#define EXTRA     *((long*)dseg_lo+1)     /* extra word */
#define TEMP_WS   *((long*)dseg_lo) /* size we're going to give to the */
                                        /* user excluding header and footer */


long* START;       /* start of the free list */
long* CURR;        /* pointer to current block in the free list */
long* PREV;        /* pointer to prev block in free list */

int mm_init (void)
{

  assert( dseg_hi - dseg_lo == -1);

  if ( mem_sbrk ( mem_pagesize() ) ){
    
    long *p;
    for (p=(long*)dseg_lo; p != (long*) (dseg_hi-7); p++)
    {
      *p = 0;
    }
    START = (long*)dseg_lo + 2;    /* get a handle on the start of list  */
    CURR  = NULL;                  /* Initially we have no current block */

    *START = INITIAL_SIZE << 1;                 /* update initial header */
    *((long*)(dseg_hi - 7)) = INITIAL_SIZE << 1;  /* update initial footer */

    assert((*START >> 1) >= 4);
    assert((*((long*)(dseg_hi - 7)) >> 1) >= 4);

    /* /Update links/ */

    *((long**)START + 1) = NULL;  /* forward link  */
    *((long**)START + 2) = NULL;  /* backward link */

    TEMP_WS = 0;
    EXTRA   = 1;
    assert(EXTRA & 0x1);

  



  } else {
    return -1; /* no more pages left :-( */
  }

  return 0;
}

void *mm_malloc (size_t size)
{
  if (size == 0) 
    return NULL;

  TEMP_WS = (((size + 7) >> 3) << 3) >> 3;/*this is word size we give to user*/
  assert(TEMP_WS > 0);
  if (TEMP_WS == 1)
    TEMP_WS = 2;

  CURR = START;                           /* start off at the beginning */

#if 0
  for (CURR = START; CURR != NULL; CURR = *((long**)CURR + 1))
    {
      assert(CURR!=NULL);
 if ((*CURR) < 4)
    {
      printf("SIZE=%ld\n",size);
      printf("A block of bad size! Size=%ld, Found at CURR=%p\n",*CURR, CURR);
      printf("Here's the list : \n");

      for (CURR = START; CURR != NULL; CURR = *((long**)CURR + 1))
        printf("location:%p\nsize:%ld\n",CURR, *CURR); 
     }
    }
CURR=START;
#endif

  while ( CURR ){
#if 0
    if ((*CURR) < 4)
    {
      printf("A block of bad size! Size=%ld, Found at CURR=%p\n",*CURR, CURR);
      printf("Here's the list : \n");

      for (CURR = START; CURR != NULL; CURR = *((long**)CURR + 1))
        printf("location:%p\nsize:%ld\n",CURR, *CURR); 
     }
#endif
    if ( (*CURR >> 1) >= (TEMP_WS + 2) ) { /*then we can give user something*/
      
      if ( (*CURR >> 1) - (TEMP_WS + 2) >= 2 + THRESHOLD ) { /* split block */
	
	

	/*  SET HEADER AND FOOTER OF REMAINING BLOCK */

        assert( (( (*CURR >> 1) - (TEMP_WS + 2) ) << 1) >> 1 >= 4);

	/* header */
	*(CURR + TEMP_WS + 2) =  ( (*CURR >> 1) - (TEMP_WS + 2) ) << 1;
	/*footer*/
	*(CURR + (*CURR >> 1) - 1) = ( (*CURR >> 1) - (TEMP_WS + 2) ) << 1;

        assert( *(CURR + TEMP_WS + 2) >> 1 >= 4);
        assert(  *(CURR + (*CURR >> 1) - 1) >> 1 >= 4);

	/* UPDATE LINKS */
	
	if ( *((long**)CURR + 2) == NULL )  /* BACK LINK */
	  START = CURR + TEMP_WS + 2;
	else
	  *((long**)(*((long**)CURR + 2) + 1)) = CURR + TEMP_WS + 2;

	if ( *((long**)CURR + 1) == NULL ) { /* FORWARD LINK */
	  /* do nothing */
	}
	else 
	  *((long**)(*((long**)CURR + 1) + 2)) = CURR + TEMP_WS + 2;

			
	/* CREATE NEW FORWARD AND BACKWARD LINKS FOR NEW BLOCK */

	*((long**)CURR + TEMP_WS + 3) = *((long**)CURR + 1);     /* forward  */
	*((long**)CURR + TEMP_WS + 4) = *((long**)CURR + 2);    /* backward */


	/* UPDATE HEADER AND FOOTER FOR BLK TO BE RETURNED TO USER */
        /* AND TAG LAST BIT ( BECAUSE BLOCK HAS BEEN ALLOCATED )    */

        assert( (((TEMP_WS + 2) << 1) | 0x1) >> 1 >= 4);

	*CURR = ((TEMP_WS + 2) << 1) | 0x1;                  /* header */
	*(CURR + TEMP_WS + 1) = ((TEMP_WS + 2) << 1) | 0x1;  /* footer */


        assert(*CURR >> 1 >= 4);
        assert(*(CURR + TEMP_WS + 1) >> 1 >= 4);

        if (START) assert(*START);
	/*     printf("%p\n",CURR+1); */
	return CURR + 1;

      } /*if ( (*CURR >> 1) - (TEMP_WS + 2) >= 2 + THRESHOLD ) -> (SPLIT BLK)*/

      else {

 /* return entire block */
         long* TEMP;	

         assert(((*CURR | 0x1) >> 1) >= 4);

	*CURR = *CURR | 0x1;
	*(CURR + (*CURR >> 1) - 1) = *CURR | 0x1;

        assert( *CURR >> 1 >= 4);
        assert( *(CURR + (*CURR >> 1) - 1) >> 1 >= 4);

        TEMP = START;        

	if ( *((long**)(CURR + 2)) == NULL )  /* BACK LINK */
	  START = *((long**)(CURR + 1));
	else
	  *((long**)(*((long**)(CURR + 2)) + 1)) = *((long**)(CURR + 1));
	
	if ( *((long**)CURR + 1) == NULL ) { /* FORWARD LINK */
	  /* do nothing */
	}
	else 
	  *((long**)(*((long**)CURR + 1) + 2)) = *((long**)CURR + 2);
	
        if (START)
        {
           if (!(*START))
           {
             printf("start is buggy. previous start =%p\n", TEMP);
           }
        }

	/*        printf("%p\n",CURR+1); */
	return CURR + 1;
   
 } /* end of else -> RETURN ENTIRE BLOCK */
	

    } /* end of if ( (*CURR >> 1) >= (TEMP_WS + 2) ) -> give user block */
   

    PREV = CURR;
    
    CURR = *((long**)CURR + 1);
    


  } /* end of while (CURR) loop that does work while we're still in the list */


  /* we have reached the end of the list but haven't found a suitable block */
  /* so we invoke mem_sbrk */

  

  if ( *((long*)(dseg_hi - 7)) & 0x1 ) { 

    /*   printf("cannot conc"); */
    /* cannot concatenate */

    if ( mem_sbrk ( (TEMP_WS + 2) << 3 ) ){

      if ( (( ((TEMP_WS + 2) << 1 ) | 0x1) >> 1) < 4)
        printf("We will fail assertion because TEMP_WS = %ld",TEMP_WS);

      assert( ( ((TEMP_WS + 2) << 1 ) | 0x1) >> 1 >= 4);
 
      /* update header */
      *((long*)(dseg_hi - (TEMP_WS + 2)*8 + 1)) = ( (TEMP_WS + 2) << 1 ) | 0x1;
      /* update footer */
      *((long *)(dseg_hi - 7)) = ( (TEMP_WS + 2) << 1 ) | 0x1;

      assert((*((long*)(dseg_hi - (TEMP_WS + 2)*8 + 1)) >> 1) >= 4);
      assert(( *((long *)(dseg_hi - 7)) >> 1 ) >= 4);   

        if (START) assert(*START);


	/*      printf("no-conc:%p\n",(long*)(dseg_hi - (TEMP_WS + 2)*8 + 1) + 1); */
      return (long*)(dseg_hi - (TEMP_WS + 2)*8 + 1) + 1;
      

    } /* end of if ( mem_sbrk ( (TEMP_WS + 2) >> 3 ) ) */

    else {
        if (START) assert(*START);

      return NULL;

    }
	 

  } // end of if ( *((long*)(dseg_hi - 7)) & 0x1 )

  else {
 /* ( can concatenate !! :-) */

    /*    printf("can conc"); */

    char *TEMP = dseg_hi;

    /*
    printf("Concatenating with %ld\n", ((*((long*)(dseg_hi-7))) ) >> 1); 
    printf("Concatenating for:%ld", TEMP_WS+2);
    */


    if ( mem_sbrk ( ( (TEMP_WS + 2) - ((*((long*)(dseg_hi-7))) >> 1) ) << 3 ) )
    {
      long *BLINK;
    assert( ((((TEMP_WS + 2) << 1 ) | 0x1) >> 1) >= 4);


    /* zap out previous footer */
    *((long*)(TEMP-7)) = 0;
 
 
    /* header */
    *(((long*)(dseg_hi-7)) - (TEMP_WS +1) ) = ( (TEMP_WS + 2) << 1 ) | 0x1;
    /* footer */
    *((long*)(dseg_hi - 7)) = ( (TEMP_WS + 2) << 1 ) | 0x1;

    /*
    assert(*PREV >> 1 >= 4);
    assert(*(PREV+TEMP_WS+1) >> 1 >= 4);
    */

    /* Update links */

    BLINK = *((long**)( ((long*)(dseg_hi-7)) - TEMP_WS + 1 )); 
    if ( BLINK == NULL )
      START = NULL;
    else
       
        *((long**)(BLINK+1)) = NULL;
        /* if (START) assert(*START); */
       
    /*   printf("conc:%p\n", ((long*)(dseg_hi-7)) - (TEMP_WS)); */
       return (((long*)(dseg_hi-7)) - (TEMP_WS));
    
    }

    else 
      {
      printf("NULL");
      return NULL;
      }
  } // end of else 
     

  
} /* end of mm_malloc ( size_t size ) */






void mm_free (void *ptr)
{ 

  /* For convenience sake */
  long *p = (long*) ptr;

  /* Check to see if both the header and the footer are indeed marked */ 
  /* as allocated i.e. if the tag is 1 */
 
  assert( (*(p-1)) & 0x1 );                         /*Check header tag */
  assert( (*(p + (*(p-1) >> 1) - 2)) & 0x1 );       /*Check footer tag */
  assert( (*(p-1)) == (*(p + (*(p-1) >> 1) - 2)) ); /*Check if header==footer */

#if 0  
  /* Simple Version - no coalescing : Just add the block to the front */
  /* of the list */

  if (START)  
    *((long**)(START+2)) = p-1;

  assert(*(p-1) >> 1 >= 4);

  /* Mark header and footer as free  */
  *(p + (*(p-1) >> 1) - 2) =  (*(p + (*(p-1) >> 1) - 2)) & (~0x1);   /* footer */
  *(p-1) = (*(p-1)) & (~0x1);                                         /* header */

  assert(*(p + (*(p-1) >> 1) - 2) >> 1 >= 4);
  assert(*(p-1) >> 1 >= 4);

  *((long**) p)     = START;  /* Update forward link of block        */
  *((long**) (p+1)) = NULL;   /* Update backward link of block       */
  START = (p-1);              /* Update the start of the linked list */
#endif


  /* More complicated version: Checking for coalescing      */
  /* Please comment out simple version before using this    */
 
  if (*(p-2) & 0x1)                       /* previous block is allocated */
  {
    if (*(p + (*(p-1) >> 1) - 1) & 0x1)   /* next block is allocated */
    {
      /* No coalescing. Same as Simple version */

      if (START)  
        *((long**)(START+2)) = p-1;

      /* Mark header and footer as free  */
      *(p + (*(p-1) >> 1) - 2) =  (*(p + (*(p-1) >> 1) - 2)) & (~0x1);   /* footer */
      *(p-1) = (*(p-1)) & (~0x1);                                         /* header */

      *((long**) p)     = START;  /* Update forward link of block */    
      *((long**) (p+1)) = NULL;   /* Update backward link of block */
      START = (p-1);              /* Update the start of the linked list */

    }
    else                                 /* next block is free */
    {

      /* No coalescing. Same as Simple version */

      if (START)  
        *((long**)(START+2)) = p-1;

      /* Mark header and footer as free  */
      *(p + (*(p-1) >> 1) - 2) =  (*(p + (*(p-1) >> 1) - 2)) & (~0x1);   /* footer */
      *(p-1) = (*(p-1)) & (~0x1);                                         /* header */

      *((long**) p)     = START;  /* Update forward link of block */    
      *((long**) (p+1)) = NULL;   /* Update backward link of block */
      START = (p-1);              /* Update the start of the linked list */

    }

    
  }
  else                                   /* previous block is free */



  {

    if (*(p + (*(p-1) >> 1) - 1) & 0x1)  /* next block is allocated */
    
    {

#if 0
      if (p==(long*)(dseg_lo)+24)
      {
        /* No coalescing. Same as Simple version */

        if (START)  
          *((long**)(START+2)) = p-1;

      /* Mark header and footer as free  */
      *(p + (*(p-1) >> 1) - 2) =  (*(p + (*(p-1) >> 1) - 2)) & (~0x1);   /* footer */
      *(p-1) = (*(p-1)) & (~0x1);                                         /* header */

      *((long**) p)     = START;  /* Update forward link of block */    
      *((long**) (p+1)) = NULL;   /* Update backward link of block */
      START = (p-1);              /* Update the start of the linked list */


      }

     
       /* Backward coalescing
         Only need to change the lengths
         New length = (((*(p-1)) >> 1)   +    ((*(p-2)) >> 1))  << 1 */
      /* printf("Backward coalescing for %ld with %ld",((*(p-1)) >> 1),(*(p-2)) >> 1   ); */

      *(p + (*(p-1) >> 1) - 2) =  (((*(p-1)) >> 1)   +    ((*(p-2)) >> 1)) << 1;
      *((p-1) - (*(p-2) >> 1)) =  (((*(p-1)) >> 1)   +    ((*(p-2)) >> 1)) << 1;

      assert(*(p + (*(p-1) >> 1) - 2) >= 4);
      assert( *((p-1) - (*(p-2) >> 1)) >= 4);
      /* This is just for completeness */
      *(p-1) = 0;  /* zap out intermediate header */
      *(p-2) = 0;  /* zap out intermediate footer */
#endif

      
      /* No coalescing. Same as Simple version */

      if (START)  
        *((long**)(START+2)) = p-1;

      /* Mark header and footer as free  */
      *(p + (*(p-1) >> 1) - 2) =  (*(p + (*(p-1) >> 1) - 2)) & (~0x1);   /* footer */
      *(p-1) = (*(p-1)) & (~0x1);                                         /* header */

      *((long**) p)     = START;  /* Update forward link of block */    
      *((long**) (p+1)) = NULL;   /* Update backward link of block */
      START = (p-1);              /* Update the start of the linked list */

      


    } 
    else                                 /* next block is free */
    {
      /* Forward AND backward coalescing  <shiver> */ 

      /* No coalescing. Same as Simple version */

      if (START)  
        *((long**)(START+2)) = p-1;

      /* Mark header and footer as free  */
      *(p + (*(p-1) >> 1) - 2) =  (*(p + (*(p-1) >> 1) - 2)) & (~0x1);   /* footer */
      *(p-1) = (*(p-1)) & (~0x1);                                         /* header */

      *((long**) p)     = START;  /* Update forward link of block */    
      *((long**) (p+1)) = NULL;   /* Update backward link of block */
      START = (p-1);              /* Update the start of the linked list */



    }
  }
  


}

