/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define FREESPACE_P ((long *) (deseg_lo))
#define BEGIN_P ((long *) (deseg_lo + 8))
#define END_P ((long *) (deseg_hi))
#define PAGESIZE (size_t) 8192
#define SIZE_MASK (long) (0xfffffffffffffffe)
#define FREE_FLAG_MASK (long) (0x0000000000000001)

team_t team = {
    /* Team name to be displayed on webpage */
    "blech",
    /* First member full name */
    "Betty Shea",
    /* First member email address */
    "shea",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* general implementation: best-fit, singly-linked implicit free-list 
   with forward and backward coalescing
   header contains size( with last bit as freeflag) and  address of next free. 
   footer contains size and freeflag bit 
   */
  

int mm_init (void)
{
  long * writer = FREESPACE_P;

  if( mem_sbrk( PAGESIZE ) == NULL )
    return -1;

  /* first 8 bytes is the freespace pointer - currently everything
     free so just pointing to its neighbor */
  *writer = (long) (&BEGIN_P);
  
  /* write in size = PAGESIZE - sizeof(fp) - sizeof(header) - sizeof(footer)
     = 8192 - long(fp) - long(size) - long(nextfree) - long(size)
     store free flag in the last bit : 0 -> free, 1 -> allocated
     automatically flags free */

  writer++;
  *writer = (long) (PAGESIZE - 32);

  /* write in address of nextfree - 0x00 indicates no more free blocks
     after current */
  writer++;
  *writer = (long) 0x0;

  /* no need to use char shifter */
  /* skip to footer and write in size */
  writer += ( (PAGESIZE-32) / 8);
  *writer = (long) (PAGESIZE-32); 

  return 0;
}

void *mm_malloc (size_t size)
{
  /* FREESPACE_P points to a long, which is the numeric address of the
     first free place */
  char* shifter;
  long* writer = (long *) FREESPACE_P;
  long min_amount, r_size = (long) size, temp;
  long* best = NULL, last = FREESPACE_P;

  /* never needs to check for whether a block is occupied because
     this is the freelist */
 
  do
  {
    /* no more memory chunks - last's nextfree is 0x0 */
    last++; /* last points to address of next writer or 0x0 */
    if( (*last) != 0x0 )  /* writer points to valid place */
      last--;  /* return last to point to size part */
    else  /* either found imperfect fit or everything too small */
    {
      /* case: imperfect fit */
      if( best != NULL )
      {
	/* go ahead and split for now even though it may not be optimal */
	/* guaranteed at least 8 bytes of writable memory */

	/* overwrite size and flag occupied */
	temp = (*best);  /* store old size */
	writer = best;
	(*writer) = (r_size | FREE_FLAG_MASK);
	
	/* write footer */
	shifter = (char*) (writer+=2);  /* writer and shifter at writable */ 
	shifter += r_size;
	writer = (long *) shifter;
	(*writer) = (r_size | FREE_FLAG_MASK); 
	shifter -= r_size;
	best = (long *) shifter;  /* best holds the correct return */

	/* write header and footer of left over space */
	writer++;  /* writer points to header of space left */
	
	/* write header size - free bit automatically set */
	(*writer) = (long) (temp - r_size - 24);
	
	/* write footer - need to check if this type of pointer casting works*/
	shifter = (char *) writer;
	shifter += (temp - r_size - 24);
	writer = (long *) shifter;
	*writer = (long) (temp - r_size - 24); 

	/* write nextfree address - i.e. insert into freelist */
	shifter -= (temp - r_size - 24);
	writer = (long*) shifter;
	writer++;
	*writer = (long) (*FREESPACE_P);
	writer--;
	(*FREESPACE_P) = (&writer);

	/* return correct pointer */
	return best;
      }
      else  /* case: no size big enough */
      {
	/* best is NULL, last points to last free block, writer invalid */
	/* no use with free list because last on list not last on memory */

	/* access last block of heap, check footer for free or not */
	writer = (long *) (deseg_hi);
	writer--; /* points at beginning of last footer */

	/* store amount of free space left at end of heap in temp */
	if( (*writer) & FREE_SPACE_MASK )  /* allocated */
	  temp = 0x0;
	else
	  temp = ((*writer) | SIZE_MASK );

	/* put writer to the appropriate place */
	if( temp == 0x0 )
	  writer++;  /* deseg_hi */
	else
	{
	  shifter = (char *) writer;
	  shifter -= temp;
	  writer = (long *) shifter;
	}

	/* calculate how much space needed to be requested */
	if( r_size - temp <= PAGESIZE )
	  temp = PAGESIZE;
	else  /* round up */
	  temp = ((r_size - temp)/PAGESIZE) * (PAGESIZE + 1);

	/* not enough left on the heap */
	if( mem_sbrk( temp ) == NULL )
	  return NULL;

	/* write new header */
	(*writer) = (r_size | FREE_FLAG_MASK);
	
	/* set return pointer */
	best = (writer+=2);

	/* if not enough space left for extra header, footer, and 8-byte data
	   - just over allocate */
	/* store over-allocate amount in temp */
	if( (temp - r_size) < 32 )
	  temp = temp - r_size;
	else
	  temp = 0;

	/* don't bother writing nextfree, write footer */	
	shifter = (char *) (writer);
	shifter += (r_size + temp);
	writer = (long *) shifter;
	(*writer) = (r_size | FREE_FLAG_MASK);

	/* take care of possible free space left */
	if( temp == 0 )
	{
	  writer++;  /* writer points to new header */
	  /* amount of space left is sizeof(chunk between best and end) 
	     - allocated size - sizeof(header) - sizeof(footer) */
	  temp = (long) ((&END_P) - (& best) - r_size - 24);
	  (*writer) = temp;  /* automatically freeflagged */
	  writer+=2;
	  shifter = (char *) writer;
	  shifter += temp;
	  writer = (long *) shifter;
	  (*writer) = temp;

	  /* insert block to free list */
	  shifter -= temp;
	  writer = (long *) shifter;
	  writer--;
	  (*writer) = (long) (*FREESPACE_P);
	  writer--;
	  (*FREESPACE_P) = (long) (&writer);
	}
	
	return best;
	
      }
    }

    /* close enough fit such that there is not enough space left for writing
       a new header size, header next, 8 bytes of data, and footer anyway */
    if( (((*writer)& SIZE_MASK) - r_size) < 32 )
    {
      /* over allocate size - pretend perfect fit and write footer 
	 at end - no need to rewrite size. may return larger chunk than
         requested */

      /* set freeflag  at both header and footer*/
      *writer = (*writer) | FREE_FLAG_MASK;
      shifter = (char *) writer;
      shifter += ((*writer) & SIZE_MASK);
      writer = (long *) shifter;
      *writer = (*writer) | FREE_FLAG_MASK;   /* writer now at footer */

      /* remove it from freelist */
      if( last == FREESPACE_P )   /* no previous - first on list */
      {
	/* write address of the next into  FREESPACE_P - could be 0x0 */
	shifter = (char *) writer;
	shifter -= ((*writer) & SIZE_MASK);
	writer = (long *) shifter; /* writer at size */
	writer++; /* writer at nextfree address */
	*FREESPACE_P = *writer;
      
	/* move to the beginning of writtable block, and return */
	writer++;
	return writer;
      }
      else  /* previous exists - stored in last */
      {
	/* last points to the last's header's size section */

	last++;    /* last now at last's address part */
	writer++;  /* writer now at address part */
	*last = (long) (*writer);  /* last now points to correct nextfree */

	/* move to the beginning of the writable block, and return */
	writer++;
	return writer;
      }
    }
    else if( ((*writer) & SIZE_MASK) < r_size )  /* too small */
    {
      /* probably nothing to do */
    }
    else  /* imperfect fit */
    {
      /* calculate current fit */
      temp = ((*writer) & SIZE_MASK) - r_size;
      
      /* case: better than previous */
      if( temp < min_amount )
      {
	/* update min_amount and best pointer*/
	min_amount = temp;
	best = writer;
      }
      /* case: not better - do nothing */
    }
    
    /* move along writer and last */
    last = writer;
    writer++;  /* get next address - could be 0x0 */
    writer = (long * ) (* writer);
  } 
  while( 1 );
}

void mm_free (void *ptr)
{
  long * writer = (ptr-=2), head = NULL, tail = NULL;
  char * shifter;
  long temp;

  /* if the footer right before ptr has freeflag clear, coalesce back */
  /* if header right after ptr's footer has freeflag clear, coalesce forward */
  
  /* ptr at header of self, writer at footer of previous */
  writer--;

  /* backward coalescing */
  if( ((*writer) & FREE_FLAG_MASK) == 0x0 )
  {
    /* store previous's size in temp */
    temp = ((*writer) & SIZE_MASK);
    shifter = (char *) writer;
    shifter -= temp;  
    writer = (long*) shifter;
    writer-=2;  /* writer and head  points to head of previous */
    head = writer;
    
    /* store new size of coalesced block */
    /* new size = previous's size (in temp) + sizeof(footer) + sizeof(header)
       + sizeof(newly freed area) */
    /* freeflag automatically cleared - old header overwritten */
    (*writer) = (long) (temp + 24 + ((*ptr) & SIZE_MASK)); 
    
    /* automatically added to the freelist */
  }
  else
  {
    /* correct size sofar (without looking at forward coalescing */
    /* just clear bit and set head to point to correct place */
    writer = ptr;
    head = writer;
    (*writer) = ((*writer) & SIZE_MASK);
    
    /* need to add to freelist */
    writer++;
    (* writer) = (long) (* FREESPACE_P);  /* next is the first in list */
    writer--;
    (* FREESPACE_P) = (long) (&writer);   /* make yourself first in list */
  }

  /* update footer */
  /* currently, head points to size part of header, nomatter where, with the 
     correct size, and temp is free to use , and writer is all over the place */

  writer = ptr;
  shifter = (char *) writer;
  shifter += ((*writer) & SIZE_MASK);
  writer = (long *) shifter;   /* writer points to the beginning of footer
				  of space to free */

  /* forward coalesce if next block has freeflag cleared */
  /* forward coalesce like slicing that block out of freelist */
  writer++;
  if( ((*writer) & FREE_FLAG_MASK) == 0x0 )  /* forward coalesce */
  {
    /* increase size by sizeof(header) + sizeof(footer) + forward block size */
    (*head) = (long) (((*head) & SIZE_MASK) + ((*writer) & SIZE_MASK) + 24); 
    
    /* search for pointer towards start of forward block */
    tail = (long *) (*FREESPACE_P);  /* tail points to first free block */
    tail++; /* tail points to first's next (stores numeric address) */

    while( (*tail) != (&writer) )  /* it doesn't point to forward block */
    {
      tail = (long *) (*tail);
      tail++;
    }
    /* tail points to nextfree of block preceding forward block in freelist */

    /* previous points to next - slice out old */
    writer++;
    (*tail) = (long) (*writer);
    
    /* set new tail */
    writer++;  /* writer at forward's writable */
    shifter = (char *) writer;
    writer -=2;  /* to access size */
    shifter += ((*writer) & SIZE_MASK);
    tail = (long *) shifter;  /* tail points to the footer of total block */
    (*tail) = (long) (*head);
  }
  else
  { 
    /* head has the correct size - set new tail accordingly */
    writer--;  /* writer points to footer of calling block again */
    (*writer) = (long) (*head);
    tail = writer;
    
    /* no need to change pointers because already added to list and nothing
       was killed */ 
  }
}

