/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"


team_t team = {
    /* Team name to be displayed on webpage */
    "31251",
    /* First member full name */
    "Sean Corwin",
    /* First member email address */
    "sbc",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


/* global pointers -- f_free_list points to the first free block (or NULL)
if there are no free blocks, start points to dseg_lo (just easier for
pointer arithmetic */

long *f_free_list;
long *start;

int mm_init (void)
{
    /* initialization -- gets a page of memory, puts an 8 byte header
    and at the beginning and end of the heap, each keeping track of the
    size of the block and 0 as the last bit since it is a free block */

    /* if not able to get a page to start return -1 (can't initialize) */
    if ((mem_sbrk(8192)) == NULL) return -1;

    /* start points to beginning of heap */
    start = ((long *)dseg_lo);
    /* header and footer keep size of block */
    *start = 8176;
    *(start+1023) = 8176;

    /* f_free_list points to the first free block, first free block points
    to NULL (no second free block) */
    f_free_list = start + 1;
    *((long **)(start + 1)) = NULL;

    return 0;
}

void *mm_malloc (size_t size)
{
    /* temp variables */
    void *p;
    long *nf = f_free_list;
    long *pf = f_free_list;
    long *temp;
    int blsize;

    /* 8-byte aligns the size and sets blsize (used later) also = size */
    if (!!(size & 7))
	size = (size & -8)+8;
    blsize = size;

    /* first fit -- starts at beginning, looks through all the free blocks
    to find one that fits */
    while (nf != NULL) {
	/* if block is not big enough go to the next free block */
	if ((*(nf - 1)) < size) {
		pf = nf;
		nf = *((long **)nf); }

	/* if the block is big enough, but only to fit the current
	allocation and no further allocation, just give it the entire
	free block */
	else if ((*(nf - 1)) < size + 24) {
		/* set first bit to 1 -- indicates block is allocated */
		*(nf - 1) = (*(nf - 1)) | 1;
		*((nf - 1)+(((*(nf - 1))/8)+1)) = (*(nf - 1));
		p = nf;

		/* update list of free blocks */
		temp = *((long **)nf);
		if (nf == f_free_list)
			f_free_list = temp;
		else
			*((long **)pf) = temp;

		/* return pointer to allocated block */
		return p; }

	/* if the block is big enough and can fit other blocks break the
	block up.  allocate the first part and make the other part a new
	free block */
	else {
		/* create footer for the allocated block, a header for the
		new free block and set they're size values and first bits
		as appropriate */
		*((nf - 1)+((size/8)+2)) = (*(nf - 1)) - size - 16;
		*((nf - 1)+((size/8)+1)) = size | 1;
		*((nf - 1)+(((*(nf - 1))/8)+1)) = (*(nf - 1)) - size - 16;
		*(nf - 1) = size | 1;
		p = nf;

		/* update free block list so it does not include the newly
		allocated block, but includes the new free block */
		temp = *((long **)nf);
		if (nf == f_free_list) {
			nf = nf + (size/8 + 2);
			*((long **)nf) = temp;
			f_free_list = nf; }
		else {
			nf = nf + (size/8 + 2);
			*((long **)nf) = temp;
			*((long **)pf) = nf; }

		/* return pointer to the newly allocated block */
		return p; } }

    /* if there are no free blocks large enough in the heap increase the
    heap size (if possible) to fit */

    /* get the nearest page size to the size of the block */
    if (!!((size+16) & 8191))
	blsize = ((size+16) & -8192) + 8192;

    /* increase the heap size (if possible)*/
    temp = ((long *)(mem_sbrk(blsize)));

    /* if the heap can't be enlarged the block can't be allocated */
    if (temp == NULL)
	return NULL;

    /* if the block fits in the newly created part of the heap, but
    without room for another block, give it the whole part */
    if (blsize - size < 40) {
	/* set first bit to 1 -- indicate it is allocated */
	*temp = (blsize - 16) | 1;
	*(temp+((blsize/8)-1)) = (blsize - 16) | 1; }

    /* if there is enough room to fit more blocks, allocate the first part
    of the block, make the rest a new free block */
    else {
	/* create a footer for the allocated part of the block, a header
	for the new free block, and update the sizes and first bits as
	appropriate */
	*temp = size | 1;
	*(temp+((size/8)+1)) = size | 1;
	*(temp+((size/8)+2)) = blsize - size - 32;
	*(temp+((blsize/8)-1)) = blsize - size - 32;

	/* update free block list so it doesn't include the newly
	allocated block, but includes the new free block */
	nf = temp + (size/8 + 3);
	*((long **)nf) = NULL;
	if (nf == f_free_list)
		f_free_list = nf;
	else 
		*((long **)pf) = nf; }

    /* return a pointer to the allocated block */
    p = temp+1;
    return p;
}

void mm_free (void *ptr)
{
    /* temp variables */
    long *p = (long *)ptr;
    long *temp;

    temp = p + ((*(p-1))/8 + 1);

    /* if the block is the first part of the heap try to coalesce with
    next block (if there is one) and add it to the list of free blocks */
    if ((p - 1) == start) {
	/* if there are no other blocks, just free the block and put it on
	the list of free blocks */
	if ((char *)temp > dseg_hi) {
		*(p - 1) = (*(p - 1)) & -2;
		temp = temp - 1;
		*temp = *(p - 1);
		*((long **)p) = f_free_list;
		f_free_list = p; }

	/* there are other block(s) */
	else
		/* if the next block is allocated, just free the block and
		add it to the list of free blocks */
		if (((*temp) & 1) == 1) {
			*(p - 1) = (*(p - 1)) & -2;
			temp = temp - 1;
			*temp = *(p - 1);
			*((long **)p) = f_free_list;
			f_free_list = p; }

		/* if the next block is free, combine them, update the
		size of the combined block, and add it to the list of free
		blocks */
		else {
			*((long **)p) = *((long **)(temp + 1));
			f_free_list = p;
			temp = temp + ((*temp)/8 + 1);
			*(p - 1) = (*(p - 1)) & -2;
			*temp = (*(p - 1)) + (*temp) + 16;
			*(p - 1) = *temp; } }

    /* if the block is at the end of the heap try to coalesce it with the
    previous block */
    else if ((char *)temp > dseg_hi) {
	/* if the previous block is free, combine them, update the size of
	the combined block and add it to the list of free blocks */
	if (((*(p - 2)) & 1) == 0) {
		temp = p - 2;
		temp = temp - ((*temp)/8 + 1);
		*temp = (*temp) + (((*(p - 1)) & -2)/8) + 16;
		p = p + (((*(p - 1)) & -2)/8);
		*p = *temp; }

	/* if the previous block is allocated, just free the block and add
	it to the list of free blocks */
	else {
		p = p - 1;
		*p = (*p) & -2;
		temp = p + ((*p)/8 + 1);
		*temp = *p;
                for (temp = f_free_list; (*((long **)temp)) != NULL; temp
= *((long **)temp)) {  }
		*((long **)(p + 1)) = *((long **)temp);
		*((long **)temp) = (p + 1); } }
		
    /* free the block and add it to the list of free blocks */
    else {
        *(p - 1) = (*(p - 1)) & -2;
        temp = p + (((*(p - 1)) & -2)/8);
        *temp = *(p - 1);
	if (f_free_list == NULL) {
		*((long **)p) = f_free_list;
		f_free_list = p; }
	else if (f_free_list > p) {
		*((long **)p) = f_free_list;
		f_free_list = p; }
	else {
		for (temp = f_free_list; ((*((long **)temp) != NULL) &&
(*((long **)temp) < p)); temp = *((long **)temp)) {  }
		*((long **)p) = *((long **)temp);
		*((long **)temp) = p; } }
}
