/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "",
    /* First member full name */
    "Sara Epsztein",
    /* First member email address */
    "sarae",
    /* Second member full name (leave blank if none) */
    "Aristiwidya Hardjanto",
    /* Second member email address (blank if none) */
    "abh2"
};

unsigned getSize(unsigned header){
  return (header & (~(1L << 31)));
}

unsigned getStatus(unsigned header){ /* returns 0 or 1 */
  return ((header >> 31) & 1L);
}

/* size has to be smaller than 2^30 */
unsigned getHeader(unsigned size, unsigned status){ 
  return (size | (status << 31));
}

unsigned getFooter(unsigned size, unsigned status){
  return (size | (status << 31));
}



int mm_init (void)
{
	if(mem_sbrk(mem_pagesize()) == NULL) return -1;
        else{
	*((unsigned long *)dseg_lo) = (unsigned long)(dseg_lo+24); /* where to start looking*/
	*((unsigned *)dseg_lo+2)= getHeader(mem_pagesize(),0); /*0-4*/
	*((unsigned *)dseg_lo+3) = getFooter(0,0);    /*4-8*/
	*((unsigned long *)dseg_lo+2) = (unsigned long)(dseg_lo+24);    
  	return 0;
	}
}

void *mm_malloc (size_t size)
{
	unsigned *temp;
	*((unsigned long *)temp) = *(unsigned long *)(dseg_lo);
	size = ((size+7)/8)*8;

	while(*((unsigned long *)temp) != *(unsigned long *)(dseg_hi)){
	  /* perfect fit */
	  if(getSize(*(temp-4))<=(size+16) && getSize(*(temp-4))>=size){
	    *(temp-4) = getHeader(getSize(*(temp-4)),1);/* status only=1 */
	    /* footer stays the same */
	    *((unsigned long *)temp-1) = NULL;       /* allocated */
	    return (char *)temp;
	  }
	  if(getSize(*(temp-4))>(size+16)){
	    /* second part */
	    *(temp+(size/4)) = 
	      getHeader(getSize(getSize(*(temp-4))-4-(size/4)),0);
	    *(temp+1+(size/4)) = 
	      getHeader(size,1); /* previous block */
	   
	    *((unsigned long *)temp+1+(size/8)) = 
	      *((unsigned long *)temp-1);
	    

	    /* first part */		
	    *(temp-4) = getHeader(size,1); /* allocated block */
	    *((unsigned long *)temp-1) = NULL;       /* allocated */
	    /* footer of first block is same */
	    return (char *)temp;
	  }
	  if(getSize(*(temp-4)) < (size+16)) *((unsigned long *)temp) = *((unsigned long *)temp-1);
	  if(*(unsigned long *)temp == *(unsigned long *)(dseg_hi)){
	    if(mem_sbrk(mem_pagesize()) == NULL)return NULL;
	  }
	}
	return NULL;
}

void mm_free (void *ptr)
{
  *((unsigned *)ptr-4) = getHeader(getSize(*((unsigned *)ptr-4)),0);   /* change status to 0 */ 
  
  /* if both previous and after block are allocated --> return */
  if ((getStatus(*((unsigned *)ptr-3)) == 1) && (getStatus(*((unsigned *)ptr +
					       (getSize(*((unsigned *)ptr-4))/4))) == 1)) return;

  /* else: coalesce */
  else {
    
    /*********************************************************/
    /* sizeBefore = getSize(*(temp-3));                      */
    /* sizeAfter  = getSize(*(temp + getSize(*(temp-4))/4)); */
    /*  currSize   = getSize(*(temp-4));                     */
    /*********************************************************/
    
    
    /*********** case 1: both the previous and after are free ********************************/

    if (getStatus(*((unsigned *)ptr-3)) == 0 && getStatus(*((unsigned *)ptr +
                  (getSize(*((unsigned *)ptr-4))/4))) == 0){
      /*** set next_free ***/
      *((unsigned long *)ptr-1) = *((unsigned long *)ptr + (getSize(*((unsigned *)ptr-4)))/8 + 1);  
      *((unsigned long *)ptr - (getSize(*((unsigned *)ptr-3)))/8 - 1) = *((unsigned long *)ptr-1);
      
      /*** set header ***/
      *((unsigned *)ptr-  getSize(*((unsigned *)ptr-3)) - 8) = getHeader(getSize( getSize(*((unsigned *)ptr-3))+ 
                          getSize(*((unsigned *)ptr-4)) + 32 +
			  getSize(*((unsigned *)ptr + getSize(*((unsigned *)ptr-4))/4))),0);
      
      /*** footer stays the same ***/
    }
    
    /************************** case 2: if after is free **********************************/

    else if( getStatus(*((unsigned *)ptr + (getSize(*((unsigned *)ptr-4))/4))) == 0){
      /*** set next_free ***/
      *((unsigned long *)ptr-1) = *((unsigned long *)ptr + (getSize(*((unsigned *)ptr-4)))/8 + 1);
      
      /*** set header ***/
      *((unsigned *)ptr-4) = getHeader(getSize(*((unsigned *)ptr-4)) + getSize(*((unsigned *)ptr + 
                  getSize(*((unsigned *)ptr-4))/4)) + 16,0);
      
      /*** footer does not change ***/
    }

    /******************************** case 3: if before is free ******************************/
    
    else if(getStatus(*((unsigned *)ptr-3)) == 0){
      /*** set header ***/
      *((unsigned *)ptr - 4 - (getSize(*((unsigned *)ptr-3)))/4 - 4) = 
                   getHeader(getSize(*((unsigned *)ptr-3)) + getSize(*((unsigned *)ptr-4)) + 16,0);
      
      /*** set next_free ***/
      *((unsigned long *)ptr - (getSize(*((unsigned *)ptr-3)))/8 - 1) = *((unsigned long *)ptr-1);
      
      /*** footer is the same ***/
    }
  }
}

