/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

/*
We use the first-fit algorithm, using explicit free lists (doubly linked).
We don't use pointers to point to next and previous blocks. Instead we use
integer offsets from desg_lo. To access the start and end of the list, we have
start and end pseudo pointers (which are also offsets from dseg_lo).

When mm_malloc is called, it finds the first free block >= to the required
size and splices it. It splits it and adds the remainder back to the free list
(if there is a remainder). mm_malloc calls mem_sbrk if the heap is too small
or if a block of the required size wasn't found. It coalesces after allocating
more heap space.

mm_free adds the block back to the free list and coalesces wherever possible.

Sometimes we say NULL when we refer to the offsets, but that's because we're 
really tired now and it's nearly time to hand in, but you get what we mean
right?  Just think of our 'pointers' as offsets.  Thank you!
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "The Anti-Functors",
    /* First member full name */
    "Rodney Fu",
    /* First member email address */
    "rfu",
    /* Second member full name (leave blank if none) */
    "Sameer Qureshi",
    /* Second member email address (blank if none) */
    "squreshi"
};



int mm_init (void)
{

  int *end;
  int initial_heap_size = 28;
  int free_block_size;
  int* header = (int*)(dseg_lo+12);

  /*check if already inited */
  if (dseg_hi < dseg_lo)
    mem_sbrk(initial_heap_size);

  /*just check to make sure initialization of heap worked */
  if (dseg_hi < dseg_lo)
    return -1;

  /* set the size of the free block plus the flag 101 */
  free_block_size = (mem_usage() - 11) | 5;

  /* set a pointer to the last footer position */
  end = (int*)(dseg_hi-3);

  /* set the first block to be a pointer to the header of 
     the free block */
  *((int*)dseg_lo) = 12;

  /* set the second block to be a  pointer to the last free block in list */
  *((int*)(dseg_lo+4)) = 12;

  /* set the header of the free block */
  *header = free_block_size;

  /* set the footer of the free block */
  *end = free_block_size;

  /* set pointers within the free block to NULL */
  *((int*)(dseg_lo + 16)) = 0;
  *((int*)(dseg_lo + 20)) = 0;

  return 0;
}


int find_free(size_t size)
{
  /* get the byte offset of the first element in the list */
  int p = *((int*)dseg_lo);

  /* search for a free block while p does not indicate the end of the list */
  while (p != 0) {

    /* if block found is too small, keep searching */
    if ((( (*((int*)(dseg_lo+p)))&-8)-8) < size )
      p = *((int*)(dseg_lo + p + 4));

    /* else we have found a big enough block, so break out of loop */
    else
      break;
  }
  return p;
}


void splice(int p)
{
  /* set pointers to this blocks next and previous data blocks */
  int* myNext = (int*)(dseg_lo+p+4);
  int* myPrevious = (int*)(dseg_lo+p+8);
  
  /* case of single element linked list */
  /* the next and previous blocks are both zero */
  /* just set the start and end pointers to zero too */
  if (*myNext == 0 && *myPrevious == 0) {
    *((int*)dseg_lo) = 0;
    *((int*)(dseg_lo+4)) = 0;
  }

  /* case of first element in list if */
  /* previous block indicates zero */
  else if (*myPrevious == 0) {
    /*setting the start to point to second dude */
    *((int*)dseg_lo) = *myNext;
    /*setting the second dude not to point back to first dude */
    *((int*)(dseg_lo + (*myNext) + 8)) = 0;
  }
  
  /* case of last element in list if */
  /* the next block indicates zero */
  else if (*myNext == 0) {
    /* set previous blocks next pointer to zero */
    *((int*)(dseg_lo + (*myPrevious) + 4)) = 0;
    /* set the end 'pointer' block to store offset of the previous blocks */
    /* header */
    *((int*)(dseg_lo+4)) = *myPrevious;
  }

  /* general case */
  else {
    /*set previous blocks next pointer to next block */
    *((int*)(dseg_lo + (*myPrevious) + 4)) = *myNext;
    /*set next blocks previous pointer to previous block */ 
    *((int*)(dseg_lo + (*myNext) + 8)) = *myPrevious;
  }
}



/* if don't split, return current offset else return offset to remaining */
/* fragment */
int split(int p, int size)
{
  /* round up users requested size to nearest 8 bytes block */
  int newSize = (((size + 7) >> 3) << 3) + 8;
  int oldSize = (*((int*)(dseg_lo + p)))&-8;
  int newHeader;
  int leftsVal;
  int rightsVal;
  char* foot1;
  char* myEnd;
  int* rightsHeader;

  /* if the requested size is below 16 bytes, then just return 16 bytes */
  if (newSize < 16)
    newSize = 16;

  /* check to see if we should split */
  if (oldSize - newSize >= 16) {
    newHeader = ((oldSize - newSize) | 5);

    /* set header1 with appropriate flag */
    *((int*)(dseg_lo + p)) = newSize | 6;

    /* set footer1 */
    foot1 = dseg_lo + p + (newSize - 4);
    *((int*)foot1) = newSize | 6;

    /* set header2 */
    *((int*)(foot1 + 4)) = newHeader;

    /* set footer2 */
    *((int*)(foot1 + (newHeader&-8))) = newHeader;

    /* set the flags for the mem block on the left of what we splice out */
    if (p > 12) {
      leftsVal = *((int*)(dseg_lo + p - 4));
      *((int*)(dseg_lo + p - 4)) = leftsVal | 1;

      /* set the flag in the header for the left dude */
      *((int*)(dseg_lo + p - (leftsVal&-8))) = leftsVal | 1;
    }
    /* return the offset of the fragment created */
    return (((char*) (foot1 + 4))-dseg_lo);
  }
  else {
    /* set our header */
    *((int*)(dseg_lo + p)) = oldSize | 7;

    /* set our footer */
    *((int*)((dseg_lo + p + (oldSize - 4)))) = oldSize | 7;

    /* if left exists, then set left's footer */
    if (p > 12) {
      leftsVal = *((int*)(dseg_lo + p - 4));
      *((int*)(dseg_lo + p - 4)) = leftsVal | 1;

      /* set the flag in the header for the left dude */
      *((int*)(dseg_lo + p - (leftsVal&-8))) = leftsVal | 1;
    }
    /* pointer to this blocks end */
    myEnd = (char*)( dseg_lo + p + oldSize - 1);

    /* if right guy exists */
    if (myEnd != dseg_hi){
      rightsHeader = (int*)(myEnd+1);
      rightsVal = *((int*)rightsHeader);

      /* set header of right guy */
      *rightsHeader = rightsVal | 4;

      /* set footer of right guy */
      *((int*) (((char*)rightsHeader) + ((rightsVal&-8) -4))) = rightsVal | 4;
    }
    return p;
  }
}


void addBack(int fragment)
{

  int lastElement;

  if (*((int*)dseg_lo) == 0) {
    /* set the start pointer to point to fragments header */
    *((int*)dseg_lo) = fragment;

    /* setting the next and previous pointers to zero */
    *((int*)(dseg_lo + fragment + 4)) = 0;
    *((int*)(dseg_lo + fragment + 8)) = 0;

    /*end pointer to point to next pointer */
    *((int*)(dseg_lo + 4)) = fragment;
  } 
  else {
    lastElement = *((int*)((dseg_lo)+4));

    /* set the previous guys next pointer to point to fragment */
    *((int*)(dseg_lo + lastElement + 4)) = fragment;

    /* set fragments previous pointer to point to old last guy of list */
    *((int*)(dseg_lo+fragment+8)) = lastElement;

    /* set end pointer to point to fragment */
    *((int*)((dseg_lo)+4)) = fragment;

    /* set fragment's next pointer to NULL */
    *((int*)(dseg_lo+fragment+4)) = 0;
  }
}


void *mm_malloc (size_t size)
{
  /* find an available block */
  int p = find_free(size);
  int fragment;
  int temp;
  int leftBlockFlag;
  int leftBlockValue;
  int increaseHeap = 8192;
  int newSize;
  char* EMERGENCY_FAILSAFE;

  /* if available block exists */
  if (p != 0) {
    splice(p);
    fragment = split(p,size);

    if (fragment != p)
      addBack(fragment);
  }
  else {
    newSize = (((size + 7) >> 3) << 3) + 16;
    if (newSize > increaseHeap)
      increaseHeap = newSize;

    /* get offset from dseg_lo */
    EMERGENCY_FAILSAFE = mem_sbrk(increaseHeap);
    if (EMERGENCY_FAILSAFE == NULL)
      return EMERGENCY_FAILSAFE;

    temp = EMERGENCY_FAILSAFE - dseg_lo;

    /* getting the middle flag of the block on the left */
    leftBlockValue = (*((int*)(dseg_lo + temp - 4)));
    leftBlockFlag = leftBlockValue &2;
    
    if (leftBlockFlag == 0) {
      /* set new header value of the new block */
      *((int*)(dseg_lo + temp - (leftBlockValue&-8))) = 
	((leftBlockValue&-8) + increaseHeap) | 5;
	
      /* set the footer value of the new block */
      *( (int*) (dseg_hi-3)) = ((leftBlockValue&-8) + increaseHeap) | 5;
    }
    else {
      /*setting the new header and footer value for this block if previous */
      /* already taken */
      *((int*)(dseg_lo + temp)) = increaseHeap | 5;
      *( (int*) (dseg_hi-7)) = increaseHeap | 5;
      
      addBack(temp);
    }
    p = find_free(size);
    splice(p);
    fragment = split(p,size);
    if (fragment !=p)
      addBack(fragment);
  }
  return (void*)(dseg_lo+p+4);  
}


void mm_free (void *ptr)
{
  int p = ((char*)ptr - dseg_lo) - 4;
  char* myEnd;
  int extractFlag = *((int*)(dseg_lo + p)) & 7;
  int mySize = (*((int*)(dseg_lo+p))) &-8;
  int checkL=0;  /* if left exists, set to 1 else 0 */
  int checkR=0;
  int leftSize = 0;
  int leftHeader;
  int rightSize = 0;
  int rightHeader;
  int sizeAndFlag;
  int myNewSize;

  myEnd = (char*)(dseg_lo + p + mySize - 1);   

  /* check if left and right guys */
  if ( p > 12 ) {
    checkL = 1;
    leftHeader = *((int*)(dseg_lo + p-4));
    leftSize = leftHeader&-8;
  }
  
  if (myEnd != dseg_hi) {
    checkR = 1;
    rightHeader = *((int*)(myEnd+1));
    rightSize = rightHeader &-8;
  }

  /* case 1 (same cases as lecture notes, please refer there) */
  if (extractFlag == 7) {
    if (checkL == 1) {
      sizeAndFlag = (leftHeader&-4) | 2;
      /* set left footer */
      *((int*)(dseg_lo+p-4)) = sizeAndFlag;
      /* set left header */
      *((int*)(dseg_lo + p - leftSize)) = sizeAndFlag;
    }
    if (checkR == 1) {
      sizeAndFlag = (rightHeader&-7) | 2;
      /* set right header */
      *((int*)(dseg_lo + p + mySize)) = sizeAndFlag;
      /* set right footer */
      *((int*)(dseg_lo + p + mySize + rightSize - 4)) = sizeAndFlag;
    }
    /* set own header */
    *((int*)(dseg_lo+p)) = mySize | 5;
    /* set own footer */
    *((int*)(myEnd - 3)) = mySize | 5;
    addBack(p);
  }

  /* case 2 */
  else if (extractFlag == 6) {
    myNewSize = mySize + rightSize;
    if (checkL == 1) {
      sizeAndFlag = (leftHeader&-4) | 2;
      /* set left footer */
      *((int*)(dseg_lo+p-4)) = sizeAndFlag;
      /* set left header */
      *((int*)(dseg_lo + p - leftSize)) = sizeAndFlag;
    }
    /* splice next block out of list */
    splice(((char*)(myEnd + 1))-dseg_lo);
    /* set own header */
    *((int*)(dseg_lo+p)) = myNewSize | 5;
    /* set own footer */
    *((int*) (dseg_lo+ p + (myNewSize - 4))) = myNewSize | 5;
    addBack(p);
  } 

  else if (extractFlag == 3) {

    /* set footer of the new block */
    *((int*)(myEnd-3)) = (mySize + leftSize) | 5;
    
    /* set header of the new block guy */
    *((int*)(dseg_lo + p - leftSize)) = (mySize + leftSize) | 5;

    if (checkR ==1) {
      sizeAndFlag = (rightHeader&-7) | 2;
      /* set right header */
      *((int*)(dseg_lo+p + mySize)) = sizeAndFlag;
      /* set right footer */
      *((int*)(dseg_lo+ p + mySize + rightSize - 4)) = sizeAndFlag;
    }
  } 
  else {
    splice(((char*)(myEnd+1))-dseg_lo);
    /* set header and footer of mega block */
    *((int*)(dseg_lo + p - leftSize)) = (mySize + leftSize + rightSize) | 5;
    *((int*)(dseg_lo + p + mySize + rightSize - 4)) = 
      (mySize + leftSize + rightSize) | 5;
  }
}

