/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Remington",
    /* First member full name */
    "Rim Svarcas",
    /* First member email address */
    "ras",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/*
   Suggestion:  Look at this file with syntax highlighting in XEmacs.
   It makes the comments stick out well -- otherwise it might be confusing.

   This is a best-fit linked list algorithm.  For a given block (pointed to
   by an unsigned long int ** pointer) i, we have the following:

   i       address of block
   *i      address of next sequential block in heap
             - low order bit is 1 if block is allocated, 0 otherwise
	     - second lowest bit is 1 if there is no next block, 0 if there is
   *(i+1)  address of previous block in heap
             - is NULL if there is no previous block (i.e. this is first block)
   
   If the block is unallocated, then the following is also true
   (Note that the smalles possible blocksize is 32 bytes.)

   *(i+2)  address of next free block in free list (NULL if none)
   *(i+3)  address of previous free block in free list (NULL is none)

   We find the size of a block by taking the address of the next block, 
   masking off the lowest two bits, and subtracting the address of the
   current block from it.  This is what the macro SIZE(p) does.  Hence
   SIZE(i) will return the size of block i as an unsigned long int.

   The other macros:
        FIRST(p)   returns whether p is the first block in the heap
	END(p)     returns whether p is the last block in the heap
	ALLOC(p)   returns whether p is an allocated block

   *dseg_lo contains the address of the last block in the heap.
   *(dseg_lo + 1) contains the address of the first block in the free list.
   Blocks start at dseg_lo + 3, rounded up to the nearest 8.
   (Note:  we're assuming dseg_lo has been cast to an unsigned long int **).

   insfl(i)  takes an unallocated block i and inserts it into the free list
   delfl(i)  takes block i out of the free list
   Blocks in free list are sorted in nondecreasing order by size.
 */

#define SIZE(p) (((unsigned long int)(*(p)) & -4L) - ((unsigned long int)(p) & -4L))
#define FIRST(p) ((*((p)+1)) == NULL)
#define END(p) ((unsigned long int)(*(p)) & 2L)
#define ALLOC(p) ((unsigned long int)(*(p)) & 1L)

void delfl(unsigned long int **t)
{
  /*
    For comments, assume these name for blocks

        | prev |---| t = cur |---| next |
   */
  unsigned long int **h;
  h = ((unsigned long int **)dseg_lo + 1); /* h = head of free list */
  if (*(t+2) != NULL) /* if there is a next block */
  {
    if (*(t+3) != NULL) /* if there is a previous block */
    {
      *((*(t+3))+2) = (unsigned long int)*(t+2); /* prev->next = next */
      *((*(t+2))+3) = (unsigned long int)*(t+3); /* next->prev = prev */
    }
    else /* if there is no previous block */
    {
      *((*(t+2))+3) = NULL; /* next->prev = NULL */
      *h = *(t+2); /* head = next */
    }
  }
  else /* if there is no next block */
  {
    if (*(t+3) != NULL) /* if there is a previous block */
      *((*(t+3))+2) = NULL; /* prev->next = NULL */
    else /* if there is no previous block */
      *h = NULL; /* head = NULL */
  }
}

void insfl(unsigned long int **t)
{
  unsigned long int **i, **h;
  h = ((unsigned long int **)dseg_lo + 1);
  if (*h == NULL) /* if free list is empty, insert t here */
  {
    *h = (unsigned long int *)t;
    *(t+2) = NULL;
    *(t+3) = NULL;  
    return;
  }
  i = (unsigned long int **)*h;
  /* run through free list until we find where to put t */
  while ((SIZE(i) < SIZE(t)) && (*(i+2) != NULL))
    i = (unsigned long int **)*(i+2);
  if (SIZE(i) >= SIZE(t)) /* if t goes before i, put it there */
  {
    if (*(i+3) != NULL)
      *((*(i+3))+2) = (unsigned long int)t;
    else
      *h = (unsigned long int *)t;
    *(t+3) = *(i+3);
    *(t+2) = (unsigned long int *)i;
    *(i+3) = (unsigned long int *)t;
  }
  else /* t goes after i, which is at the end of the free list */
  {
    *(i+2) = (unsigned long int *)t;
    *(t+3) = (unsigned long int *)i;
    *(t+2) = NULL;
  }
}

int mm_init (void)
{
  unsigned long int **i;
  if (mem_usage() < 0)
    i = mem_sbrk(48L);
  if (i == NULL)
    return (-1);
  i = (unsigned long int **)(((((unsigned long int)dseg_lo) - 1L) & -8L) + 24L);
  *((unsigned long int **)dseg_lo) = (unsigned long int *)i;
  *((unsigned long int **)dseg_lo + 1) = (unsigned long int *)i;
  *i = (unsigned long int *)(((unsigned long int)dseg_hi + 1L) | 2L);
  *(i+1) = NULL;
  *(i+2) = NULL;
  *(i+3) = NULL;  
  return 0;  /* No problems */
}

void *mm_malloc (size_t size)
{
  unsigned long int **i, **p, **t;
  unsigned long int sneed = (((size - 1L) & -8L) + 24L);
  if (sneed < 32L) /* "size needed" is at least 32 bytes */
      sneed = 32L;
  i = (unsigned long int **)*((unsigned long int **)dseg_lo + 1); /* i = head of free list */
  if (i == NULL) /* if free list is empty, grab more space */
  {
    i = mem_sbrk(sneed);
    if (i == NULL)
      return (NULL);
    *((unsigned long int **)dseg_lo) = (unsigned long int *)i;
    *((unsigned long int **)dseg_lo + 1) = (unsigned long int *)i;
    *i = (unsigned long int *)(((unsigned long int)dseg_hi + 1L) | 2L);
    *(i+1) = NULL;
    *(i+2) = NULL;
    *(i+3) = NULL;
  }
  /* run through free list until we find a block big enough */
  while ((SIZE(i) < sneed) && (*(i+2) != NULL))
    i = (unsigned long int **)*(i+2);
  p = (unsigned long int **)*(i+1);
  if (SIZE(i) >= sneed) /* if we found a block big enough, allocate it! */
  {
    delfl(i);
  allocate:
    if ((SIZE(i) - sneed) > 31L) /* if block is big enough to be split */
    {
      t = (unsigned long int **)((unsigned long int)i + sneed);
      *t = *i;
      *(t+1) = (unsigned long int *)i;
      if (!END(i))
	*((*i)+1) = (unsigned long int)t;
      *i = (unsigned long int *)t;
      if ((unsigned long int)*((unsigned long int **)dseg_lo) == (unsigned long int)i)
	*((unsigned long int **)dseg_lo) = (unsigned long int *)t;
      insfl(t);
    }
    *i = (unsigned long int *)((unsigned long int)*i | 1L);
    return ((void *)(i+2));
  }
  /* no blocks big enough -- grab more space and allocate it */
  p = (unsigned long int **)*((unsigned long int **)dseg_lo);
  i = mem_sbrk(sneed);
  if (i == NULL)
      return (NULL);
  *p = (unsigned long int *)((unsigned long int)*p & -3L);
  *i = (unsigned long int *)(((unsigned long int)dseg_hi + 1L) | 2L);
  *(i+1) = (unsigned long int *)p;
    *((unsigned long int **)dseg_lo) = (unsigned long int *)i;
  goto allocate;
}

void mm_free (void *ptr)
{
  /*
    For the comments, assume i is the block being freed, and these are
    the blocks in the heap.

       | prev |---| p |---| i |---| next |
   */
  unsigned long int **i, **p;
  i = ((unsigned long int **)ptr - 2);
  p = (unsigned long int **)*(i+1); /* p is previous block */
  *i = (unsigned long int *)((unsigned long int)*i & -2L);
  if ((!END(i)) && (!(**i & 1L))) /* if next && next is free, coalesce */
  {
    delfl((unsigned long int **)*i);
    if (!(**i & 2L)) /* if next->next */
      *(((unsigned long int **)**i) + 1) = (unsigned long int *)i; /* next->next->prev = i */
    else
      *((unsigned long int **)dseg_lo) = (unsigned long int *)i; /* head of free list = i */
    *i = (unsigned long int *)**i; /* i->next = next->next */
  }
  if ((p != NULL) && (!ALLOC(p))) /* if p && p is free, coalesce */
  {
    delfl(p);
    if (!((unsigned long int)*i & 2L)) /* if next */
      *((*i)+1) = (unsigned long int)p; /* next->prev = p */
    else
      *((unsigned long int **)dseg_lo) = (unsigned long int *)p; /* head of free list = p */
    *p = (unsigned long int *)(((unsigned long int)*i)); /* p->next = next */
    i = p;
  }
  insfl(i);
}
