/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Remington",
    /* First member full name */
    "Rim Svarcas",
    /* First member email address */
    "ras",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

#define SIZE(p) (((unsigned long int)(*(p)) & -4L) - ((unsigned long int)(p) & -4L))
#define FIRST(p) ((*((p)+1)) == NULL)
#define END(p) ((unsigned long int)(*(p)) & 2L)
#define ALLOC(p) ((unsigned long int)(*(p)) & 1L)

void delfl(unsigned long int **t)
{
  unsigned long int **h;
  h = ((unsigned long int **)dseg_lo + 1);
  if (*(t+2) != NULL)
  {
    if (*(t+3) != NULL)
    {
      *((*(t+3))+2) = (unsigned long int)*(t+2);
      *((*(t+2))+3) = (unsigned long int)*(t+3);      
    }
    else
    {
      *((*(t+2))+3) = NULL;
      *h = *(t+2);
    }
  }
  else
  {
    if (*(t+3) != NULL)
      *((*(t+3))+2) = NULL;
    else
      *h = NULL;      
  }
}

void insfl(unsigned long int **t)
{
  unsigned long int **i, **h;
  h = ((unsigned long int **)dseg_lo + 1);
  if (*h == NULL)
  {
    *h = (unsigned long int *)t;
    *(t+2) = NULL;
    *(t+3) = NULL;  
    return;
  }
  i = (unsigned long int **)*h;
  while ((SIZE(i) < SIZE(t)) && (*(i+2) != NULL))
    i = (unsigned long int **)*(i+2);
  if (SIZE(i) >= SIZE(t))
  {
    if (*(i+3) != NULL)
      *((*(i+3))+2) = (unsigned long int)t;
    else
      *h = (unsigned long int *)t;
    *(t+3) = *(i+3);
    *(t+2) = (unsigned long int *)i;
    *(i+3) = (unsigned long int *)t;
  }
  else
  {
    *(i+2) = (unsigned long int *)t;
    *(t+3) = (unsigned long int *)i;
    *(t+2) = NULL;
  }
}

int mm_init (void)
{
  unsigned long int **i;
  if (mem_usage() < 0)
    i = mem_sbrk(48L);
  if (i == NULL)
    return (-1);
  i = (unsigned long int **)(((((unsigned long int)dseg_lo) - 1L) & -8L) + 24L);
  *((unsigned long int **)dseg_lo) = (unsigned long int *)i;
  *((unsigned long int **)dseg_lo + 1) = (unsigned long int *)i;
  *i = (unsigned long int *)(((unsigned long int)dseg_hi + 1L) | 2L);
  *(i+1) = NULL;
  *(i+2) = NULL;
  *(i+3) = NULL;  
  return 0;  /* No problems */
}

void *mm_malloc (size_t size)
{
  unsigned long int **i, **p, **t;
  unsigned long int sneed = (((size - 1L) & -8L) + 24L);
  if (sneed < 32L)
      sneed = 32L;
  i = (unsigned long int **)*((unsigned long int **)dseg_lo + 1);
  if (i == NULL)
  {
    i = mem_sbrk(sneed);
    if (i == NULL)
      return (NULL);
    *((unsigned long int **)dseg_lo) = (unsigned long int *)i;
    *((unsigned long int **)dseg_lo + 1) = (unsigned long int *)i;
    *i = (unsigned long int *)(((unsigned long int)dseg_hi + 1L) | 2L);
    *(i+1) = NULL;
    *(i+2) = NULL;
    *(i+3) = NULL;
  }
  while ((SIZE(i) < sneed) && (*(i+2) != NULL))
    i = (unsigned long int **)*(i+2);
  p = (unsigned long int **)*(i+1);
  if (SIZE(i) >= sneed)
  {
    delfl(i);
  allocate:
    if ((SIZE(i) - sneed) > 31L)
    {
      t = (unsigned long int **)((unsigned long int)i + sneed);
      *t = *i;
      *(t+1) = (unsigned long int *)i;
      if (!END(i))
	*((*i)+1) = (unsigned long int)t;
      *i = (unsigned long int *)t;
      if ((unsigned long int)*((unsigned long int **)dseg_lo) == (unsigned long int)i)
	*((unsigned long int **)dseg_lo) = (unsigned long int *)t;
      insfl(t);
    }
    *i = (unsigned long int *)((unsigned long int)*i | 1L);    
    return ((void *)(i+2));
  }
  p = (unsigned long int **)*((unsigned long int **)dseg_lo);
  i = mem_sbrk(sneed);
  if (i == NULL)
      return (NULL);
  *p = (unsigned long int *)((unsigned long int)*p & -3L);
  *i = (unsigned long int *)(((unsigned long int)dseg_hi + 1L) | 2L);
  *(i+1) = (unsigned long int *)p;
  *((unsigned long int **)dseg_lo) = (unsigned long int *)i;
  goto allocate;
}

void mm_free (void *ptr)
{
  unsigned long int **i, **p;
  i = ((unsigned long int **)ptr - 2);
  p = (unsigned long int **)*(i+1);
  *i = (unsigned long int *)((unsigned long int)*i & -2L);
  if ((!END(i)) && (!(**i & 1L))) /* if next && next is free */
  {
    delfl((unsigned long int **)*i);
    if (!(**i & 2L)) /* if next->next */
      *(((unsigned long int **)**i) + 1) = (unsigned long int *)i; /* next->next->prev = i */
    else
      *((unsigned long int **)dseg_lo) = (unsigned long int *)i;
    *i = (unsigned long int *)**i; /* i->next = next->next */
  }
  if ((p != NULL) && (!ALLOC(p))) /* if p && p is free */
  {
    delfl(p);
    if (!((unsigned long int)*i & 2L)) /* if next */
      *((*i)+1) = (unsigned long int)p; /* next->prev = p */
    else
      *((unsigned long int **)dseg_lo) = (unsigned long int *)p;
    *p = (unsigned long int *)(((unsigned long int)*i)); /* p->next = next */
    i = p;
  }
  insfl(i);
}
