/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "The Players",
    /* First member full name */
    "Rim Svarcas",
    /* First member email address */
    "ras",
    /* Second member full name (leave blank if none) */
    "Nathan Z Clark",
    /* Second member email address (blank if none) */
    "nzc"
};

int mm_init (void)
{
  unsigned long int *i, **p;
  if (mem_usage() < 0)
    i = mem_sbrk(mem_pagesize());
  p = (unsigned long int **)dseg_lo;
  *p = NULL;
  return 0;  /* No problems */
}

void *mm_malloc (size_t size)
{
  unsigned long int **i, **t;
  unsigned long int len;
  for(i = (unsigned long int **)dseg_lo; 1; i = (unsigned long int **)(((unsigned long int)*i) & -2L))
  {    
    if (((unsigned long int)*i & -2L) == 0L) /* if at end of list */
      len = ((unsigned long int)dseg_hi - (unsigned long int)i - 7L); /* number of free bytes in block */
    else
      len = (((unsigned long int)*i & -2L) - (unsigned long int)i - 8L); /* number of free bytes in block */
    if (((!(unsigned long int)*i) & 1L) && (len >= size)) /* if block free and large enough */
    {
      if (len - size > 15L) /* if need to split block */
      {
	t = (unsigned long int **)((((unsigned long int)i + 7L + size) & -16L) + 16L);
	*t = *i;
	*i = (unsigned long int *)t;
      }
      *i = (unsigned long int *)((unsigned long int)*i | 1L); /* mark block as allocated */
      if ((unsigned long int)(i+1) & 7L)
      {
	printf("\n\nWhy the hell is this unaligned?\nreturning 0x%p\n\n", (i+1));
	exit(-1);
      }
      return (void *)(i + 1);
    }
    if (((unsigned long int)*i & -2L) == 0L)
      break;
  }
  /* No free blocks large enough -- grab more heap space and try again */
  len = mem_pagesize();
  t = (unsigned long int **)mem_sbrk(len);
  if (t != NULL) /* if got more heap space */
  {
    if (((unsigned long int)*i) & 1L) /* if last block is allocated */
    {
      *i = (unsigned long int *)t;
      *t = NULL;
    }
    return ( mm_malloc(size) );
  }
  return NULL;
}

void mm_free (void *ptr)
{
  unsigned long int **i, **p;
  assert(ptr != NULL);
  i = (unsigned long int **)dseg_lo;
  for(p = i; ((i+1) != ptr && (((unsigned long int)*i & -2L) != 0L)); i = (unsigned long int **)(((unsigned long int)*i) & -2L))
    p = i;
  if ((i+1) != ptr)
  {
    printf("FUCK ME!!!!\n");
    return;
  }
  *i = (unsigned long int *)((unsigned long int)*i & -2L);
  if ((((unsigned long int)*i) != 0L) && (!(**i & 1L)))
    *i = (unsigned long int *)(**i);
  if ((!((unsigned long int)*p & 1L)) && (p != i))
    *p = *i;
}
