/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include <limits.h>

#include "memlib.h"
#include "malloc.h"

extern char * dseg_lo;
extern char * dseg_hi;

#define FREELIST_HEAD ((long int *)(dseg_lo))
#define PAGESIZE ((mem_pagesize() + 1) >> 1) << 1

#define MAXSIZE INT_MAX >> 1 << 1

team_t team = {
    /* Team name to be displayed on webpage */
    "whatever!",
    /* First member full name */
    "Ryan Prichard",
    /* First member email address */
    "prichard@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Yao Yew Wang",
    /* Second member email address (blank if none) */
    "yew@andrew.cmu.edu"
};

/*
  mm_init basically initiallizes the first and third to last block
  of the heap to the appropriate block size. It also assigns the
  second to last block to the value of MAXSIZE. This way, when malloc
  hit's this point, it knows to allocate more space.
 */

int mm_init (void)
{
  int size;

  long int *freelist_head = FREELIST_HEAD;                                  

  if (mem_usage() != -1) 
    return -1;

  mem_sbrk(PAGESIZE);

  size = ((((PAGESIZE - 2) >> 3) + 1) >> 1) << 1;
  
  *freelist_head = size;
  *(freelist_head + size - 1) = size;
  *(freelist_head + size) = MAXSIZE;
  return 0;
    
}

/*
  This is a first-fit algorithm that implements a header and a footer
  to point to the next and previous allocated/unallocated parts of the heap
  I increment the heap by PAGESIZE when it hits the end. If the program 
  try's to allocate something bigger than the PAGESIZE it keeps looping
  incrementing PAGESIZE (local var) until PAGESIZE is larger than size needed
  for allocation.
 */

void *mm_malloc (size_t size)
{
  long int *freelist_head = FREELIST_HEAD;  

  if (size <= 0) 
    return NULL;

  else {
    int oldsize;
    long int h_size= (((((size-1) / 8) + 3) + 1) >> 1) << 1;
    
    while ((*freelist_head & 1) || (*freelist_head < h_size)) 
      freelist_head = freelist_head + (*freelist_head & -2);
     
    if (*freelist_head == MAXSIZE) { 
      int pagesize = PAGESIZE; 
      char *check;
      int new_size;

      while (pagesize <= (size + 16))
	pagesize += PAGESIZE;

      check = mem_sbrk(pagesize);
      new_size = (((pagesize / 8)) >> 1) << 1;

      if (! check) {
	printf("out of pages\n");
	return NULL;
      }

      *freelist_head = new_size;
      *(freelist_head + ((*freelist_head) & -2) - 1) = new_size;  
      *(freelist_head + ((*freelist_head) & -2)) = MAXSIZE;
    }
    
    oldsize = *freelist_head & -2;

    *freelist_head = h_size | 1;
    *(freelist_head + h_size - 1) = h_size | 1;

    if (h_size < oldsize) {
      *(freelist_head + h_size) = oldsize - h_size;
      *(freelist_head + oldsize - 1) = oldsize - h_size;
    }
    return (void *)(freelist_head + 1);
  }

}

/*
  This is a coalescing version of free that looks at the next
  and previous elements and coalesces with either/both of them
  (if possible).
 */

void mm_free (void *ptr)
{
  int oldvalue;
  int previous_val;
  
  long int *previous;
  long int *next;
  long int *delete = (long int *)ptr;

  delete = delete - 1;

  oldvalue = *delete & -2;
  previous_val = (*(delete - 1) & -2);
  
  next = delete + oldvalue;
  previous = (delete - previous_val);

  if ((*next & 1) && (*previous & 1)) {
    *delete = *delete & -2;
  }
  
  else if (((*next & 1) == 0) && (*previous & 1) && ((*next) != MAXSIZE)) {
    *delete = oldvalue + *next;
    *(delete + ((*delete) - 1)) = *delete;
  }
  else if (((*next & 1) == 0) && (*previous & 1) && (*(next) == MAXSIZE)) {
    *delete = *delete & -2;
  }
  else if ((*next & 1) && ((*previous & 1) == 0)) {
    *previous = *previous + oldvalue;
    *(delete + oldvalue - 1) = *previous;
  }
  else if (((*next & 1) == 0) && ((*previous & 1)==0) && ((*next) != MAXSIZE)){
    int sum = oldvalue + (*previous) + (*next);
    *previous = sum;
    *(next + (*next - 1)) = sum;
  }
  else if (((*next & 1) == 0) && ((*previous & 1)==0) && ((*next) == MAXSIZE)) {
    *previous = *previous + oldvalue;
    *(delete + oldvalue - 1) = *previous;
  }
}

