/*The structure is a First Fit algorithm with a header pointing to next block, and a footer
 *pointing to header. Does coellecing. A block is signfied as used if lowest order bit of header
 *is 1(also footer), an free if lowest order bit of header is 0(also footer)
*/

/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Flying Wombat",
    /* First member full name */
    "Nathan Z Clark",
    /* First member email address */
    "nzc",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

int mm_init (void)
{
  unsigned long int *i, **p;

  //if there is no space allocated, the allocates one page
  if (mem_usage() < 0)
    i = mem_sbrk(mem_pagesize());

  //if error return -1
  if (i == NULL) return -1;

  //set what p points to NULL so the heap is considered empty then return 0
  p = (unsigned long int **)dseg_lo;
  *p = NULL;
  return 0;
}

void *mm_malloc (size_t size)
{
  unsigned long int **i, **t, **t2;
  unsigned long int rsize;

  rsize = ((size+7)>>3)<<3;
  i = (unsigned long int **)dseg_lo;
  t = i;

  //while *t != NULL and there is either no room or the block is being used.
  while ((*t!=NULL) && 
         ((((unsigned long int)*t - (unsigned long int)(t+1))<rsize) ||
          ((((unsigned long int)*t)&1L)==1)))
     t = (unsigned long int **) ((((unsigned long int)*t)>>1)<<1);

  if (*t==NULL)
  //If no sufficient free block was found
  {
     unsigned long int remspace = (unsigned long int)dseg_hi - (unsigned long int)(t+1);
     
     //If there is not enough space left in the heap to add the block, then allocates the space
     //needed
     if (remspace < rsize + 16)
     {
        //If mem_sbrk returns NULL, then return NULL
        if (mem_sbrk(16 + rsize - remspace) == NULL)
           return NULL;
     }

     //Set header to point to header of next block and set footer to point to header
     *t = (unsigned long int *)(((unsigned long int)t + 16 + rsize) | 1L);
     i = t + 1;
     t = (unsigned long int **) ((((unsigned long int)*t)>>1)<<1);
     *t=NULL;
     t = t - 1;
     *t = (unsigned long int *)((unsigned long int)(i - 1) | 1L);
  }
  else
  //If a free block was found with sufficient space
  {

     i = t + 1;
     *t = (unsigned long int *) ((unsigned long int)*t | 1L);
     t = (unsigned long int **) ((((unsigned long int)*t)>>1)<<1) - 1;
     *t = (unsigned long int *) ((unsigned long int)*t | 1L);

     if ((((unsigned long int)t - (unsigned long int)i-rsize)>=32) &&
         ((unsigned long int)t - (unsigned long int)i > rsize))
     //Break the free block up if there are going to be 32 or more free blocks left
     //32 was chosen because header and footer is 16 bytes so want at least 1:1 ratio
     //for (header+footer):(free space)
     {
        //Sets the header to point header of the new split block
        //Then sets block before split block's header to be footer which points to original
        //header
        //Then sets split block header to point to next block (same as place original header
        //pointed to).
        //Then sets footer to point to new split block header
        t2 = i-1;
        *t2 = (unsigned long int *)(((unsigned long int)i + rsize + 8) | 1L);
        t2 = (unsigned long int **)((((unsigned long int)*t2)>>1)<<1) - 1;
        *t2 = (unsigned long int *)((unsigned long int)(i-1) | 1L);
        t2 = t2 + 1;
        *t2 = (unsigned long int *)((unsigned long int)(t+1) & ~1L);
        *t = (unsigned long int *)t2;
      
     }
  }
  return i;
}

void mm_free (void *ptr)
{

  unsigned long int **i, **t, **left, **right;
  int left_free = FALSE, right_free = FALSE;

  // Set the block as unused
  i = (unsigned long int **)ptr - 1;
  *i = (unsigned long int *) ((unsigned long int)*i & (~1L));
  t = (unsigned long int **)*i - 1;
  *t = (unsigned long int *) ((unsigned long int)*t & (~1L));

  //If not at beginning of heap and the previous block is free then left_free = TRUE
  if (i > (unsigned long int **)dseg_lo)
  {
     t = i - 1;
     if ( (((unsigned long int)*t)&1L) == 0 )
        left_free = TRUE;
  }
 
  //If next block is free then right_free = TRUE
  t = (unsigned long int **)*i;
  if ( (((unsigned long int)*t)&1L) == 0 )
     right_free = TRUE;

  if (left_free && right_free)
  //Coellece with left and right sides
  {
     left = (unsigned long int **)*(i - 1);
     right = (unsigned long int **)*((unsigned long int **)*i) - 1;
  }
  else if (left_free && !right_free)
  //Coellece with left side
  {
     left = (unsigned long int **)*(i - 1);
     right = (unsigned long int **)*i - 1;
  }
  else if (!left_free && right_free)
  //Coellece with right side
  {
     left = i;
     right = (unsigned long int **)*((unsigned long int **)*i) - 1;
  }
  else if (!left_free && !right_free)
  //No coellecing
  {
     left = i;
     right = (unsigned long int **)*i -1;
  }
  //If error occured with coellece, then don't commit the change.
  if (left != NULL)
  {
     *left = (unsigned long int *)(right + 1);
     if (*left != NULL)
        *right = (unsigned long int *)left;
  }
}
